/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.gui;

import java.io.IOException;
import minechem.block.tile.TileDecomposer;
import minechem.client.gui.GuiContainerTabbed;
import minechem.client.gui.GuiFluidTank;
import minechem.client.gui.widget.tab.TabDecomposerState;
import minechem.client.gui.widget.tab.TabHelp;
import minechem.container.ContainerDecomposer;
import minechem.init.ModGlobals;
import minechem.utils.MinechemUtil;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;

public class GuiDecomposer
extends GuiContainerTabbed {
    private TileDecomposer decomposer;
    private GuiFluidTank guiFluidTank;
    private GuiButton dumpButton;
    int guiWidth = 176;
    int guiHeight = 186;

    public GuiDecomposer(InventoryPlayer inventoryPlayer, TileDecomposer decomposer) {
        super(new ContainerDecomposer(inventoryPlayer, decomposer));
        this.field_146999_f = this.guiWidth;
        this.field_147000_g = this.guiHeight;
        this.decomposer = decomposer;
        this.addTab(new TabDecomposerState((Gui)this, decomposer));
        this.addTab(new TabHelp(this, MinechemUtil.getLocalString("help.decomposer")));
        this.guiFluidTank = new GuiFluidTank(decomposer.getTankCapacity(), 18, 16);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.dumpButton = new GuiButton(0, this.field_147003_i + 37, this.field_147009_r + 17, 12, 12, "x");
        this.field_146292_n.add(this.dumpButton);
    }

    @Override
    public void func_73863_a(int mX, int mY, float pticks) {
        super.func_73863_a(mX, mY, pticks);
        boolean bl = this.dumpButton.field_146124_l = this.decomposer.tank.getFluidAmount() > 0;
        if (this.dumpButton.func_146115_a() && this.decomposer.tank.getFluidAmount() > 0) {
            this.func_146279_a("Dump " + this.decomposer.tank.getFluid().getLocalizedName(), mX, mY);
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        String info = MinechemUtil.getLocalString("gui.title.decomposer");
        int infoWidth = this.field_146289_q.func_78256_a(info);
        GlStateManager.func_179147_l();
        this.field_146289_q.func_78276_b(info, (this.guiWidth - infoWidth) / 2, 5, 0);
        this.guiFluidTank.drawTooltip(this.mouseX, this.mouseY, this.decomposer.tank.getFluid());
        super.func_146979_b(par1, par2);
    }

    @Override
    protected void func_73864_a(int x, int y, int mouseButton) throws IOException {
        super.func_73864_a(x, y, mouseButton);
        if (this.dumpButton.func_146115_a() && this.decomposer.tank.getFluidAmount() > 0) {
            this.decomposer.dumpFluid();
        }
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(ModGlobals.ModResources.Gui.DECOMPOSER);
        int x = (this.field_146294_l - this.guiWidth) / 2;
        int y = (this.field_146295_m - this.guiHeight) / 2;
        this.func_73729_b(x, y, 0, 0, this.guiWidth, this.guiHeight);
        this.decomposer = (TileDecomposer)this.field_146297_k.field_71441_e.func_175625_s(this.decomposer.func_174877_v());
        this.guiFluidTank.draw(x, y, this.decomposer.tank.getFluid());
    }
}

