/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.gui;

import java.util.ArrayList;
import java.util.List;
import minechem.init.ModGlobals;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiFluidTank
extends Gui {
    private int capacity;
    private int posX;
    private int posY;

    public GuiFluidTank(int capacity, int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
        this.capacity = capacity;
    }

    public void draw(int x, int y, FluidStack fluidStack) {
        GlStateManager.func_179140_f();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ModGlobals.ModResources.Gui.TANK);
        this.func_73729_b(x + this.posX, y + this.posY, 0, 0, 18, 39);
        if (fluidStack != null && fluidStack.amount > 0) {
            int emptyHeight = 37 - (int)(38.0f * ((float)fluidStack.amount / (float)this.capacity));
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidStack.getFluid().getStill().toString());
            GuiFluidTank.func_73734_a((int)(x + this.posX + 2), (int)(y + this.posY + 1 + emptyHeight), (int)(x + this.posX + 16), (int)(y + this.posY + 1 + 37), (int)-16777216);
            int color = fluidStack.getFluid().getColor(fluidStack) << 8;
            GlStateManager.func_179131_c((float)((float)(color >>> 24) / 255.0f), (float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)1.0f);
            for (int i = 0; i < 3; ++i) {
                this.func_175175_a(x + this.posX + 2, y + this.posY - 10 + 16 * i, sprite, 15, 16);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ModGlobals.ModResources.Gui.TANK);
            this.func_73729_b(x + this.posX + 2, y + this.posY + 1, 1, 1, 15, emptyHeight);
            this.func_73729_b(x + this.posX, y + this.posY, 0, 0, 18, 2);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(ModGlobals.ModResources.Gui.DECOMPOSER);
            this.func_73729_b(x + this.posX + 2, y + 5, 4, 4, 15, 11);
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(ModGlobals.ModResources.Gui.TANK);
        this.func_73729_b(x + this.posX + 1, y + this.posY + 1, 19, 1, 16, 37);
        GlStateManager.func_179145_e();
    }

    public void drawTooltip(int x, int y, FluidStack fluidStack) {
        if (!this.mouseInTank(x, y)) {
            return;
        }
        ArrayList<String> description = new ArrayList<String>();
        if (fluidStack == null || fluidStack.amount == 0 || fluidStack.getFluid() == null) {
            description.add("Empty");
        } else if (fluidStack.amount > 0 && fluidStack.getFluid() != null) {
            String amountToText = fluidStack.amount + "mB";
            description.add(fluidStack.getLocalizedName());
            description.add(amountToText);
        }
        this.drawHoveringText(description, x, y, Minecraft.func_71410_x().field_71466_p);
    }

    private boolean mouseInTank(int x, int y) {
        return x >= this.posX && x < this.posX + 16 && y >= this.posY && y < this.posY + 37;
    }

    protected void drawHoveringText(List list, int x, int y, FontRenderer fontrenderer) {
        if (!list.isEmpty()) {
            GL11.glDisable((int)32826);
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int k = 0;
            for (String s : list) {
                int l = fontrenderer.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = x + 12;
            int j1 = y - 12;
            int k1 = 8;
            if (list.size() > 1) {
                k1 += 2 + (list.size() - 1) * 10;
            }
            this.field_73735_i = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < list.size(); ++k2) {
                String s1 = (String)list.get(k2);
                fontrenderer.func_175063_a(s1, (float)i1, (float)j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GL11.glEnable((int)32826);
        }
    }
}

