/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.gui.widget.tab;

import minechem.block.tile.TileMinechemEnergyBase;
import minechem.client.gui.widget.tab.GuiTab;
import minechem.init.ModConfig;
import minechem.init.ModGlobals;
import minechem.utils.MinechemUtil;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GuiTabState
extends GuiTab {
    int headerColour = 14797103;
    int subheaderColour = 11186104;
    int textColour = 0;
    protected TabState state = TabState.unpowered;
    protected TileMinechemEnergyBase tileEntity;

    public GuiTabState(Gui gui) {
        super(gui);
        int h = 0;
        if (ModConfig.powerUseEnabled) {
            h = 75;
        }
        this.minWidth = 23;
        this.minHeight = 24;
        this.maxHeight = this.minHeight + h;
        this.maxWidth = this.minWidth + 80;
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        this.drawIcon(x + 1, y + 3);
        if (!this.isFullyOpened()) {
            return;
        }
        this.fontRenderer.func_78279_b(MinechemUtil.getLocalString(this.state.tooltip), x + 22, y + 3, this.maxWidth, this.headerColour);
        if (ModConfig.powerUseEnabled) {
            this.fontRenderer.func_175063_a(MinechemUtil.getLocalString("tab.title.stored") + ":", (float)(x + 5), (float)(y + 30), this.subheaderColour);
            String print = this.tileEntity.getEnergyStored() + " FE (" + String.valueOf(this.tileEntity.getPowerRemainingScaled(100.0)) + "%)";
            this.fontRenderer.func_78276_b(print, x + 5, y + 40, this.textColour);
            this.fontRenderer.func_175063_a(MinechemUtil.getLocalString("tab.title.activation_energy"), (float)(x + 5), (float)(y + 60), this.subheaderColour);
            this.fontRenderer.func_78276_b(String.valueOf(this.tileEntity.getEnergyRequired()) + " FE", x + 5, y + 70, this.textColour);
        }
    }

    @Override
    public String getTooltip() {
        if (!this.isFullyOpened()) {
            return this.state.tooltip;
        }
        return null;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.state.resource;
    }

    protected static enum TabState {
        jammed(MinechemUtil.getLocalString("tab.tooltip.jammed"), 0xAA0000, ModGlobals.ModResources.Icon.JAMMED),
        noBottles(MinechemUtil.getLocalString("tab.tooltip.nobottles"), 0xAA0000, ModGlobals.ModResources.Icon.NO_BOTTLES),
        powered(MinechemUtil.getLocalString("tab.tooltip.powered"), 52224, ModGlobals.ModResources.Icon.ENERGY),
        unpowered(MinechemUtil.getLocalString("tab.tooltip.unpowered"), 0xAA0000, ModGlobals.ModResources.Icon.NO_ENERGY),
        norecipe(MinechemUtil.getLocalString("tab.tooltip.norecipe"), 0xAA0000, ModGlobals.ModResources.Icon.NO_RECIPE),
        noingredients(MinechemUtil.getLocalString("tab.tooltip.notenoughingredients"), 0xAA0000, ModGlobals.ModResources.Icon.NO_RECIPE);

        public String tooltip;
        public int color;
        @SideOnly(value=Side.CLIENT)
        public ResourceLocation resource;

        private TabState(String tooltip, int color, ResourceLocation resource) {
            this.tooltip = tooltip;
            this.color = color;
            this.resource = resource;
        }
    }
}

