/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.gui.widget.tab;

import minechem.block.multiblock.tile.TileFusionCore;
import minechem.block.multiblock.tile.TileReactorCore;
import minechem.block.tile.TileMinechemEnergyBase;
import minechem.client.gui.GuiFusion;
import minechem.client.gui.widget.tab.GuiTabState;
import minechem.init.ModConfig;
import minechem.utils.MinechemUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.inventory.IInventory;

public class TabFusionState
extends GuiTabState {
    private int lastKnownEnergyCost = 0;

    public TabFusionState(Gui gui) {
        super(gui);
        this.tileEntity = ((GuiFusion)gui).fusion;
        this.state = GuiTabState.TabState.norecipe;
    }

    @Override
    public void update() {
        super.update();
        if (this.tileEntity instanceof TileFusionCore) {
            TileFusionCore fusionTile = (TileFusionCore)this.tileEntity;
            if (fusionTile instanceof IInventory) {
                TileFusionCore tileInv = fusionTile;
                if (!tileInv.func_70301_a(0).func_190926_b() && !tileInv.func_70301_a(1).func_190926_b()) {
                    if (fusionTile.inputsCanBeFused()) {
                        this.lastKnownEnergyCost = ((TileMinechemEnergyBase)fusionTile).getEnergyRequired();
                        this.state = this.lastKnownEnergyCost <= fusionTile.getEnergyStored() ? (fusionTile.canOutput() ? GuiTabState.TabState.powered : GuiTabState.TabState.jammed) : GuiTabState.TabState.unpowered;
                    } else {
                        this.state = GuiTabState.TabState.norecipe;
                    }
                } else {
                    this.state = GuiTabState.TabState.norecipe;
                }
            }
            this.overlayColor = this.state.color;
        }
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        this.drawIcon(x + 1, y + 3);
        if (!this.isFullyOpened()) {
            return;
        }
        this.fontRenderer.func_78279_b(MinechemUtil.getLocalString(this.state.tooltip), x + 22, y + 3, this.maxWidth, this.headerColour);
        if (ModConfig.powerUseEnabled) {
            this.fontRenderer.func_175063_a(MinechemUtil.getLocalString("tab.title.stored") + ":", (float)(x + 5), (float)(y + 30), this.subheaderColour);
            String print = ((GuiFusion)this.myGui).storedEnergy + " FE (" + String.valueOf(((TileReactorCore)Minecraft.func_71410_x().field_71441_e.func_175625_s(this.tileEntity.func_174877_v())).getPowerRemainingScaled(100.0)) + "%)";
            this.fontRenderer.func_78276_b(print, x + 5, y + 40, this.textColour);
            this.fontRenderer.func_175063_a(MinechemUtil.getLocalString("tab.title.activation_energy"), (float)(x + 5), (float)(y + 60), this.subheaderColour);
            this.fontRenderer.func_78276_b(String.valueOf(this.tileEntity.getEnergyRequired()) + " FE", x + 5, y + 70, this.textColour);
        }
    }

    @Override
    public String getTooltip() {
        if (!this.isFullyOpened()) {
            if (this.state == GuiTabState.TabState.unpowered && this.lastKnownEnergyCost > 0) {
                return "Energy Needed: " + this.lastKnownEnergyCost;
            }
            return this.state.tooltip;
        }
        return null;
    }
}

