/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.gui.widget.tab;

import minechem.api.recipe.ISynthesisRecipe;
import minechem.block.tile.TileSynthesis;
import minechem.client.gui.widget.tab.GuiTabState;
import minechem.init.ModConfig;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;

public class TabSynthesisState
extends GuiTabState {
    private int lastKnownEnergyCost;

    public TabSynthesisState(Gui gui, TileSynthesis synthesis) {
        super(gui);
        this.tileEntity = synthesis;
        this.state = GuiTabState.TabState.norecipe;
    }

    @Override
    public void update() {
        super.update();
        TileSynthesis synthesis = (TileSynthesis)this.tileEntity;
        ISynthesisRecipe recipe = synthesis.getCurrentRecipe();
        if (recipe == null) {
            this.state = GuiTabState.TabState.norecipe;
        } else {
            ItemStack outputStack = synthesis.func_70301_a(2);
            if (ModConfig.powerUseEnabled) {
                this.lastKnownEnergyCost = recipe.getEnergyCost();
                this.state = synthesis.hasEnoughPower() ? (outputStack.func_190926_b() ? GuiTabState.TabState.noingredients : GuiTabState.TabState.powered) : GuiTabState.TabState.unpowered;
            } else {
                this.state = outputStack.func_190926_b() ? GuiTabState.TabState.noingredients : GuiTabState.TabState.powered;
            }
        }
        this.overlayColor = this.state.color;
    }

    @Override
    public String getTooltip() {
        if (!this.isFullyOpened()) {
            if (this.lastKnownEnergyCost > 0) {
                return "Energy Needed: " + this.lastKnownEnergyCost;
            }
            return this.state.tooltip;
        }
        return null;
    }
}

