/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.model.generated;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import minechem.client.model.generated.Transforms;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.IModelState;

public class ItemQuadBakery {
    public static List<BakedQuad> bakeItem(List<TextureAtlasSprite> sprites) {
        return ItemQuadBakery.bakeItem(sprites, DefaultVertexFormats.field_176599_b, Transforms.DEFAULT_ITEM);
    }

    public static List<BakedQuad> bakeItem(List<TextureAtlasSprite> sprites, IModelState state) {
        return ItemQuadBakery.bakeItem(sprites, DefaultVertexFormats.field_176599_b, state);
    }

    public static List<BakedQuad> bakeItem(List<TextureAtlasSprite> sprites, VertexFormat format) {
        return ItemQuadBakery.bakeItem(sprites, format, Transforms.DEFAULT_ITEM);
    }

    public static List<BakedQuad> bakeItem(List<TextureAtlasSprite> sprites, VertexFormat format, IModelState state) {
        return ItemQuadBakery.bakeItem(format, state, sprites.toArray(new TextureAtlasSprite[0]));
    }

    public static List<BakedQuad> bakeItem(TextureAtlasSprite ... sprites) {
        return ItemQuadBakery.bakeItem(Transforms.DEFAULT_ITEM, sprites);
    }

    public static List<BakedQuad> bakeItem(IModelState state, TextureAtlasSprite ... sprites) {
        return ItemQuadBakery.bakeItem(DefaultVertexFormats.field_176599_b, state, sprites);
    }

    public static List<BakedQuad> bakeItem(VertexFormat format, TextureAtlasSprite ... sprites) {
        return ItemQuadBakery.bakeItem(format, Transforms.DEFAULT_ITEM, sprites);
    }

    public static List<BakedQuad> bakeItem(VertexFormat format, IModelState state, TextureAtlasSprite ... sprites) {
        ItemQuadBakery.checkArgument(sprites, "Sprites must not be Null or empty!");
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        Optional transform = state.apply(Optional.empty());
        for (int i = 0; i < sprites.length; ++i) {
            TextureAtlasSprite sprite = sprites[i];
            quads.addAll((Collection<BakedQuad>)ItemLayerModel.getQuadsForSprite((int)i, (TextureAtlasSprite)sprite, (VertexFormat)format, (Optional)transform));
        }
        return quads;
    }

    public <T> boolean isNullOrContainsNull(T[] input) {
        if (input != null) {
            for (T t : input) {
                if (t != null) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static <E> void checkArgument(E argument, String log) {
        try {
            Preconditions.checkNotNull(argument);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Argument check failed! Reason: " + log);
        }
    }
}

