/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.render;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import minechem.client.model.generated.ItemLayerWrapper;
import minechem.client.model.generated.ModelProperties;
import minechem.client.model.generated.PerspectiveAwareBakedModel;
import minechem.client.model.generated.Transforms;
import minechem.client.render.TextLayer;
import minechem.init.ModGlobals;
import minechem.item.ItemElement;
import minechem.item.MatterState;
import minechem.item.element.ElementEnum;
import minechem.utils.MinechemUtil;
import minechem.utils.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.common.model.TRSRTransformation;

public class ElementItemRenderer
extends TileEntityItemStackRenderer {
    public static ItemLayerWrapper model;
    public static ItemCameraTransforms.TransformType transformType;
    public static Map<Integer, PerspectiveAwareBakedModel[]> ELEMENT_MODEL_CACHE;

    public void func_192838_a(ItemStack stack, float partialTicks) {
        if (transformType == null) {
            transformType = ItemCameraTransforms.TransformType.NONE;
        }
        if (stack.func_77973_b() instanceof ItemElement && stack.func_77952_i() > 0) {
            ElementEnum element = MinechemUtil.getElement(stack);
            float duration = 1500.0f;
            float t = (float)Minecraft.func_71386_F() % duration;
            int frame = 0;
            boolean isSolid = true;
            switch (element.roomState()) {
                case LIQUID: {
                    isSolid = false;
                    frame = (int)ElementItemRenderer.translateValue(t, 0.0f, duration, 0.0f, 7.0f);
                    break;
                }
                case GAS: {
                    isSolid = false;
                    frame = (int)ElementItemRenderer.translateValue(t, 0.0f, duration, 0.0f, 7.0f);
                    break;
                }
            }
            model.setInternal(ElementItemRenderer.getModelForElement(MinechemUtil.getElement(stack), frame));
            if (model != null) {
                model.handlePerspective(transformType);
            }
            if (transformType == ItemCameraTransforms.TransformType.FIXED) {
                GlStateManager.func_179137_b((double)1.0, (double)0.0, (double)1.0);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            Map<LayerType, List<BakedQuad>> quadsLayered = ElementItemRenderer.getQuadsForElement(element, frame);
            int color = RenderUtil.getColorForElement(element);
            if (!isSolid) {
                color &= 0xCBFFFFFF;
            }
            if (transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179109_b((float)0.2f, (float)0.9f, (float)0.6f);
            }
            if (transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
                GlStateManager.func_179109_b((float)0.5f, (float)0.0f, (float)-0.6f);
            }
            if (transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
                GlStateManager.func_179114_b((float)30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-0.2f, (float)-0.08f, (float)-0.6f);
            }
            if (transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
                GlStateManager.func_179114_b((float)-30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.2f, (float)-0.08f, (float)-0.6f);
            }
            if (transformType == ItemCameraTransforms.TransformType.FIXED || transformType == ItemCameraTransforms.TransformType.GUI) {
                GlStateManager.func_179109_b((float)0.1f, (float)0.0f, (float)0.0f);
            }
            RenderUtil.renderQuadsColored(quadsLayered.get((Object)LayerType.ELEMENT), color, 0.0f);
            RenderUtil.renderQuadsColored(quadsLayered.get((Object)LayerType.TUBE), -1, 0.0f);
            GlStateManager.func_179109_b((float)-0.1f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179094_E();
            float scale = 0.7f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
            GlStateManager.func_179137_b((double)0.0, (double)((double)scale - 0.3), (double)0.0);
            RenderUtil.renderQuadsColored(quadsLayered.get((Object)LayerType.SYMBOL), -1, 0.0f);
            GlStateManager.func_179152_a((float)(-scale * scale), (float)(-scale * scale), (float)(-scale * scale));
            GlStateManager.func_179121_F();
            if (transformType == ItemCameraTransforms.TransformType.GUI) {
                // empty if block
            }
            if (transformType == ItemCameraTransforms.TransformType.FIXED || transformType == ItemCameraTransforms.TransformType.GUI) {
                GlStateManager.func_179109_b((float)-0.1f, (float)0.0f, (float)0.0f);
            }
            if (transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                GlStateManager.func_179152_a((float)-0.5f, (float)-0.5f, (float)-0.5f);
            }
            if (transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) {
                GlStateManager.func_179114_b((float)-30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)0.2f, (float)0.08f, (float)0.6f);
            }
            if (transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND) {
                GlStateManager.func_179114_b((float)30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-0.2f, (float)0.08f, (float)0.6f);
            }
        }
    }

    private static ResourceLocation[] getSpritesForElement(ElementEnum element) {
        switch (element.roomState()) {
            default: {
                return new ResourceLocation[]{ModGlobals.Textures.Sprite.SOLID_STATE};
            }
            case LIQUID: {
                return ModGlobals.Textures.Sprite.LIQUID_STATES;
            }
            case GAS: 
        }
        return ModGlobals.Textures.Sprite.GAS_STATES;
    }

    public static PerspectiveAwareBakedModel getModelForElement(ElementEnum element, int frame) {
        return ElementItemRenderer.getModelsForElement(element)[frame];
    }

    public static List<BakedQuad> getAllQuadsForElement(ElementEnum element, int frame) {
        LinkedList<BakedQuad> quadList = new LinkedList<BakedQuad>();
        Map<LayerType, List<BakedQuad>> quadListMap = ElementItemRenderer.getQuadsForElement(element, frame);
        quadList.addAll((Collection)quadListMap.get((Object)LayerType.ELEMENT));
        quadList.addAll((Collection)quadListMap.get((Object)LayerType.TUBE));
        quadList.addAll((Collection)quadListMap.get((Object)LayerType.SYMBOL));
        return quadList;
    }

    public static Map<LayerType, List<BakedQuad>> getQuadsForElement(ElementEnum element, int frame) {
        HashMap<LayerType, List<BakedQuad>> elementQuadsMap = new HashMap<LayerType, List<BakedQuad>>();
        LinkedList elementQuads = new LinkedList();
        LinkedList tubeQuads = new LinkedList();
        LinkedList<BakedQuad> symbolQuads = new LinkedList<BakedQuad>();
        ResourceLocation[] sprites = ElementItemRenderer.getSpritesForElement(element);
        elementQuads.addAll(ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)Minecraft.func_71410_x().func_147117_R().func_110572_b(sprites[frame].toString()), (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.of(TRSRTransformation.identity())));
        tubeQuads.addAll(ItemLayerModel.getQuadsForSprite((int)0, (TextureAtlasSprite)Minecraft.func_71410_x().func_147117_R().func_110572_b(ModGlobals.Textures.Sprite.FILLED_TUBE.toString()), (VertexFormat)DefaultVertexFormats.field_176599_b, Optional.of(TRSRTransformation.identity())));
        symbolQuads.addAll(TextLayer.getQuadsForString(element.name()));
        elementQuadsMap.put(LayerType.ELEMENT, elementQuads);
        elementQuadsMap.put(LayerType.TUBE, tubeQuads);
        elementQuadsMap.put(LayerType.SYMBOL, symbolQuads);
        return elementQuadsMap;
    }

    public static PerspectiveAwareBakedModel[] getModelsForElement(ElementEnum element) {
        if (!ELEMENT_MODEL_CACHE.containsKey(element.atomicNumber())) {
            PerspectiveAwareBakedModel[] newModels = new PerspectiveAwareBakedModel[1];
            List<BakedQuad> quads = ElementItemRenderer.getAllQuadsForElement(element, 0);
            boolean isSolid = true;
            if (element.roomState() != MatterState.SOLID) {
                isSolid = false;
            }
            if (isSolid) {
                PerspectiveAwareBakedModel newModel;
                newModels[0] = newModel = new PerspectiveAwareBakedModel(quads, Transforms.DEFAULT_ITEM, ModelProperties.DEFAULT_ITEM);
            } else {
                newModels = new PerspectiveAwareBakedModel[7];
                for (int i = 0; i < 7; ++i) {
                    PerspectiveAwareBakedModel newModel;
                    quads = ElementItemRenderer.getAllQuadsForElement(element, i);
                    newModels[i] = newModel = new PerspectiveAwareBakedModel(quads, Transforms.DEFAULT_ITEM, ModelProperties.DEFAULT_ITEM);
                }
            }
            ELEMENT_MODEL_CACHE.put(element.atomicNumber(), newModels);
        }
        return ELEMENT_MODEL_CACHE.get(element.atomicNumber());
    }

    public static float translateValue(float value, float leftMin, float leftMax, float rightMin, float rightMax) {
        float leftRange = leftMax - leftMin;
        float rightRange = rightMax - rightMin;
        float valueScaled = (value - leftMin) / leftRange;
        return rightMin + valueScaled * rightRange;
    }

    static {
        ELEMENT_MODEL_CACHE = new HashMap<Integer, PerspectiveAwareBakedModel[]>();
    }

    public static enum LayerType {
        TUBE,
        ELEMENT,
        SYMBOL;

    }
}

