/*
 * Decompiled with CFR 0.152.
 */
package minechem.client.render;

import java.util.List;
import minechem.block.multiblock.tile.TileGhostBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderGhostBlock
extends TileEntitySpecialRenderer<TileGhostBlock> {
    public void render(TileGhostBlock te, double x, double y, double z, float scale, int i, float alpha) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemModelMesher mesher = mc.func_175599_af().func_175037_a();
        ItemStack stack = te.getBlockAsItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        IBakedModel bakedmodel = mesher.func_178089_a(stack);
        bakedmodel = bakedmodel.func_188617_f().handleItemState(bakedmodel, stack, (World)null, (EntityLivingBase)null);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        float pbx = OpenGlHelper.lastBrightnessX;
        float pby = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        RenderHelper.func_74518_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.65f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179094_E();
        bakedmodel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedmodel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.NONE, (boolean)false);
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (bakedmodel.func_188618_c()) {
            GlStateManager.func_179091_B();
            stack.func_77973_b().getTileEntityItemStackRenderer().func_179022_a(stack);
        } else {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181710_j);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                this.renderQuads(bufferbuilder, bakedmodel.func_188616_a((IBlockState)null, enumfacing, 0L), -1, stack);
            }
            this.renderQuads(bufferbuilder, bakedmodel.func_188616_a((IBlockState)null, (EnumFacing)null, 0L), -1, stack);
            tessellator.func_78381_a();
            if (stack.func_77962_s()) {
                // empty if block
            }
        }
        RenderGhostBlock.removeStandartTranslationFromTESRMatrix();
        GlStateManager.func_179137_b((double)(-(x + 0.5)), (double)(-(y + 0.5)), (double)(-(z + 0.5)));
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179121_F();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)pbx, (float)pby);
        GlStateManager.func_179101_C();
        GlStateManager.func_179145_e();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    private void renderQuads(BufferBuilder renderer, List<BakedQuad> quads, int color, ItemStack stack) {
        boolean flag = color == -1 && !stack.func_190926_b();
        int j = quads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = quads.get(i);
            int k = color;
            if (flag && bakedquad.func_178212_b()) {
                k = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                k |= 0xFF000000;
            }
            LightUtil.renderQuadColor((BufferBuilder)renderer, (BakedQuad)bakedquad, (int)k);
        }
    }

    public static void removeStandartTranslationFromTESRMatrix() {
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        Entity rView = Minecraft.func_71410_x().func_175606_aa();
        if (rView == null) {
            rView = Minecraft.func_71410_x().field_71439_g;
        }
        Entity entity = rView;
        double tx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double ty = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double tz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179137_b((double)(-tx), (double)(-ty), (double)(-tz));
    }
}

