/*
 * Decompiled with CFR 0.152.
 */
package minechem.container;

import java.util.ArrayList;
import java.util.List;
import minechem.api.INoDecay;
import minechem.api.IRadiationShield;
import minechem.block.tile.TileSynthesis;
import minechem.container.ContainerWithFakeSlots;
import minechem.init.ModItems;
import minechem.inventory.slot.SlotChemical;
import minechem.inventory.slot.SlotChemistJournal;
import minechem.inventory.slot.SlotFake;
import minechem.inventory.slot.SlotSynthesisOutput;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerSynthesis
extends ContainerWithFakeSlots
implements IRadiationShield,
INoDecay {
    private final TileSynthesis synthesis;
    private InventoryPlayer playerInventory;

    public ContainerSynthesis(InventoryPlayer playerInventory, TileSynthesis synthesis) {
        this.synthesis = synthesis;
        this.playerInventory = playerInventory;
        this.func_75146_a(new SlotChemistJournal(synthesis, 0, 26, 36));
        this.bindRecipeMatrixSlots();
        this.func_75146_a(new SlotSynthesisOutput(synthesis, playerInventory.field_70458_d, 1, 80, 84).setLocked(true));
        this.func_75146_a(new SlotSynthesisOutput(synthesis, playerInventory.field_70458_d, 2, 133, 36));
        this.bindStorageSlots();
        this.bindPlayerInventory(playerInventory);
    }

    private void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 160 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 8 + i * 18, 218));
        }
    }

    private void bindRecipeMatrixSlots() {
        int slot = 0;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.func_75146_a(new SlotFake(this.synthesis, TileSynthesis.SLOT_IDS_MATRIX[0] + slot, 62 + col * 18, 18 + row * 18){

                    public boolean func_75214_a(ItemStack itemstack) {
                        return itemstack.func_77973_b() == ModItems.element || itemstack.func_77973_b() == ModItems.molecule;
                    }
                });
                ++slot;
            }
        }
    }

    private void bindStorageSlots() {
        int slot = 0;
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new SlotChemical(this.synthesis, TileSynthesis.SLOT_IDS_STORAGE_BUFFER[0] + slot, 8 + col * 18, 114 + row * 18));
                ++slot;
            }
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer var1) {
        return this.synthesis.func_70300_a(var1);
    }

    @Override
    public List<ItemStack> getPlayerInventory() {
        ArrayList<ItemStack> playerInventoryStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.playerInventory.func_70302_i_(); ++i) {
            playerInventoryStacks.add(this.playerInventory.func_70301_a(i));
        }
        return playerInventoryStacks;
    }

    @Override
    public float getRadiationReductionFactor(int baseDamage, ItemStack itemstack, EntityPlayer player) {
        return 0.4f;
    }

    @Override
    public List<ItemStack> getStorageInventory() {
        ArrayList<ItemStack> storageInventory = new ArrayList<ItemStack>();
        for (int element : TileSynthesis.SLOT_IDS_STORAGE_BUFFER) {
            ItemStack stack = this.func_75139_a(element).func_75211_c();
            if (stack.func_190926_b()) continue;
            storageInventory.add(stack);
        }
        return storageInventory;
    }

    public ItemStack func_82846_b(EntityPlayer entityPlayer, int slot) {
        Slot slotObject = (Slot)this.field_75151_b.get(slot);
        if (slotObject != null && slotObject.func_75216_d()) {
            System.out.println(slotObject.field_75222_d);
            ItemStack stackInSlot = slotObject.func_75211_c();
            if (slot >= 30 && slot < 66) {
                if (stackInSlot.func_77973_b() == ModItems.journal && !this.func_75135_a(stackInSlot, 0, 1, false)) {
                    return ItemStack.field_190927_a;
                }
                if (!(stackInSlot.func_77973_b() != ModItems.element && stackInSlot.func_77973_b() != ModItems.molecule || this.func_75135_a(stackInSlot, 12, 30, false))) {
                    return ItemStack.field_190927_a;
                }
            } else {
                if (slot >= TileSynthesis.SLOT_IDS_STORAGE_BUFFER[0] && slot < TileSynthesis.SLOT_IDS_STORAGE_BUFFER[TileSynthesis.SLOT_IDS_STORAGE_BUFFER.length - 1] && !this.func_75135_a(stackInSlot, 30, 66, false)) {
                    return ItemStack.field_190927_a;
                }
                if (slot == 0 && !this.func_75135_a(stackInSlot, 30, 66, true)) {
                    return ItemStack.field_190927_a;
                }
                if (slot == 11 && !this.func_75135_a(stackInSlot, 30, 66, false)) {
                    return ItemStack.field_190927_a;
                }
            }
        }
        return ItemStack.field_190927_a;
    }
}

