/*
 * Decompiled with CFR 0.152.
 */
package minechem.fluid;

import minechem.item.MatterState;
import minechem.item.MinechemChemicalType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;

public abstract class FluidMinechem
extends Fluid {
    private static String texturePrefix = "minechem:blocks/";
    private int quanta;

    public FluidMinechem(String fluidName, boolean hasFlowIcon, MatterState roomstatus) {
        super(fluidName, new ResourceLocation(texturePrefix + "fluid_still"), new ResourceLocation(texturePrefix + "fluid" + (hasFlowIcon ? "_flow" : "_still")));
        this.setGaseous(roomstatus.isGas());
        this.setViscosity(roomstatus.getViscosity());
        this.setDensity(roomstatus.isGas() ? -10 : (roomstatus == MatterState.SOLID ? 10 : 10));
        this.setQuanta(roomstatus.getQuanta());
    }

    public void setQuanta(int quanta) {
        this.quanta = quanta;
    }

    public int getQuanta() {
        return this.quanta;
    }

    public abstract ItemStack getOutputStack();

    public abstract MinechemChemicalType getChemical();

    public String getUnlocalizedName() {
        return super.getUnlocalizedName() + ".name";
    }
}

