/*
 * Decompiled with CFR 0.152.
 */
package minechem.fluid.reaction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import minechem.block.fluid.BlockFluidMinechem;
import minechem.fluid.reaction.ChemicalFluidReactionOutput;
import minechem.fluid.reaction.ChemicalFluidReactionRule;
import minechem.init.ModFluids;
import minechem.item.MinechemChemicalType;
import minechem.item.element.ElementEnum;
import minechem.item.molecule.MoleculeEnum;
import minechem.utils.MinechemUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.UniversalBucket;

public class ChemicalFluidReactionHandler {
    public static final Map<ChemicalFluidReactionRule, ChemicalFluidReactionOutput> reactionRules = new HashMap<ChemicalFluidReactionRule, ChemicalFluidReactionOutput>();
    public static final int FLUIDS_GENERATE_SPACE = 3;
    private static final ChemicalFluidReactionHandler INSTANCE = new ChemicalFluidReactionHandler();

    public static final ChemicalFluidReactionHandler getInstance() {
        return INSTANCE;
    }

    public void checkEntityItem(World world, EntityItem entityItem) {
        ChemicalFluidReactionRule rule;
        int z;
        int y;
        int x;
        Block block;
        MinechemChemicalType chemicalB;
        ItemStack itemStack = entityItem.func_92059_d();
        if (itemStack.func_190916_E() <= 0) {
            return;
        }
        Item item = itemStack.func_77973_b();
        MinechemChemicalType chemicalA = null;
        if (item instanceof UniversalBucket) {
            chemicalA = MinechemUtil.getChemical(((UniversalBucket)item).getFluid(itemStack).getFluid());
        }
        if (chemicalA != null && (world.func_72875_a(entityItem.func_174813_aQ(), Material.field_151586_h) || world.func_72875_a(entityItem.func_174813_aQ(), BlockFluidMinechem.materialFluidBlock)) && (chemicalB = MinechemUtil.getChemical(block = world.func_180495_p(new BlockPos(x = MathHelper.func_76128_c((double)entityItem.field_70165_t), y = MathHelper.func_76128_c((double)entityItem.field_70163_u), z = MathHelper.func_76128_c((double)entityItem.field_70161_v))).func_177230_c())) != null && reactionRules.containsKey(rule = new ChemicalFluidReactionRule(chemicalA, chemicalB))) {
            ChemicalFluidReactionHandler.chemicalReaction(world, (Entity)entityItem, x, y, z, rule, !MinechemUtil.canDrain(world, block, x, y, z));
            itemStack.func_190918_g(1);
            entityItem.func_92058_a(itemStack);
            if (itemStack.func_190916_E() <= 0) {
                world.func_72900_e((Entity)entityItem);
            }
            MinechemUtil.throwItemStack(world, new ItemStack(Items.field_151133_ar), x, y, z);
        }
    }

    public static void initReaction() {
        ArrayList<MinechemChemicalType> list = new ArrayList<MinechemChemicalType>();
        list.add(ElementEnum.H);
        list.add(MoleculeEnum.lithiumHydroxide);
        reactionRules.put(new ChemicalFluidReactionRule(MoleculeEnum.water, ElementEnum.Li), new ChemicalFluidReactionOutput(list, 0.1f));
        list = new ArrayList();
        list.add(ElementEnum.H);
        list.add(MoleculeEnum.sodiumHydroxide);
        reactionRules.put(new ChemicalFluidReactionRule(MoleculeEnum.water, ElementEnum.Na), new ChemicalFluidReactionOutput(list, 0.15f));
        list = new ArrayList();
        list.add(ElementEnum.H);
        list.add(MoleculeEnum.potassiumHydroxide);
        reactionRules.put(new ChemicalFluidReactionRule(MoleculeEnum.water, ElementEnum.K), new ChemicalFluidReactionOutput(list, 0.2f));
        list = new ArrayList();
        list.add(ElementEnum.H);
        list.add(MoleculeEnum.rubidiumHydroxide);
        reactionRules.put(new ChemicalFluidReactionRule(MoleculeEnum.water, ElementEnum.Rb), new ChemicalFluidReactionOutput(list, 0.25f));
        list = new ArrayList();
        list.add(ElementEnum.H);
        list.add(MoleculeEnum.cesiumHydroxide);
        reactionRules.put(new ChemicalFluidReactionRule(MoleculeEnum.water, ElementEnum.Cs), new ChemicalFluidReactionOutput(list, 0.3f));
        list = new ArrayList();
        list.add(ElementEnum.H);
        list.add(MoleculeEnum.franciumHydroxide);
        reactionRules.put(new ChemicalFluidReactionRule(MoleculeEnum.water, ElementEnum.Fr), new ChemicalFluidReactionOutput(list, 0.4f));
        list = new ArrayList();
        list.add(ElementEnum.H);
        list.add(ElementEnum.H);
        list.add(MoleculeEnum.lightbluePigment);
        reactionRules.put(new ChemicalFluidReactionRule(MoleculeEnum.sulfuricAcid, ElementEnum.Cu), new ChemicalFluidReactionOutput(list, 0.1f));
        list = new ArrayList();
        list.add(ElementEnum.H);
        list.add(ElementEnum.H);
        list.add(MoleculeEnum.sulfurDioxide);
        reactionRules.put(new ChemicalFluidReactionRule(MoleculeEnum.sulfuricAcid, ElementEnum.S), new ChemicalFluidReactionOutput(list, 0.1f));
        list = new ArrayList();
        list.add(ElementEnum.S);
        list.add(MoleculeEnum.sulfurDioxide);
        list.add(MoleculeEnum.water);
        list.add(MoleculeEnum.water);
        reactionRules.put(new ChemicalFluidReactionRule(MoleculeEnum.sulfuricAcid, MoleculeEnum.hydrogenSulfide), new ChemicalFluidReactionOutput(list, 0.1f));
        list = new ArrayList();
        list.add(MoleculeEnum.salt);
        list.add(MoleculeEnum.water);
        reactionRules.put(new ChemicalFluidReactionRule(MoleculeEnum.hcl, MoleculeEnum.sodiumHydroxide), new ChemicalFluidReactionOutput(list, 0.1f));
        list = new ArrayList();
        list.add(MoleculeEnum.hcl);
        reactionRules.put(new ChemicalFluidReactionRule(ElementEnum.H, ElementEnum.Cl), new ChemicalFluidReactionOutput(list, 0.1f));
        list = new ArrayList();
        list.add(MoleculeEnum.sodiumBisulfate);
        list.add(MoleculeEnum.hcl);
        reactionRules.put(new ChemicalFluidReactionRule(MoleculeEnum.salt, MoleculeEnum.sulfuricAcid), new ChemicalFluidReactionOutput(list, 0.1f));
        list = new ArrayList();
        list.add(MoleculeEnum.sodiumSulfate);
        list.add(MoleculeEnum.hcl);
        list.add(MoleculeEnum.hcl);
        reactionRules.put(new ChemicalFluidReactionRule(MoleculeEnum.salt, MoleculeEnum.sodiumBisulfate), new ChemicalFluidReactionOutput(list, 0.1f));
    }

    private static void chemicalReaction(World world, Entity entity, int x, int y, int z, ChemicalFluidReactionRule rule, boolean popFlowingFluid) {
        ChemicalFluidReactionOutput output = reactionRules.get(rule);
        if (output == null) {
            return;
        }
        if (!Float.isNaN(output.explosionLevel)) {
            world.func_72876_a(null, (double)x, (double)y, (double)z, output.explosionLevel, true);
        }
        int halfSpace = 1;
        ArrayList availableSpaces = Lists.newArrayListWithExpectedSize((int)3);
        for (int i = 0; i < availableSpaces.size(); ++i) {
            availableSpaces.set(i, ChemicalFluidReactionHandler.findAvailableSpacesAtCrossSection(world, x, y - halfSpace + i, z, 1));
        }
        for (MinechemChemicalType chemical : output.outputs) {
            boolean hasFlowingStatus = chemical.roomState().getQuanta() > 2;
            Vec3i coords = null;
            if (hasFlowingStatus || !popFlowingFluid) {
                int i;
                boolean isGas = chemical.roomState().isGas();
                if (isGas) {
                    for (i = availableSpaces.size() - 1; i > -1; --i) {
                        if (((List)availableSpaces.get(i)).isEmpty()) continue;
                        coords = (Vec3i)((List)availableSpaces.get(i)).remove(((List)availableSpaces.get(i)).size() - 1);
                        break;
                    }
                } else {
                    for (i = 0; i < availableSpaces.size(); ++i) {
                        if (((List)availableSpaces.get(i)).isEmpty()) continue;
                        coords = (Vec3i)((List)availableSpaces.get(i)).remove(((List)availableSpaces.get(i)).size() - 1);
                        break;
                    }
                }
            }
            if (coords == null) {
                if (popFlowingFluid) continue;
                ItemStack itemStack = MinechemUtil.createItemStack(chemical, 8);
                MinechemUtil.throwItemStack(world, itemStack, x, y, z);
                continue;
            }
            if (popFlowingFluid && !hasFlowingStatus) continue;
            int px = coords.func_177958_n();
            int py = coords.func_177956_o();
            int pz = coords.func_177952_p();
            world.func_175655_b(new BlockPos(px, py, pz), true);
            world.func_175698_g(new BlockPos(px, py, pz));
            Block fluidBlock = null;
            if (chemical instanceof ElementEnum) {
                fluidBlock = ModFluids.FLUID_ELEMENT_BLOCKS.get((Object)ModFluids.FLUID_ELEMENTS.get(chemical));
            } else if (chemical instanceof MoleculeEnum) {
                fluidBlock = ModFluids.FLUID_MOLECULE_BLOCKS.get(ModFluids.FLUID_MOLECULES.get(chemical));
            }
            if (fluidBlock == null) continue;
            world.func_180501_a(new BlockPos(px, py, pz), fluidBlock.func_176203_a(popFlowingFluid ? 1 : 0), 3);
        }
    }

    public static boolean checkToReact(Block source, Block destination, World world, int destinationX, int destinationY, int destinationZ, int sourceX, int sourceY, int sourceZ) {
        ChemicalFluidReactionRule rule;
        MinechemChemicalType chemicalA = MinechemUtil.getChemical(source);
        MinechemChemicalType chemicalB = MinechemUtil.getChemical(destination);
        if (chemicalA != null && chemicalB != null && reactionRules.containsKey(rule = new ChemicalFluidReactionRule(chemicalA, chemicalB))) {
            boolean flag = !MinechemUtil.canDrain(world, source, sourceX, sourceY, sourceZ) || !MinechemUtil.canDrain(world, destination, destinationX, destinationY, destinationZ);
            world.func_175698_g(new BlockPos(sourceX, sourceY, sourceZ));
            world.func_175698_g(new BlockPos(destinationX, destinationY, destinationZ));
            ChemicalFluidReactionHandler.chemicalReaction(world, null, destinationX, destinationY, destinationZ, rule, flag);
            return true;
        }
        return false;
    }

    public static List<Vec3i> findAvailableSpacesAtCrossSection(World world, int centerX, int centerY, int centerZ, int size) {
        ArrayList<Vec3i> spaces = new ArrayList<Vec3i>();
        for (int xOffset = -size; xOffset <= size; ++xOffset) {
            for (int zOffset = -size; zOffset <= size; ++zOffset) {
                int x = centerX + xOffset;
                int z = centerZ + zOffset;
                if (!world.func_175623_d(new BlockPos(x, centerY, z)) && world.func_180495_p(new BlockPos(x, centerY, z)).func_185904_a().func_76220_a()) continue;
                spaces.add(new Vec3i(x, centerY, z));
            }
        }
        return spaces;
    }
}

