/*
 * Decompiled with CFR 0.152.
 */
package minechem.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import minechem.api.INoDecay;
import minechem.api.IRadiationShield;
import minechem.event.RadiationDecayEvent;
import minechem.fluid.FluidMinechem;
import minechem.handler.HandlerMoleculeDecay;
import minechem.init.ModFluids;
import minechem.init.ModItems;
import minechem.item.ItemElement;
import minechem.item.MinechemChemicalType;
import minechem.item.element.ElementEnum;
import minechem.radiation.RadiationEnum;
import minechem.utils.MinechemUtil;
import minechem.utils.RadiationUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.eventhandler.Event;

public class HandlerElementDecay {
    private static HandlerElementDecay instance = new HandlerElementDecay();

    public static HandlerElementDecay getInstance() {
        return instance == null ? new HandlerElementDecay() : instance;
    }

    public void update(EntityPlayer player) {
        Container openContainer = player.field_71070_bA;
        if (openContainer != null) {
            if (openContainer instanceof INoDecay) {
                this.updateContainerNoDecay(player, openContainer, (IInventory)player.field_71071_by);
            } else {
                this.updateContainer(player, openContainer, (IInventory)player.field_71071_by);
            }
        } else {
            this.updateContainer(player, player.field_71069_bz, (IInventory)player.field_71071_by);
        }
    }

    private void updateContainerNoDecay(EntityPlayer player, Container openContainer, IInventory inventory) {
        List<ItemStack> playerStacks;
        INoDecay container = (INoDecay)openContainer;
        List<ItemStack> itemstacks = container.getStorageInventory();
        if (itemstacks != null) {
            for (ItemStack itemstack : itemstacks) {
                if (itemstack.func_190926_b() || itemstack.func_77973_b() != ModItems.molecule && itemstack.func_77973_b() != ModItems.element || RadiationUtil.getRadioactivity(itemstack) == RadiationEnum.stable) continue;
                RadiationUtil radiationInfo = ItemElement.getRadiationInfo(itemstack, player.field_70170_p);
                radiationInfo.decayStarted += player.field_70170_p.func_82737_E() - radiationInfo.lastDecayUpdate;
                radiationInfo.lastDecayUpdate = player.field_70170_p.func_82737_E();
                RadiationUtil.setRadiationInfo(radiationInfo, itemstack);
            }
        }
        if ((playerStacks = container.getPlayerInventory()) != null) {
            this.updateRadiationOnItems(player.field_70170_p, player, openContainer, inventory, playerStacks);
        }
    }

    private void updateContainer(EntityPlayer player, Container container, IInventory inventory) {
        NonNullList itemstacks = container.func_75138_a();
        this.updateRadiationOnItems(player.field_70170_p, player, container, inventory, (List<ItemStack>)itemstacks);
    }

    private void updateRadiationOnItems(World world, EntityPlayer player, Container container, IInventory inventory, List<ItemStack> itemstacks) {
        this.updateRadiationOnItems(world, inventory, itemstacks, player, container, player.field_70165_t, player.field_70163_u, player.field_70161_v);
    }

    private void updateRadiationOnItems(World world, IInventory inventory, List<ItemStack> itemstacks, EntityPlayer player, Container container, double posX, double posY, double posZ) {
        for (int i = 0; i < itemstacks.size(); ++i) {
            ItemStack itemstack = itemstacks.get(i);
            if (itemstack == null) continue;
            RadiationEnum radiation = null;
            Item item = itemstack.func_77973_b();
            if (item == ModItems.element) {
                radiation = RadiationUtil.getRadioactivity(itemstack);
            } else if (item == ModItems.molecule) {
                radiation = MinechemUtil.getMolecule(itemstack).radioactivity();
            }
            if (radiation == null || radiation == RadiationEnum.stable) continue;
            Long time = world.func_82737_E() - ItemElement.getRadiationInfo((ItemStack)itemstack, (World)world).decayStarted;
            ItemStack before = itemstack.func_77946_l();
            int damage = this.updateRadiation(world, itemstack, inventory, posX, posY, posZ);
            ItemStack after = itemstack.func_77946_l();
            if (damage <= 0) continue;
            IInventory decayInventory = container == null ? inventory : container.func_75139_a((int)i).field_75224_c;
            MinecraftForge.EVENT_BUS.post((Event)new RadiationDecayEvent(decayInventory, damage, time, before, after, player));
            if (container == null || player == null) continue;
            this.applyRadiationDamage(player, container, damage);
        }
    }

    private void applyRadiationDamage(EntityPlayer player, Container container, int damage) {
        float reduction;
        ArrayList<Float> reductions = new ArrayList<Float>();
        if (container instanceof IRadiationShield) {
            float reduction2 = ((IRadiationShield)container).getRadiationReductionFactor(damage, null, player);
            reductions.add(Float.valueOf(reduction2));
        }
        for (ItemStack armour : player.field_71071_by.field_70460_b) {
            if (armour == null || !(armour.func_77973_b() instanceof IRadiationShield)) continue;
            reduction = ((IRadiationShield)armour.func_77973_b()).getRadiationReductionFactor(damage, armour, player);
            reductions.add(Float.valueOf(reduction));
        }
        float totalReductionFactor = 1.0f;
        Iterator iterator = reductions.iterator();
        while (iterator.hasNext()) {
            reduction = ((Float)iterator.next()).floatValue();
            totalReductionFactor -= reduction;
        }
        if (totalReductionFactor < 0.0f) {
            totalReductionFactor = 0.0f;
        }
        damage = Math.round((float)damage * totalReductionFactor);
        player.func_70097_a(DamageSource.field_76377_j, (float)damage);
    }

    private int updateRadiation(World world, ItemStack element, IInventory inventory, double x, double y, double z) {
        RadiationUtil radiationInfo = ItemElement.getRadiationInfo(element, world);
        int dimensionID = world.field_73011_w.getDimension();
        if (dimensionID != radiationInfo.dimensionID && radiationInfo.isRadioactive()) {
            radiationInfo.dimensionID = dimensionID;
            RadiationUtil.setRadiationInfo(radiationInfo, element);
            return 0;
        }
        long currentTime = world.func_82737_E();
        return this.decayElement(element, radiationInfo, currentTime, world, inventory, x, y, z);
    }

    private int decayElement(@Nonnull ItemStack element, RadiationUtil radiationInfo, long currentTime, World world, IInventory inventory, double x, double y, double z) {
        if (element.func_190926_b() || element.func_190916_E() == 0) {
            radiationInfo.decayStarted += currentTime - radiationInfo.lastDecayUpdate;
            radiationInfo.lastDecayUpdate = currentTime;
            RadiationUtil.setRadiationInfo(radiationInfo, element);
            return 0;
        }
        radiationInfo.lastDecayUpdate = currentTime;
        long lifeTime = currentTime - radiationInfo.decayStarted - radiationInfo.radioactivity.getLife();
        if (lifeTime > 0L) {
            Fluid fluid;
            int damage = radiationInfo.radioactivity.getDamage() * element.func_190916_E();
            Item item = element.func_77973_b();
            if (item == ModItems.element) {
                radiationInfo = ItemElement.decay(element, world);
            } else if (item == ModItems.molecule) {
                radiationInfo = HandlerMoleculeDecay.getInstance().handleRadiationMolecule(world, element, inventory, x, y, z);
            } else if (item instanceof UniversalBucket && (fluid = ((UniversalBucket)item).getFluid(element).getFluid()) instanceof FluidMinechem) {
                MinechemChemicalType type = MinechemUtil.getChemicalTypeFromBucket(element);
                if (type instanceof ElementEnum) {
                    element = MinechemUtil.getBucketForFluid(ModFluids.FLUID_ELEMENTS.get(ElementEnum.getByID(((ElementEnum)type).atomicNumber())));
                    radiationInfo = ItemElement.initiateRadioactivity(element, world);
                } else {
                    radiationInfo = HandlerMoleculeDecay.getInstance().handleRadiationMoleculeBucket(world, element, inventory, x, y, z);
                }
            }
            RadiationUtil.setRadiationInfo(radiationInfo, element);
            return damage;
        }
        RadiationUtil.setRadiationInfo(radiationInfo, element);
        return 0;
    }
}

