/*
 * Decompiled with CFR 0.152.
 */
package minechem.handler;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import minechem.init.ModLogger;
import minechem.item.MinechemChemicalType;
import minechem.item.molecule.MoleculeEnum;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class HandlerExplosiveFluid {
    private static HandlerExplosiveFluid instance;
    private Map<MinechemChemicalType, Float> explosiveFluids = new LinkedHashMap<MinechemChemicalType, Float>();
    private Set<Block> fireSource = new LinkedHashSet<Block>();

    public static HandlerExplosiveFluid getInstance() {
        if (instance == null) {
            instance = new HandlerExplosiveFluid();
        }
        return instance;
    }

    public HandlerExplosiveFluid() {
        this.init();
    }

    public boolean existingFireSource(Block block) {
        return this.fireSource.contains(block);
    }

    public void addFireSource(Block block) {
        this.fireSource.add(block);
        ModLogger.debug("Added fire source block:" + block);
    }

    public void removeFireSource(Block block) {
        this.fireSource.remove(block);
        ModLogger.debug("Removed fire source block:" + block);
    }

    public void addExplosiveFluid(MinechemChemicalType type, float level) {
        this.explosiveFluids.put(type, Float.valueOf(level));
        ModLogger.debug("Added explosive fluid:" + type);
    }

    public void removeExplosiveFluid(MinechemChemicalType type) {
        this.explosiveFluids.remove(type);
        ModLogger.debug("Removed explosive fluid:" + type);
    }

    public float getExplosiveFluid(MinechemChemicalType type) {
        Float level = this.explosiveFluids.get(type);
        if (level == null) {
            return Float.NaN;
        }
        return level.floatValue();
    }

    private void init() {
        this.addFireSource((Block)Blocks.field_150480_ab);
        this.addFireSource((Block)Blocks.field_150353_l);
        this.addFireSource((Block)Blocks.field_150356_k);
        this.addExplosiveFluid(MoleculeEnum.tnt, 2.0f);
    }
}

