/*
 * Decompiled with CFR 0.152.
 */
package minechem.handler.oredict;

import minechem.api.IOreDictionaryHandler;
import minechem.init.ModLogger;
import minechem.item.molecule.Molecule;
import minechem.item.molecule.MoleculeEnum;
import minechem.potion.PotionChemical;
import minechem.recipe.RecipeDecomposer;
import minechem.recipe.handler.RecipeHandlerSynthesis;

public class OreDictionaryAppliedEnergisticsHandler
implements IOreDictionaryHandler {
    private MoleculeEnum certusQuartzMolecule = MoleculeEnum.aluminiumPhosphate;
    private PotionChemical certusQuartzChemical = new Molecule(this.certusQuartzMolecule);
    private MoleculeEnum chargedCertusQuartzMolecule = MoleculeEnum.aluminiumHypophosphite;
    private PotionChemical chargedCertusQuartzChemical = new Molecule(this.chargedCertusQuartzMolecule);
    private PotionChemical[] certusQuartzDecompositionFormula = new PotionChemical[]{new Molecule(this.certusQuartzMolecule, 4)};
    private PotionChemical[] certusQuartzCrystalSynthesisFormula = new PotionChemical[]{null, this.certusQuartzChemical, null, this.certusQuartzChemical, null, this.certusQuartzChemical, null, this.certusQuartzChemical, null};
    private PotionChemical[] certusQuartzDustSynthesisFormula = new PotionChemical[]{null, this.certusQuartzChemical, null, this.certusQuartzChemical, this.certusQuartzChemical, this.certusQuartzChemical, null, null, null};
    private PotionChemical[] chargedCertusQuartzDecompositionFormula = new PotionChemical[]{new Molecule(this.chargedCertusQuartzMolecule, 4)};
    private PotionChemical[] chargedCertusQuartzCrystalSynthesisFormula = new PotionChemical[]{null, this.chargedCertusQuartzChemical, null, this.chargedCertusQuartzChemical, null, this.chargedCertusQuartzChemical, null, this.chargedCertusQuartzChemical, null};
    private PotionChemical[] fluixCertusQuartzDecompositionFormula = new PotionChemical[]{new Molecule(this.certusQuartzMolecule, 2), new Molecule(this.chargedCertusQuartzMolecule)};
    private PotionChemical[] fluixQuartzCrystalSynthesisFormula = new PotionChemical[]{null, new Molecule(MoleculeEnum.galliumarsenide, 1), null, this.certusQuartzChemical, null, this.chargedCertusQuartzChemical, null, this.chargedCertusQuartzChemical, null};
    private PotionChemical[] fluixQuartzDustDecompositionFormula = new PotionChemical[]{new Molecule(MoleculeEnum.galliumarsenide, 1), new Molecule(this.certusQuartzMolecule, 1), new Molecule(this.chargedCertusQuartzMolecule, 2)};
    private PotionChemical[] fluixQuartzDustSynthesisFormula = new PotionChemical[]{null, null, null, this.certusQuartzChemical, new Molecule(MoleculeEnum.galliumarsenide, 1), this.chargedCertusQuartzChemical, null, this.chargedCertusQuartzChemical, null};
    private PotionChemical[] fluixQuartzPearlDecompositionFormula = new PotionChemical[]{new Molecule(MoleculeEnum.galliumarsenide, 2), this.certusQuartzChemical, new Molecule(this.chargedCertusQuartzMolecule, 2)};
    private PotionChemical[] fluixQuartzPearlSynthesisFormula = new PotionChemical[]{null, new Molecule(MoleculeEnum.galliumarsenide, 1), null, this.certusQuartzChemical, new Molecule(MoleculeEnum.galliumarsenide, 1), this.chargedCertusQuartzChemical, null, this.chargedCertusQuartzChemical, null};

    @Override
    public boolean canHandle(String oreName) {
        return oreName.endsWith("CertusQuartz") || oreName.endsWith("Fluix");
    }

    @Override
    public void handle(String oreName) {
        if (oreName.equals("dustCertusQuartz")) {
            RecipeDecomposer.addOreDictRecipe(oreName, this.certusQuartzDecompositionFormula);
            RecipeHandlerSynthesis.addShapedOreDictRecipe(oreName, 30000, this.certusQuartzDustSynthesisFormula);
        } else if (oreName.equals("crystalCertusQuartz")) {
            RecipeDecomposer.addOreDictRecipe(oreName, this.certusQuartzDecompositionFormula);
            RecipeHandlerSynthesis.addShapedOreDictRecipe(oreName, 30000, this.certusQuartzCrystalSynthesisFormula);
        } else if (oreName.equals("crystalChargedCertusQuartz")) {
            RecipeDecomposer.addOreDictRecipe(oreName, this.chargedCertusQuartzDecompositionFormula);
            RecipeHandlerSynthesis.addShapedOreDictRecipe(oreName, 30000, this.chargedCertusQuartzCrystalSynthesisFormula);
        } else if (oreName.equals("crystalFluix")) {
            RecipeDecomposer.addOreDictRecipe(oreName, this.fluixCertusQuartzDecompositionFormula);
            RecipeHandlerSynthesis.addShapedOreDictRecipe(oreName, 30000, this.fluixQuartzCrystalSynthesisFormula);
        } else if (oreName.equals("dustFluix")) {
            RecipeDecomposer.addOreDictRecipe(oreName, this.fluixQuartzDustDecompositionFormula);
            RecipeHandlerSynthesis.addShapedOreDictRecipe(oreName, 30000, this.fluixQuartzDustSynthesisFormula);
        } else if (oreName.equals("pearlFluix")) {
            RecipeDecomposer.addOreDictRecipe(oreName, this.fluixQuartzPearlDecompositionFormula);
            RecipeHandlerSynthesis.addShapedOreDictRecipe(oreName, 30000, this.fluixQuartzPearlSynthesisFormula);
        } else {
            ModLogger.debug("Unknown type of AE2 item : " + oreName);
        }
    }
}

