/*
 * Decompiled with CFR 0.152.
 */
package minechem.init;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import minechem.api.IMinechemBlueprint;
import minechem.api.recipe.ISynthesisRecipe;
import minechem.block.fluid.BlockFluidMinechem;
import minechem.block.tile.TileBlueprintProjector;
import minechem.client.gui.GuiBlueprintProjector;
import minechem.client.model.generated.CharacterSprite;
import minechem.client.model.generated.ItemLayerWrapper;
import minechem.client.model.generated.ModelProperties;
import minechem.client.model.generated.PerspectiveAwareBakedModel;
import minechem.client.render.ElementItemRenderer;
import minechem.event.RadiationDecayEvent;
import minechem.fluid.FluidElement;
import minechem.fluid.FluidMolecule;
import minechem.fluid.reaction.ChemicalFluidReactionHandler;
import minechem.handler.HandlerElementDecay;
import minechem.init.ModBlocks;
import minechem.init.ModBlueprints;
import minechem.init.ModConfig;
import minechem.init.ModEnchantments;
import minechem.init.ModGlobals;
import minechem.init.ModItems;
import minechem.init.ModLogger;
import minechem.init.ModPotions;
import minechem.init.ModRecipes;
import minechem.init.ModRegistries;
import minechem.init.ModRendering;
import minechem.init.ModSounds;
import minechem.item.element.ElementEnum;
import minechem.item.molecule.MoleculeEnum;
import minechem.potion.PharmacologyEffectRegistry;
import minechem.potion.PotionEnchantmentCoated;
import minechem.utils.BlueprintUtil;
import minechem.utils.MinechemUtil;
import minechem.utils.TickTimeUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class ModEvents {
    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ModEvents());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        char[] charList;
        TextureMap map = event.getMap();
        map.func_174942_a(ModGlobals.Textures.Sprite.MICROSCOPE);
        map.func_174942_a(ModGlobals.Textures.Sprite.SYNTHESIZER);
        map.func_174942_a(ModGlobals.Textures.Sprite.DECOMPOSER);
        map.func_174942_a(ModGlobals.Textures.Sprite.BLUEPRINT_PROJECTOR);
        map.func_174942_a(ModGlobals.Textures.Sprite.LEADED_CHEST);
        map.func_174942_a(ModGlobals.Textures.Sprite.FILLED_TUBE);
        for (ResourceLocation element : ModGlobals.Textures.Sprite.LIQUID_STATES) {
            map.func_174942_a(element);
        }
        for (ResourceLocation element : ModGlobals.Textures.Sprite.GAS_STATES) {
            map.func_174942_a(element);
        }
        map.func_174942_a(ModGlobals.Textures.Sprite.SOLID_STATE);
        map.func_174942_a(ModGlobals.Textures.Sprite.MOLECULE_TUBE);
        map.func_174942_a(ModGlobals.Textures.Sprite.MOLECULE_PASS_1);
        map.func_174942_a(ModGlobals.Textures.Sprite.MOLECULE_PASS_2);
        map.func_174942_a(ModGlobals.Textures.Sprite.FLUID_STILL);
        map.func_174942_a(ModGlobals.Textures.Sprite.FLUID_FLOW);
        for (char chr : charList = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'}) {
            map.setTextureEntry(CharacterSprite.getSpriteForChar(chr));
        }
        for (char chr : charList) {
            map.setTextureEntry(CharacterSprite.getSpriteForChar(Character.toUpperCase(chr)));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelBake(ModelBakeEvent event) {
        for (Pair<ModelResourceLocation, IBakedModel> pair : ModRendering.getParticleModels()) {
            event.getModelRegistry().func_82595_a(pair.getKey(), pair.getValue());
        }
        ElementItemRenderer.model = new ItemLayerWrapper(new PerspectiveAwareBakedModel((List<BakedQuad>)ImmutableList.of(), ModelProperties.PerspectiveProperties.DEFAULT_ITEM));
        event.getModelRegistry().func_82595_a((Object)ModRendering.ITEM_ELEMENT_LOC, (Object)ElementItemRenderer.model);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelRegister(ModelRegistryEvent event) {
        for (ElementEnum element : ElementEnum.elements.values()) {
            ModRendering.setItemTEISR(ModItems.element, new ElementItemRenderer(), element.atomicNumber(), ModRendering.ITEM_ELEMENT_LOC);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.START) {
            EntityPlayer player = event.player;
            HandlerElementDecay.getInstance().update(player);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiForegroundDraw(GuiContainerEvent.DrawForeground event) {
    }

    @SubscribeEvent
    public void checkForPoison(LivingEntityUseItemEvent.Finish event) {
        if (event.getItem() != null && event.getItem().func_77978_p() != null && ModConfig.FoodSpiking) {
            NBTTagCompound stackTag = event.getItem().func_77978_p();
            boolean isPoisoned = stackTag.func_74767_n("minechem.isPoisoned");
            int[] effectTypes = stackTag.func_74759_k("minechem.effectTypes");
            if (isPoisoned) {
                for (int effectType : effectTypes) {
                    MoleculeEnum molecule = MoleculeEnum.getById(effectType);
                    PharmacologyEffectRegistry.applyEffect(molecule, event.getEntityLiving());
                }
            }
        }
    }

    @SubscribeEvent
    public void onLootTableLoadEvent(LootTableLoadEvent event) {
        if (event.getName() != null && event.getTable() != null && (event.getName().equals((Object)LootTableList.field_186422_d) || event.getName().equals((Object)LootTableList.field_186424_f) || event.getName().equals((Object)LootTableList.field_186425_g) || event.getName().equals((Object)LootTableList.field_186430_l) || event.getName().equals((Object)LootTableList.field_186421_c) || event.getName().equals((Object)LootTableList.field_186431_m) || event.getName().equals((Object)LootTableList.field_186429_k))) {
            ModLogger.debug("Adding blueprints to dungeon loot...");
            LootTable table = event.getTable();
            LootCondition[] emptyCondition = new LootCondition[]{};
            LootPool pool = table.getPool("main");
            if (pool != null) {
                SetNBT fissionNBTFunc = new SetNBT(emptyCondition, BlueprintUtil.createStack(ModBlueprints.fission).func_77978_p());
                SetNBT fusionNBTFunc = new SetNBT(emptyCondition, BlueprintUtil.createStack(ModBlueprints.fusion).func_77978_p());
                pool.addEntry((LootEntry)new LootEntryItem((Item)ModItems.blueprint, 5, 0, new LootFunction[]{fissionNBTFunc}, emptyCondition, ModItems.blueprint.getRegistryName().toString() + "_fission"));
                pool.addEntry((LootEntry)new LootEntryItem((Item)ModItems.blueprint, 5, 0, new LootFunction[]{fusionNBTFunc}, emptyCondition, ModItems.blueprint.getRegistryName().toString() + "_fusion"));
            }
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (ModConfig.reactionItemMeetFluid) {
            World world = event.world;
            ArrayList entities = new ArrayList(world.field_72996_f);
            for (Object entity : entities) {
                if (!(entity instanceof EntityItem)) continue;
                ChemicalFluidReactionHandler.getInstance().checkEntityItem(world, (EntityItem)entity);
            }
        }
    }

    @SubscribeEvent
    public void onSoundRegister(RegistryEvent.Register<SoundEvent> event) {
        ModSounds.registerSounds((IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    @SubscribeEvent
    public void onIRecipeRegister(RegistryEvent.Register<IRecipe> event) {
        ModRecipes.registerCustomRecipes((IForgeRegistry<IRecipe>)event.getRegistry());
        ModRecipes.registerRecipes();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onISynthesisRecipeRegister(RegistryEvent.Register<ISynthesisRecipe> event) {
        ModRecipes.registerSynthesisRecipes();
    }

    @SubscribeEvent
    public void onEnchantmentRegister(RegistryEvent.Register<Enchantment> event) {
        ModEnchantments.register((IForgeRegistry<Enchantment>)event.getRegistry());
    }

    @SubscribeEvent
    public void onPotionRegister(RegistryEvent.Register<Potion> event) {
        ModPotions.registerPotions((IForgeRegistry<Potion>)event.getRegistry());
    }

    @SubscribeEvent
    public void onBlueprintRegister(RegistryEvent.Register<IMinechemBlueprint> event) {
        ModBlueprints.registerBlueprints();
    }

    @SubscribeEvent
    public void onRegistryRegister(RegistryEvent.NewRegistry event) {
        new ModRegistries();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void afterWorldRender(RenderWorldLastEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        TileBlueprintProjector projector;
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiBlueprintProjector && ((GuiBlueprintProjector)Minecraft.func_71410_x().field_71462_r).getProjector() != null && (projector = ((GuiBlueprintProjector)Minecraft.func_71410_x().field_71462_r).getProjector()).hasBlueprint()) {
            if (BlueprintUtil.blockAccess == null || !BlueprintUtil.blockAccess.data.multiblock.getDescriptiveName().equals(projector.getBlueprint().getDescriptiveName())) {
                BlueprintUtil.blockAccess = new BlueprintUtil.MultiblockBlockAccess(new BlueprintUtil.MultiblockRenderInfo(projector.getBlueprint()));
            }
            int totalLayers = BlueprintUtil.blockAccess.data.structureHeight;
            if (BlueprintUtil.structureRenderTicks >= 20) {
                BlueprintUtil.structureRenderTicks = 0;
                if (++BlueprintUtil.currentLayer > totalLayers) {
                    BlueprintUtil.currentLayer = 0;
                }
                BlueprintUtil.blockAccess.data.setShowLayer(BlueprintUtil.currentLayer);
            } else {
                ++BlueprintUtil.structureRenderTicks;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFogOverlay(EntityViewRenderEvent.RenderFogEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (player.func_70055_a(Material.field_151586_h) && !player.func_184812_l_() && !player.func_175149_v()) {
            double d0 = player.field_70163_u + (double)player.func_70047_e();
            BlockPos blockpos = new BlockPos(player.field_70165_t, d0, player.field_70161_v);
            if (!(world.func_180495_p(blockpos).func_177230_c() instanceof BlockFluidMinechem)) {
                return;
            }
            GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            GlStateManager.func_179102_b((float)(event.getFarPlaneDistance() * 0.05f));
            GlStateManager.func_179153_c((float)(Math.min(event.getFarPlaneDistance(), 192.0f) * 0.5f));
            event.setResult(Event.Result.DENY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onFogColor(EntityViewRenderEvent.FogColors event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (player.func_70055_a(Material.field_151586_h) && !player.func_184812_l_() && !player.func_175149_v()) {
            double d0 = player.field_70163_u + (double)player.func_70047_e();
            BlockPos blockpos = new BlockPos(player.field_70165_t, d0, player.field_70161_v);
            if (!(world.func_180495_p(blockpos).func_177230_c() instanceof BlockFluidMinechem)) {
                return;
            }
            Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
            BlockFluidMinechem fluidBlock = (BlockFluidMinechem)world.func_180495_p(blockpos).func_177230_c();
            if (fluidBlock.getFluid() instanceof FluidElement) {
                color = new Color(((FluidElement)fluidBlock.getFluid()).getColor());
            } else if (fluidBlock.getFluid() instanceof FluidMolecule) {
                color = new Color(((FluidMolecule)fluidBlock.getFluid()).getColor());
            }
            float red = (float)color.getRed() / 255.0f;
            float green = (float)color.getGreen() / 255.0f;
            float blue = (float)color.getBlue() / 255.0f;
            event.setRed(red);
            event.setGreen(green);
            event.setBlue(blue);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderOverlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (player.func_70055_a(Material.field_151586_h) && !player.func_184812_l_() && !player.func_175149_v()) {
                double d0 = player.field_70163_u + (double)player.func_70047_e();
                BlockPos blockpos = new BlockPos(player.field_70165_t, d0, player.field_70161_v);
                if (!(world.func_180495_p(blockpos).func_177230_c() instanceof BlockFluidMinechem)) {
                    return;
                }
                Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
                BlockFluidMinechem fluidBlock = (BlockFluidMinechem)world.func_180495_p(blockpos).func_177230_c();
                if (fluidBlock.getFluid() instanceof FluidElement) {
                    color = new Color(((FluidElement)fluidBlock.getFluid()).getColor());
                } else if (fluidBlock.getFluid() instanceof FluidMolecule) {
                    color = new Color(((FluidMolecule)fluidBlock.getFluid()).getColor());
                }
                GuiIngame gui = Minecraft.func_71410_x().field_71456_v;
                if (gui == null) {
                    return;
                }
                ScaledResolution scaledRes = event.getResolution();
                int i1 = scaledRes.func_78326_a() / 2 + 91;
                int j1 = scaledRes.func_78328_b() - 39;
                int k2 = j1 - 10;
                int i6 = Minecraft.func_71410_x().field_71439_g.func_70086_ai();
                int k6 = MathHelper.func_76143_f((double)((double)(i6 - 2) * 10.0 / 300.0));
                int i7 = MathHelper.func_76143_f((double)((double)i6 * 10.0 / 300.0)) - k6;
                for (int k7 = 0; k7 < k6 + i7; ++k7) {
                    float red = (float)color.getRed() / 255.0f;
                    float green = (float)color.getGreen() / 255.0f;
                    float blue = (float)color.getBlue() / 255.0f;
                    GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("minechem", "textures/gui/icons.png"));
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179126_j();
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    if (k7 < k6) {
                        gui.func_73729_b(i1 - k7 * 8 - 9, k2, 16, 18, 9, 9);
                    } else {
                        gui.func_73729_b(i1 - k7 * 8 - 9, k2, 25, 18, 9, 9);
                    }
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (k7 < k6) {
                        gui.func_73729_b(i1 - k7 * 8 - 9, k2, 16, 27, 9, 9);
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onDecayEvent(RadiationDecayEvent event) {
        if (event.getPlayer() != null) {
            String nameBeforeDecay = event.getLongName(event.getBefore());
            String nameAfterDecay = event.getLongName(event.getAfter());
            String time = TickTimeUtil.getTimeFromTicks(event.getTime());
            String message = String.format("Radiation Warning: Element %s decayed into %s after %s.", nameBeforeDecay, nameAfterDecay, time);
            event.getPlayer().func_145747_a((ITextComponent)new TextComponentString(message));
        }
    }

    @SubscribeEvent
    public void getFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        ItemStack stack = event.getItemStack();
        int burnTime = -1;
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() == ModItems.element && MinechemUtil.getElement(stack) != null) {
                burnTime = MinechemUtil.getElement(stack).getFuelBurnTime();
            } else if (stack.func_77973_b() == ModItems.molecule) {
                burnTime = MinechemUtil.getMolecule(stack).getFuelBurnTime();
            }
        }
        if (burnTime > 0) {
            event.setBurnTime(burnTime);
        }
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("minechem")) {
            ModConfig.loadConfig();
        }
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)event.getSource().func_76346_g();
            ItemStack weapon = ItemStack.field_190927_a;
            Iterable weapons = entity.func_184214_aD();
            for (ItemStack stack : weapons) {
                if (!(stack.func_77973_b() instanceof ItemSword)) continue;
                weapon = stack.func_77946_l();
            }
            if (weapon.func_190926_b()) {
                return;
            }
            NBTTagList list = weapon.func_77986_q();
            if (list == null) {
                return;
            }
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound enchantmentTag = list.func_150305_b(i);
                Enchantment enchant = Enchantment.func_185262_c((int)enchantmentTag.func_74765_d("id"));
                if (!(enchant instanceof PotionEnchantmentCoated)) continue;
                ((PotionEnchantmentCoated)enchant).applyEffect(event.getEntityLiving());
            }
        }
    }

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getState().func_177230_c() == ModBlocks.blueprintProjector) {
            ItemStack stack;
            TileBlueprintProjector projector;
            IMinechemBlueprint blueprint;
            event.setCanceled(true);
            EntityPlayer player = event.getPlayer();
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            IBlockState iblockstate = world.func_180495_p(pos);
            TileEntity tileentity = world.func_175625_s(pos);
            ItemStack droppedStack = ItemStack.field_190927_a;
            if (tileentity != null && tileentity instanceof TileBlueprintProjector && (blueprint = (projector = (TileBlueprintProjector)tileentity).getBlueprint()) != null) {
                droppedStack = BlueprintUtil.createStack(blueprint);
                projector.setBlueprint(null);
                projector.destroyProjection();
            }
            if (!(stack = player.func_184614_ca()).func_190926_b() && stack.func_77973_b().onBlockStartBreak(stack, pos, player)) {
                return;
            }
            if (!droppedStack.func_190926_b()) {
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)droppedStack);
            }
            world.func_180498_a(player, 2001, pos, Block.func_176210_f((IBlockState)iblockstate));
            boolean flag1 = false;
            if (player.func_184812_l_()) {
                flag1 = iblockstate.func_177230_c().removedByPlayer(iblockstate, world, pos, player, false);
                if (flag1) {
                    iblockstate.func_177230_c().func_176206_d(world, pos, iblockstate);
                }
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            } else {
                ItemStack itemstack1 = player.func_184614_ca();
                ItemStack itemstack2 = itemstack1.func_190926_b() ? ItemStack.field_190927_a : itemstack1.func_77946_l();
                boolean flag = iblockstate.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, player);
                if (!itemstack1.func_190926_b()) {
                    itemstack1.func_179548_a(world, iblockstate, pos, player);
                    if (itemstack1.func_190926_b()) {
                        ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)itemstack2, (EnumHand)EnumHand.MAIN_HAND);
                    }
                }
                if (flag1 = iblockstate.func_177230_c().removedByPlayer(iblockstate, world, pos, player, false)) {
                    iblockstate.func_177230_c().func_176206_d(world, pos, iblockstate);
                }
                if (flag1 && flag) {
                    iblockstate.func_177230_c().func_180657_a(world, player, pos, iblockstate, tileentity, itemstack2);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
    }
}

