/*
 * Decompiled with CFR 0.152.
 */
package minechem.init;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import minechem.api.ICustomRenderer;
import minechem.block.fluid.BlockFluidElement;
import minechem.block.fluid.BlockFluidMolecule;
import minechem.fluid.FluidElement;
import minechem.fluid.FluidMinechem;
import minechem.fluid.FluidMolecule;
import minechem.item.MatterState;
import minechem.item.MinechemChemicalType;
import minechem.item.element.ElementEnum;
import minechem.item.molecule.MoleculeEnum;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class ModFluids {
    public static Map<MoleculeEnum, Fluid> FLUID_MOLECULES = new IdentityHashMap<MoleculeEnum, Fluid>();
    public static Map<ElementEnum, FluidElement> FLUID_ELEMENTS = new IdentityHashMap<ElementEnum, FluidElement>();
    public static Map<Fluid, Block> FLUID_MOLECULE_BLOCKS = new IdentityHashMap<Fluid, Block>();
    public static Map<FluidElement, Block> FLUID_ELEMENT_BLOCKS = new IdentityHashMap<FluidElement, Block>();

    public static void init() {
        FluidMinechem fluid;
        for (ElementEnum element : ElementEnum.elements.values()) {
            if (element == null || element.roomState() != MatterState.LIQUID && element.roomState() != MatterState.GAS) continue;
            fluid = (FluidElement)ModFluids.createFluid(element);
            FLUID_ELEMENTS.put(element, (FluidElement)fluid);
            FLUID_ELEMENT_BLOCKS.put((FluidElement)fluid, (Block)new BlockFluidElement(fluid));
        }
        for (MoleculeEnum molecule : MoleculeEnum.molecules.values()) {
            Object fluidBlock;
            if (molecule == null || molecule.roomState() != MatterState.LIQUID && molecule.roomState() != MatterState.GAS) continue;
            if (molecule == MoleculeEnum.water) {
                fluid = FluidRegistry.WATER;
                FLUID_MOLECULES.put(molecule, fluid);
                fluidBlock = Blocks.field_150355_j;
                FLUID_MOLECULE_BLOCKS.put(fluid, (Block)fluidBlock);
                continue;
            }
            fluid = (FluidMolecule)ModFluids.createFluid(molecule);
            FLUID_MOLECULES.put(molecule, fluid);
            fluidBlock = new BlockFluidMolecule(fluid);
            FLUID_MOLECULE_BLOCKS.put(fluid, (Block)fluidBlock);
        }
    }

    public static void initModels() {
        for (Block block : FLUID_ELEMENT_BLOCKS.values()) {
            if (!(block instanceof BlockFluidElement)) continue;
            ((ICustomRenderer)block).registerRenderer();
        }
        for (Block block : FLUID_MOLECULE_BLOCKS.values()) {
            if (!(block instanceof BlockFluidMolecule)) continue;
            ((ICustomRenderer)block).registerRenderer();
        }
    }

    private static Fluid createFluid(MinechemChemicalType type) {
        FluidMinechem fluid = type instanceof ElementEnum ? new FluidElement((ElementEnum)type) : new FluidMolecule((MoleculeEnum)type);
        boolean useOwnFluid = FluidRegistry.registerFluid((Fluid)fluid);
        if (!useOwnFluid) {
            fluid = FluidRegistry.getFluid((String)fluid.getName());
        }
        return fluid;
    }

    public static List<Block> getFluidBlocks() {
        if (FLUID_ELEMENT_BLOCKS.size() <= 0 || FLUID_MOLECULE_BLOCKS.size() <= 0) {
            ModFluids.init();
        }
        ArrayList blockList = Lists.newArrayList();
        for (Block block : FLUID_ELEMENT_BLOCKS.values()) {
            blockList.add(block);
        }
        for (Block block : FLUID_MOLECULE_BLOCKS.values()) {
            blockList.add(block);
        }
        return blockList;
    }
}

