/*
 * Decompiled with CFR 0.152.
 */
package minechem.init;

import com.google.common.collect.Lists;
import java.util.List;
import minechem.api.ICustomRenderer;
import minechem.init.ModFluids;
import minechem.item.ItemAtomicManipulator;
import minechem.item.ItemChemistJournal;
import minechem.item.ItemElement;
import minechem.item.ItemMicroscopeLens;
import minechem.item.ItemMolecule;
import minechem.item.ItemPolytool;
import minechem.item.blueprint.ItemBlueprint;
import minechem.item.element.ElementEnum;
import minechem.item.molecule.MoleculeEnum;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ModItems {
    private static List<Item> ITEM_LIST = Lists.newArrayList();
    public static ItemElement element;
    public static ItemMolecule molecule;
    public static ItemMicroscopeLens lens;
    public static ItemAtomicManipulator atomicManipulator;
    public static ItemBlueprint blueprint;
    public static ItemChemistJournal journal;
    public static ItemStack convexLens;
    public static ItemStack concaveLens;
    public static ItemStack projectorLens;
    public static ItemStack microscopeLens;
    public static ItemStack minechempills;
    public static Item polytool;
    public static ItemStack emptyTube;

    public static void init() {
        element = new ItemElement();
        ITEM_LIST.add(element);
        molecule = new ItemMolecule();
        ITEM_LIST.add(molecule);
        lens = new ItemMicroscopeLens();
        ITEM_LIST.add(lens);
        concaveLens = new ItemStack((Item)lens, 1, 0);
        convexLens = new ItemStack((Item)lens, 1, 1);
        microscopeLens = new ItemStack((Item)lens, 1, 2);
        projectorLens = new ItemStack((Item)lens, 1, 3);
        atomicManipulator = new ItemAtomicManipulator();
        ITEM_LIST.add(atomicManipulator);
        blueprint = new ItemBlueprint();
        ITEM_LIST.add(blueprint);
        journal = new ItemChemistJournal();
        ITEM_LIST.add(journal);
        polytool = new ItemPolytool();
        ITEM_LIST.add(polytool);
        emptyTube = new ItemStack((Item)element, 1, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderers() {
        for (Item item : ITEM_LIST) {
            if (!(item instanceof ICustomRenderer)) continue;
            ((ICustomRenderer)item).registerRenderer();
        }
    }

    public static void registerFluidContainers() {
        for (ElementEnum element : ElementEnum.elements.values()) {
            if (element == null) continue;
            ItemStack itemStack = new ItemStack((Item)ModItems.element, 1, element.atomicNumber());
        }
        for (MoleculeEnum molecule : MoleculeEnum.molecules.values()) {
            if (molecule == null) continue;
            ItemStack tube = new ItemStack((Item)ModItems.molecule, 1, molecule.id());
            FluidStack fluidStack = new FluidStack(FluidRegistry.WATER, 125);
            if (molecule.name().equals("water")) continue;
            FluidStack fluidStack2 = new FluidStack(ModFluids.FLUID_MOLECULES.get(molecule), 125);
        }
    }

    public static void registerToOreDictionary() {
        for (ElementEnum element : ElementEnum.elements.values()) {
            OreDictionary.registerOre((String)("element_" + element.name()), (ItemStack)new ItemStack((Item)ModItems.element, 1, element.atomicNumber()));
        }
        for (MoleculeEnum molecule : MoleculeEnum.molecules.values()) {
            OreDictionary.registerOre((String)("molecule_" + molecule.name()), (ItemStack)new ItemStack((Item)ModItems.molecule, 1, molecule.id()));
        }
        OreDictionary.registerOre((String)"dustSaltpeter", (ItemStack)new ItemStack((Item)molecule, 1, MoleculeEnum.potassiumNitrate.id()));
        OreDictionary.registerOre((String)"dustSalt", (ItemStack)new ItemStack((Item)molecule, 1, MoleculeEnum.salt.id()));
        OreDictionary.registerOre((String)"quicksilver", (ItemStack)new ItemStack((Item)element, 1, ElementEnum.Hg.atomicNumber()));
    }
}

