/*
 * Decompiled with CFR 0.152.
 */
package minechem.init;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Locale;
import minechem.api.IOreDictionaryHandler;
import minechem.handler.oredict.OreDictionaryAppliedEnergisticsHandler;
import minechem.handler.oredict.OreDictionaryDefaultHandler;
import minechem.handler.oredict.OreDictionaryExtraUtilitiesHandler;
import minechem.init.ModBlocks;
import minechem.init.ModBlueprints;
import minechem.init.ModConfig;
import minechem.init.ModFluids;
import minechem.init.ModIntegration;
import minechem.init.ModItems;
import minechem.init.ModLogger;
import minechem.item.ItemElement;
import minechem.item.element.Element;
import minechem.item.element.ElementEnum;
import minechem.item.molecule.Molecule;
import minechem.item.molecule.MoleculeEnum;
import minechem.potion.PotionChemical;
import minechem.recipe.RecipeCloneChemistJournal;
import minechem.recipe.RecipeDecomposer;
import minechem.recipe.RecipeDecomposerChance;
import minechem.recipe.RecipeDecomposerFluid;
import minechem.recipe.RecipeDecomposerFluidSelect;
import minechem.recipe.RecipeDecomposerSelect;
import minechem.recipe.RecipeDecomposerSuper;
import minechem.recipe.RecipePotionCoating;
import minechem.recipe.RecipePotionSpiking;
import minechem.recipe.handler.RecipeHandlerSynthesis;
import minechem.utils.BlueprintUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModRecipes {
    private static final ModRecipes recipes = new ModRecipes();
    public static int BLOCK_MULTIPLIER = 8;
    public static int COST_INGOT = 300;
    public static int COST_BLOCK = 15;
    public static int COST_ITEM = 10;
    public static int COST_METALBLOCK = COST_INGOT * BLOCK_MULTIPLIER;
    public static int COST_PLANK = 20;
    public static int COST_LAPIS = 20;
    public static int COST_LAPISBLOCK = COST_LAPIS * BLOCK_MULTIPLIER;
    public static int COST_GRASS = 40;
    public static int COST_SMOOTH = 30;
    public static int COST_STAR = 6000;
    public static int COST_SUGAR = 30;
    public static int COST_GLOW = 70;
    public static int COST_GLOWBLOCK = COST_GLOW * 4;
    public static int COST_TEAR = 3000;
    public static int COST_OBSIDIAN = 100;
    public static int COST_PLANT = 200;
    public static int COST_FOOD = 250;
    public static int COST_WOOD = COST_PLANK * 4;
    public static int COST_GLASS = 300;
    public static int COST_PANE = COST_GLASS / 3;
    public static int COST_WOOL = 200;
    public static int COST_CARPET = COST_WOOL / 2;
    public static int COST_GEM = 1000;
    public static int COST_GEMBLOCK = COST_GEM * BLOCK_MULTIPLIER;
    Molecule siO = new Molecule(MoleculeEnum.siliconDioxide, 1);
    Molecule moleculeSiliconDioxide = ModRecipes.molecule(MoleculeEnum.siliconDioxide, 4);
    Molecule moleculeCellulose = ModRecipes.molecule(MoleculeEnum.cellulose, 1);
    Molecule moleculePolyvinylChloride = ModRecipes.molecule(MoleculeEnum.polyvinylChloride);
    Molecule moleculeLazurite = ModRecipes.molecule(MoleculeEnum.lazurite, 9);
    Element elementHydrogen = ModRecipes.element(ElementEnum.H, 64);
    Element elementHelium = ModRecipes.element(ElementEnum.He, 64);
    Element elementCarbon = ModRecipes.element(ElementEnum.C, 64);
    ItemStack blockSandStone = new ItemStack(Blocks.field_150322_A, 1, 0);
    ItemStack blockChiseledSandStone = new ItemStack(Blocks.field_150322_A, 1, 1);
    ItemStack blockSmoothSandStone = new ItemStack(Blocks.field_150322_A, 1, 2);
    ItemStack blockWool = new ItemStack(Blocks.field_150325_L, 1, 0);
    ItemStack blockOrangeWool = new ItemStack(Blocks.field_150325_L, 1, 1);
    ItemStack blockMagentaWool = new ItemStack(Blocks.field_150325_L, 1, 2);
    ItemStack blockLightBlueWool = new ItemStack(Blocks.field_150325_L, 1, 3);
    ItemStack blockYellowWool = new ItemStack(Blocks.field_150325_L, 1, 4);
    ItemStack blockLimeWool = new ItemStack(Blocks.field_150325_L, 1, 5);
    ItemStack blockPinkWool = new ItemStack(Blocks.field_150325_L, 1, 6);
    ItemStack blockGrayWool = new ItemStack(Blocks.field_150325_L, 1, 7);
    ItemStack blockLightGrayWool = new ItemStack(Blocks.field_150325_L, 1, 8);
    ItemStack blockCyanWool = new ItemStack(Blocks.field_150325_L, 1, 9);
    ItemStack blockPurpleWool = new ItemStack(Blocks.field_150325_L, 1, 10);
    ItemStack blockBlueWool = new ItemStack(Blocks.field_150325_L, 1, 11);
    ItemStack blockBrownWool = new ItemStack(Blocks.field_150325_L, 1, 12);
    ItemStack blockGreenWool = new ItemStack(Blocks.field_150325_L, 1, 13);
    ItemStack blockRedWool = new ItemStack(Blocks.field_150325_L, 1, 14);
    ItemStack blockBlackWool = new ItemStack(Blocks.field_150325_L, 1, 15);
    ItemStack blockSunFlower = new ItemStack((Block)Blocks.field_150398_cm, 1, 0);
    ItemStack blockLilac = new ItemStack((Block)Blocks.field_150398_cm, 1, 1);
    ItemStack blockTallGrass = new ItemStack((Block)Blocks.field_150398_cm, 1, 2);
    ItemStack blockLargeFern = new ItemStack((Block)Blocks.field_150398_cm, 1, 3);
    ItemStack blockRoseBush = new ItemStack((Block)Blocks.field_150398_cm, 1, 4);
    ItemStack blockPeony = new ItemStack((Block)Blocks.field_150398_cm, 1, 5);
    ItemStack blockCobweb = new ItemStack(Blocks.field_150321_G);
    ItemStack blockLapis = new ItemStack(Blocks.field_150368_y);
    ItemStack blockOreLapis = new ItemStack(Blocks.field_150369_x);
    ItemStack blockGlassPane = new ItemStack(Blocks.field_150410_aZ);
    ItemStack blockWhiteStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 0);
    ItemStack blockOrangeStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 1);
    ItemStack blockMagentaStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 2);
    ItemStack blockLightBlueStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 3);
    ItemStack blockYellowStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 4);
    ItemStack blockLimeStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 5);
    ItemStack blockPinkStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 6);
    ItemStack blockGrayStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 7);
    ItemStack blockLightGrayStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 8);
    ItemStack blockCyanStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 9);
    ItemStack blockPurpleStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 10);
    ItemStack blockBlueStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 11);
    ItemStack blockBrownStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 12);
    ItemStack blockGreenStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 13);
    ItemStack blockRedStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 14);
    ItemStack blockBlackStainedGlassPane = new ItemStack((Block)Blocks.field_150397_co, 1, 15);
    ItemStack blockGlass = new ItemStack(Blocks.field_150359_w);
    ItemStack blockWhiteStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 0);
    ItemStack blockOrangeStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 1);
    ItemStack blockMagentaStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 2);
    ItemStack blockLightBlueStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 3);
    ItemStack blockYellowStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 4);
    ItemStack blockLimeStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 5);
    ItemStack blockPinkStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 6);
    ItemStack blockGrayStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 7);
    ItemStack blockLightGrayStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 8);
    ItemStack blockCyanStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 9);
    ItemStack blockPurpleStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 10);
    ItemStack blockBlueStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 11);
    ItemStack blockBrownStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 12);
    ItemStack blockGreenStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 13);
    ItemStack blockRedStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 14);
    ItemStack blockBlackStainedGlass = new ItemStack((Block)Blocks.field_150399_cn, 1, 15);
    ItemStack itemDyePowderBlack = new ItemStack(Items.field_151100_aR, 1, 0);
    ItemStack itemDyePowderRed = new ItemStack(Items.field_151100_aR, 1, 1);
    ItemStack itemDyePowderGreen = new ItemStack(Items.field_151100_aR, 1, 2);
    ItemStack itemDyePowderBrown = new ItemStack(Items.field_151100_aR, 1, 3);
    ItemStack itemDyePowderBlue = new ItemStack(Items.field_151100_aR, 1, 4);
    ItemStack itemDyePowderPurple = new ItemStack(Items.field_151100_aR, 1, 5);
    ItemStack itemDyePowderCyan = new ItemStack(Items.field_151100_aR, 1, 6);
    ItemStack itemDyePowderLightGray = new ItemStack(Items.field_151100_aR, 1, 7);
    ItemStack itemDyePowderGray = new ItemStack(Items.field_151100_aR, 1, 8);
    ItemStack itemDyePowderPink = new ItemStack(Items.field_151100_aR, 1, 9);
    ItemStack itemDyePowderLime = new ItemStack(Items.field_151100_aR, 1, 10);
    ItemStack itemDyePowderYellow = new ItemStack(Items.field_151100_aR, 1, 11);
    ItemStack itemDyePowderLightBlue = new ItemStack(Items.field_151100_aR, 1, 12);
    ItemStack itemDyePowderMagenta = new ItemStack(Items.field_151100_aR, 1, 13);
    ItemStack itemDyePowderOrange = new ItemStack(Items.field_151100_aR, 1, 14);
    ItemStack itemDyePowderWhite = new ItemStack(Items.field_151100_aR, 1, 15);
    ItemStack blockOakLeaves = new ItemStack((Block)Blocks.field_150362_t, 1, 0);
    ItemStack blockSpruceLeaves = new ItemStack((Block)Blocks.field_150362_t, 1, 1);
    ItemStack blockBirchLeaves = new ItemStack((Block)Blocks.field_150362_t, 1, 2);
    ItemStack blockJungleLeaves = new ItemStack((Block)Blocks.field_150362_t, 1, 3);
    ItemStack blockAcaciaLeaves = new ItemStack((Block)Blocks.field_150361_u, 1, 0);
    ItemStack blockDarkOakLeaves = new ItemStack((Block)Blocks.field_150361_u, 1, 1);
    ItemStack blockOakLog = new ItemStack(Blocks.field_150364_r, 1, 0);
    ItemStack blockSpruceLog = new ItemStack(Blocks.field_150364_r, 1, 1);
    ItemStack blockBirchLog = new ItemStack(Blocks.field_150364_r, 1, 2);
    ItemStack blockJungleLog = new ItemStack(Blocks.field_150364_r, 1, 3);
    ItemStack blockAcaciaLog = new ItemStack(Blocks.field_150363_s, 1, 0);
    ItemStack blockDarkOakLog = new ItemStack(Blocks.field_150363_s, 1, 1);
    ItemStack coalOre = new ItemStack(Blocks.field_150365_q);
    ItemStack ironOre = new ItemStack(Blocks.field_150366_p);
    ItemStack goldOre = new ItemStack(Blocks.field_150352_o);
    ItemStack blockGravel = new ItemStack(Blocks.field_150351_n);
    ItemStack blockSand = new ItemStack((Block)Blocks.field_150354_m);
    ItemStack blockOakSapling = new ItemStack(Blocks.field_150345_g, 1, 0);
    ItemStack blockSpruceSapling = new ItemStack(Blocks.field_150345_g, 1, 1);
    ItemStack blockBirchSapling = new ItemStack(Blocks.field_150345_g, 1, 2);
    ItemStack blockJungleSapling = new ItemStack(Blocks.field_150345_g, 1, 3);
    ItemStack blockAcaciaSapling = new ItemStack(Blocks.field_150345_g, 1, 4);
    ItemStack blockDarkOakSapling = new ItemStack(Blocks.field_150345_g, 1, 5);
    ItemStack blockOakWoodSlabs = new ItemStack((Block)Blocks.field_150376_bx, 1, 0);
    ItemStack blockSpruceWoodSlabs = new ItemStack((Block)Blocks.field_150376_bx, 1, 1);
    ItemStack blockBirchWoodSlabs = new ItemStack((Block)Blocks.field_150376_bx, 1, 2);
    ItemStack blockJungleWoodSlabs = new ItemStack((Block)Blocks.field_150376_bx, 1, 3);
    ItemStack blockAcaciaWoodSlabs = new ItemStack((Block)Blocks.field_150376_bx, 1, 4);
    ItemStack blockDarkOakWoodSlabs = new ItemStack((Block)Blocks.field_150376_bx, 1, 5);
    ItemStack blockOakWoodPlanks = new ItemStack(Blocks.field_150344_f, 1, 0);
    ItemStack blockSpruceWoodPlanks = new ItemStack(Blocks.field_150344_f, 1, 1);
    ItemStack blockBirchWoodPlanks = new ItemStack(Blocks.field_150344_f, 1, 2);
    ItemStack blockJungleWoodPlanks = new ItemStack(Blocks.field_150344_f, 1, 3);
    ItemStack blockAcaciaWoodPlanks = new ItemStack(Blocks.field_150344_f, 1, 4);
    ItemStack blockDarkOakWoodPlanks = new ItemStack(Blocks.field_150344_f, 1, 5);
    ItemStack blockCobblestone = new ItemStack(Blocks.field_150347_e);
    ItemStack blockDirt = new ItemStack(Blocks.field_150346_d, 1, 0);
    ItemStack blockPodzol = new ItemStack(Blocks.field_150346_d, 1, 2);
    ItemStack blockGrass = new ItemStack((Block)Blocks.field_150349_c, 1, 0);
    ItemStack blockStone = new ItemStack(Blocks.field_150348_b);
    ItemStack carpetBlockWool = new ItemStack(Blocks.field_150404_cg, 1, 0);
    ItemStack carpetBlockOrangeWool = new ItemStack(Blocks.field_150404_cg, 1, 1);
    ItemStack carpetBlockMagentaWool = new ItemStack(Blocks.field_150404_cg, 1, 2);
    ItemStack carpetBlockLightBlueWool = new ItemStack(Blocks.field_150404_cg, 1, 3);
    ItemStack carpetBlockYellowWool = new ItemStack(Blocks.field_150404_cg, 1, 4);
    ItemStack carpetBlockLimeWool = new ItemStack(Blocks.field_150404_cg, 1, 5);
    ItemStack carpetBlockPinkWool = new ItemStack(Blocks.field_150404_cg, 1, 6);
    ItemStack carpetBlockGrayWool = new ItemStack(Blocks.field_150404_cg, 1, 7);
    ItemStack carpetBlockLightGrayWool = new ItemStack(Blocks.field_150404_cg, 1, 8);
    ItemStack carpetBlockCyanWool = new ItemStack(Blocks.field_150404_cg, 1, 9);
    ItemStack carpetBlockPurpleWool = new ItemStack(Blocks.field_150404_cg, 1, 10);
    ItemStack carpetBlockBlueWool = new ItemStack(Blocks.field_150404_cg, 1, 11);
    ItemStack carpetBlockBrownWool = new ItemStack(Blocks.field_150404_cg, 1, 12);
    ItemStack carpetBlockGreenWool = new ItemStack(Blocks.field_150404_cg, 1, 13);
    ItemStack carpetBlockRedWool = new ItemStack(Blocks.field_150404_cg, 1, 14);
    ItemStack carpetBlockBlackWool = new ItemStack(Blocks.field_150404_cg, 1, 15);
    ItemStack blockYellowFlower = new ItemStack((Block)Blocks.field_150327_N);
    ItemStack blockPoppyFlower = new ItemStack((Block)Blocks.field_150328_O, 1, 0);
    ItemStack blockBlueOrchid = new ItemStack((Block)Blocks.field_150328_O, 1, 1);
    ItemStack blockAllium = new ItemStack((Block)Blocks.field_150328_O, 1, 2);
    ItemStack blockAsureBluet = new ItemStack((Block)Blocks.field_150328_O, 1, 3);
    ItemStack blockRedTulip = new ItemStack((Block)Blocks.field_150328_O, 1, 4);
    ItemStack blockOrangeTulip = new ItemStack((Block)Blocks.field_150328_O, 1, 5);
    ItemStack blockWhiteTulip = new ItemStack((Block)Blocks.field_150328_O, 1, 6);
    ItemStack blockPinkTulip = new ItemStack((Block)Blocks.field_150328_O, 1, 7);
    ItemStack blockOxeyeDaisy = new ItemStack((Block)Blocks.field_150328_O, 1, 8);
    ItemStack blockMushroomBrown = new ItemStack((Block)Blocks.field_150338_P);
    ItemStack blockMushroomRed = new ItemStack((Block)Blocks.field_150337_Q);
    ItemStack blockTnt = new ItemStack(Blocks.field_150335_W);
    ItemStack blockObsidian = new ItemStack(Blocks.field_150343_Z);
    ItemStack blockOreDiamond = new ItemStack(Blocks.field_150482_ag);
    ItemStack blockDiamond = new ItemStack(Blocks.field_150484_ah);
    ItemStack blockPressurePlatePlanks = new ItemStack(Blocks.field_150452_aw);
    ItemStack blockOreRedstone = new ItemStack(Blocks.field_150450_ax);
    ItemStack blockCactus = new ItemStack((Block)Blocks.field_150434_aF);
    ItemStack blockPumpkin = new ItemStack(Blocks.field_150423_aK);
    ItemStack pumpkinSeed = new ItemStack(Items.field_151080_bb);
    ItemStack blockNetherrack = new ItemStack(Blocks.field_150424_aL);
    ItemStack itemNetherbrick = new ItemStack(Items.field_151130_bT);
    ItemStack itemPotion = new ItemStack((Item)Items.field_151068_bn, 1, 0);
    ItemStack blockIce = new ItemStack(Blocks.field_150432_aD);
    ItemStack blockSlowSand = new ItemStack(Blocks.field_150425_aM);
    ItemStack blockGlowStone = new ItemStack(Blocks.field_150426_aN);
    ItemStack blockMycelium = new ItemStack((Block)Blocks.field_150391_bh);
    ItemStack blockWhiteStone = new ItemStack(Blocks.field_150377_bs);
    ItemStack blockOreEmerald = new ItemStack(Blocks.field_150412_bA);
    ItemStack blockEmerald = new ItemStack(Blocks.field_150475_bE);
    ItemStack itemAppleRed = new ItemStack(Items.field_151034_e);
    ItemStack itemArrow = new ItemStack(Items.field_151032_g);
    ItemStack itemCoal = new ItemStack(Items.field_151044_h);
    ItemStack blockCoal = new ItemStack(Blocks.field_150402_ci);
    ItemStack itemChar = new ItemStack(Items.field_151044_h, 1, 1);
    ItemStack itemDiamond = new ItemStack(Items.field_151045_i);
    ItemStack itemIngotIron = new ItemStack(Items.field_151042_j);
    ItemStack itemIngotGold = new ItemStack(Items.field_151043_k);
    ItemStack itemStick = new ItemStack(Items.field_151055_y);
    ItemStack itemString = new ItemStack(Items.field_151007_F);
    ItemStack itemFeather = new ItemStack(Items.field_151008_G);
    ItemStack itemGunpowder = new ItemStack(Items.field_151016_H);
    ItemStack itemBread = new ItemStack(Items.field_151025_P);
    ItemStack itemFlint = new ItemStack(Items.field_151145_ak);
    ItemStack itemAppleGold = new ItemStack(Items.field_151153_ao, 1, 0);
    ItemStack itemDoorAcacia = new ItemStack(Items.field_179572_au);
    ItemStack itemDoorBirch = new ItemStack(Items.field_179568_as);
    ItemStack itemDoorDarkOak = new ItemStack(Items.field_179571_av);
    ItemStack itemDoorJungle = new ItemStack(Items.field_179567_at);
    ItemStack itemDoorOak = new ItemStack(Items.field_179570_aq);
    ItemStack itemDoorSpruce = new ItemStack(Items.field_179569_ar);
    ItemStack itemBucket = new ItemStack(Items.field_151133_ar);
    ItemStack itemBucketWater = new ItemStack(Items.field_151131_as);
    ItemStack itemRedstoneDust = new ItemStack(Items.field_151137_ax);
    ItemStack blockRedstone = new ItemStack(Blocks.field_150451_bX);
    ItemStack itemSnowball = new ItemStack(Items.field_151126_ay);
    ItemStack itemLeather = new ItemStack(Items.field_151116_aA);
    ItemStack itemBrick = new ItemStack(Items.field_151118_aC);
    ItemStack itemClayBall = new ItemStack(Items.field_151119_aD);
    ItemStack itemReed = new ItemStack(Items.field_151120_aE);
    ItemStack itemVine = new ItemStack(Blocks.field_150395_bd);
    ItemStack itemPaper = new ItemStack(Items.field_151121_aF);
    ItemStack itemCompass = new ItemStack(Items.field_151111_aL);
    ItemStack itemMap = new ItemStack((Item)Items.field_151148_bJ);
    ItemStack itemBook = new ItemStack(Items.field_151122_aG);
    ItemStack blockBook = new ItemStack(Blocks.field_150342_X);
    ItemStack itemSlimeBall = new ItemStack(Items.field_151123_aH);
    ItemStack itemGlowstone = new ItemStack(Items.field_151114_aO);
    ItemStack itemBone = new ItemStack(Items.field_151103_aS);
    ItemStack itemSugar = new ItemStack(Items.field_151102_aT);
    ItemStack itemMelon = new ItemStack(Items.field_151127_ba);
    ItemStack blockMelon = new ItemStack(Blocks.field_150440_ba);
    ItemStack itemChickenCooked = new ItemStack(Items.field_151077_bg);
    ItemStack itemRottenFlesh = new ItemStack(Items.field_151078_bh);
    ItemStack itemEnderPearl = new ItemStack(Items.field_151079_bi);
    ItemStack blockEnderDragonEgg = new ItemStack(Blocks.field_150380_bt);
    ItemStack itemBlazeRod = new ItemStack(Items.field_151072_bj);
    ItemStack itemBlazePowder = new ItemStack(Items.field_151065_br);
    ItemStack itemGhastTear = new ItemStack(Items.field_151073_bk);
    ItemStack itemNetherStalkSeeds = new ItemStack(Items.field_151075_bm);
    ItemStack itemSpiderEye = new ItemStack(Items.field_151070_bp);
    ItemStack itemFermentedSpiderEye = new ItemStack(Items.field_151071_bq);
    ItemStack itemMagmaCream = new ItemStack(Items.field_151064_bs);
    ItemStack itemSpeckledMelon = new ItemStack(Items.field_151060_bw);
    ItemStack itemEmerald = new ItemStack(Items.field_151166_bC);
    ItemStack itemWheat = new ItemStack(Items.field_151015_O);
    ItemStack itemCarrot = new ItemStack(Items.field_151172_bF);
    ItemStack itemPotato = new ItemStack(Items.field_151174_bG);
    ItemStack itemGoldenCarrot = new ItemStack(Items.field_151150_bK);
    ItemStack itemNetherStar = new ItemStack(Items.field_151156_bN);
    ItemStack itemNetherQuartz = new ItemStack(Items.field_151128_bU);
    ItemStack itemRecord13 = new ItemStack(Items.field_151096_cd);
    ItemStack itemRecordCat = new ItemStack(Items.field_151093_ce);
    ItemStack itemRecordFar = new ItemStack(Items.field_151092_ch);
    ItemStack itemRecordMall = new ItemStack(Items.field_151089_ci);
    ItemStack itemRecordMellohi = new ItemStack(Items.field_151090_cj);
    ItemStack itemRecordStal = new ItemStack(Items.field_151087_ck);
    ItemStack itemRecordStrad = new ItemStack(Items.field_151088_cl);
    ItemStack itemRecordWard = new ItemStack(Items.field_151085_cm);
    ItemStack itemRecordChirp = new ItemStack(Items.field_151091_cg);
    ItemStack itemRecord11 = new ItemStack(Items.field_151086_cn);
    ItemStack itemRecordWait = new ItemStack(Items.field_151084_co);
    ItemStack itemRecordBlocks = new ItemStack(Items.field_151094_cf);
    ItemStack bars = new ItemStack(Blocks.field_150411_aY);
    ItemStack blockThinGlass = new ItemStack(Blocks.field_150410_aZ);
    ItemStack blockIron = new ItemStack(Blocks.field_150339_S);
    ItemStack itemRedstone = new ItemStack(Items.field_151137_ax);
    ItemStack minechemItemsAtomicManipulator = new ItemStack((Item)ModItems.atomicManipulator);
    private static final int INGOT_AMOUNT = 144;
    private static final int BUCKET_AMOUNT = 1000;

    public static ModRecipes getInstance() {
        return recipes;
    }

    public static void registerRecipes() {
        ModRecipes.getInstance().registerMinecraftRecipes();
        ModRecipes.getInstance().registerDecomposerRecipes();
        ModRecipes.getInstance().registerFluidRecipes();
        ModRecipes.getInstance().registerOreDictRecipes();
    }

    public void registerMinecraftRecipes() {
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("minechem", "concave_lens"), null, (ItemStack)ModItems.concaveLens, (Object[])new Object[]{"G G", "GGG", "G G", Character.valueOf('G'), this.blockGlass});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("minechem", "convex_lens"), null, (ItemStack)ModItems.convexLens, (Object[])new Object[]{" G ", "GGG", " G ", Character.valueOf('G'), this.blockGlass});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("minechem", "microscope_lens"), null, (ItemStack)ModItems.microscopeLens, (Object[])new Object[]{"A", "B", "A", Character.valueOf('A'), ModItems.convexLens, Character.valueOf('B'), ModItems.concaveLens});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("minechem", "microscope"), null, (ItemStack)new ItemStack(ModBlocks.microscope), (Object[])new Object[]{" LI", " PI", "III", Character.valueOf('L'), ModItems.microscopeLens, Character.valueOf('P'), this.blockThinGlass, Character.valueOf('I'), this.itemIngotIron});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("minechem", "atomic_manipulator"), null, (ItemStack)new ItemStack((Item)ModItems.atomicManipulator), (Object[])new Object[]{"PPP", "PIP", "PPP", Character.valueOf('P'), new ItemStack((Block)Blocks.field_150331_J), Character.valueOf('I'), this.blockIron});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("minechem", "decomposer"), null, (ItemStack)new ItemStack(ModBlocks.decomposer), (Object[])new Object[]{"III", "IAI", "IRI", Character.valueOf('A'), this.minechemItemsAtomicManipulator, Character.valueOf('I'), this.itemIngotIron, Character.valueOf('R'), this.itemRedstone});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("minechem", "synthesis"), null, (ItemStack)new ItemStack(ModBlocks.synthesis), (Object[])new Object[]{"IRI", "IAI", "IDI", Character.valueOf('A'), this.minechemItemsAtomicManipulator, Character.valueOf('I'), this.itemIngotIron, Character.valueOf('R'), this.itemRedstone, Character.valueOf('D'), new ItemStack(Items.field_151045_i)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("minechem", "fusion_1"), null, (ItemStack)new ItemStack(ModBlocks.reactor_wall, 16), (Object[])new Object[]{"ILI", "ILI", "ILI", Character.valueOf('I'), this.itemIngotIron, Character.valueOf('L'), ItemElement.createStackOf(ElementEnum.Pb, 1)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("minechem", "fusion_2"), null, (ItemStack)new ItemStack(ModBlocks.tungsten_plating, 16), (Object[])new Object[]{"IWI", "IBI", "IWI", Character.valueOf('I'), this.itemIngotIron, Character.valueOf('W'), ItemElement.createStackOf(ElementEnum.W, 1), Character.valueOf('B'), ItemElement.createStackOf(ElementEnum.Be, 1)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("minechem", "fusion_3"), null, (ItemStack)new ItemStack(ModBlocks.reactor_core), (Object[])new Object[]{"III", "IBI", "III", Character.valueOf('I'), this.itemIngotIron, Character.valueOf('B'), ItemElement.createStackOf(ElementEnum.U, 1)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("minechem", "projector_lens"), null, (ItemStack)ModItems.projectorLens, (Object[])new Object[]{"ABA", Character.valueOf('A'), ModItems.concaveLens, Character.valueOf('B'), ModItems.convexLens});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("minechem", "blueprint_projector"), null, (ItemStack)new ItemStack(ModBlocks.blueprintProjector), (Object[])new Object[]{" I ", "GPL", " I ", Character.valueOf('I'), this.itemIngotIron, Character.valueOf('P'), this.blockThinGlass, Character.valueOf('L'), ModItems.projectorLens, Character.valueOf('G'), new ItemStack(Blocks.field_150379_bu)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("minechem", "leaded_chest"), null, (ItemStack)new ItemStack(ModBlocks.leadChest), (Object[])new Object[]{"LLL", "LCL", "LLL", Character.valueOf('L'), new ItemStack((Item)ModItems.element, 1, ElementEnum.Pb.atomicNumber()), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae)});
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("minechem", "journal"), null, (ItemStack)new ItemStack((Item)ModItems.journal), (Ingredient[])new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151122_aG), Ingredient.func_193367_a((Item)Item.func_150898_a((Block)Blocks.field_150359_w))});
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("minechem", "blueprint_fusion"), null, (ItemStack)BlueprintUtil.createStack(ModBlueprints.fusion), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151121_aF), new ItemStack(Blocks.field_150484_ah)})});
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("minechem", "blueprint_fission"), null, (ItemStack)BlueprintUtil.createStack(ModBlueprints.fission), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151121_aF), new ItemStack(Items.field_151045_i)})});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("minechem", "empty_tube"), null, (ItemStack)ModItems.emptyTube, (Object[])new Object[]{"   ", "P P", " P ", Character.valueOf('P'), this.blockThinGlass});
    }

    public void registerFluidRecipes() {
        int threeQuarterFluidPerIngot = 180;
        RecipeDecomposer.add(new RecipeDecomposerFluid(new FluidStack(FluidRegistry.WATER, 1000), ModRecipes.element(ElementEnum.H, 2), ModRecipes.element(ElementEnum.O)));
        RecipeDecomposer.add(new RecipeDecomposerFluidSelect("lava", 250, 0.2f, new RecipeDecomposer(ModRecipes.element(ElementEnum.Si), ModRecipes.element(ElementEnum.O)), new RecipeDecomposer(ModRecipes.element(ElementEnum.Fe), ModRecipes.element(ElementEnum.O)), new RecipeDecomposer(ModRecipes.element(ElementEnum.Mg), ModRecipes.element(ElementEnum.O)), new RecipeDecomposer(ModRecipes.element(ElementEnum.Ti), ModRecipes.element(ElementEnum.O)), new RecipeDecomposer(ModRecipes.element(ElementEnum.Pb), ModRecipes.element(ElementEnum.O)), new RecipeDecomposer(ModRecipes.element(ElementEnum.Na), ModRecipes.element(ElementEnum.Cl))));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("water", 1000, ModRecipes.element(ElementEnum.H, 2), ModRecipes.element(ElementEnum.O));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("iron.molten", 144, ModRecipes.element(ElementEnum.Fe, 16));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("gold.molten", 144, ModRecipes.element(ElementEnum.Au, 16));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("copper.molten", 144, ModRecipes.element(ElementEnum.Cu, 16));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("tin.molten", 144, ModRecipes.element(ElementEnum.Sn, 16));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("aluminum.molten", 144, ModRecipes.element(ElementEnum.Al, 16));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("cobalt.molten", 144, ModRecipes.element(ElementEnum.Co, 16));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("ardite.molten", 144, ModRecipes.element(ElementEnum.Fe, 2), ModRecipes.element(ElementEnum.W, 2), ModRecipes.element(ElementEnum.Si, 2));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("bronze.molten", 144, ModRecipes.element(ElementEnum.Cu, 12), ModRecipes.element(ElementEnum.Sn, 4));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("aluminumbrass.molten", 144, ModRecipes.element(ElementEnum.Cu, 12), ModRecipes.element(ElementEnum.Al, 4));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("manyullyn.molten", 144, ModRecipes.element(ElementEnum.Co, 8), ModRecipes.element(ElementEnum.Fe, 1), ModRecipes.element(ElementEnum.W, 1), ModRecipes.element(ElementEnum.Si, 1));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("alumite.molten", 144, ModRecipes.element(ElementEnum.Al, 8), ModRecipes.element(ElementEnum.Fe, 3), ModRecipes.molecule(MoleculeEnum.siliconDioxide, 2), ModRecipes.molecule(MoleculeEnum.magnesiumOxide, 1));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("obsidian.molten", 144, ModRecipes.molecule(MoleculeEnum.siliconDioxide, 16), ModRecipes.molecule(MoleculeEnum.magnesiumOxide, 8));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("steel.molten", 144, ModRecipes.element(ElementEnum.Fe, 16), ModRecipes.element(ElementEnum.C, 1));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("stone.seared", 144, ModRecipes.molecule(MoleculeEnum.siliconOxide, 12), ModRecipes.molecule(MoleculeEnum.ironOxide, 4));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("glass.molten", 144, ModRecipes.molecule(MoleculeEnum.siliconDioxide, 16));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("emerald.molten", 144, ModRecipes.molecule(MoleculeEnum.beryl, 6), ModRecipes.element(ElementEnum.Cr, 6), ModRecipes.element(ElementEnum.V, 6));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("blood.molten", 144, ModRecipes.element(ElementEnum.O, 6), ModRecipes.element(ElementEnum.Fe, 2), ModRecipes.molecule(MoleculeEnum.ironOxide, 8));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("nickel.molten", 144, ModRecipes.element(ElementEnum.Ni, 16));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("lead.molten", 144, ModRecipes.element(ElementEnum.Pb, 16));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("silver.molten", 144, ModRecipes.element(ElementEnum.Ag, 16));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("platinum.molten", 144, ModRecipes.element(ElementEnum.Pt, 16));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("invar.molten", 144, ModRecipes.element(ElementEnum.Fe, 10), ModRecipes.element(ElementEnum.Ni, 6));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("electrum.molten", 144, ModRecipes.element(ElementEnum.Ag, 8), ModRecipes.element(ElementEnum.Au, 8));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("ender", threeQuarterFluidPerIngot, ModRecipes.molecule(MoleculeEnum.calciumCarbonate), ModRecipes.molecule(MoleculeEnum.calciumCarbonate), ModRecipes.molecule(MoleculeEnum.calciumCarbonate), ModRecipes.molecule(MoleculeEnum.calciumCarbonate), ModRecipes.element(ElementEnum.Es), ModRecipes.molecule(MoleculeEnum.calciumCarbonate), ModRecipes.molecule(MoleculeEnum.calciumCarbonate), ModRecipes.molecule(MoleculeEnum.calciumCarbonate), ModRecipes.molecule(MoleculeEnum.calciumCarbonate));
        if (ModConfig.decomposeChemicalFluids) {
            for (ElementEnum element : ModFluids.FLUID_ELEMENTS.keySet()) {
                RecipeDecomposerFluid.add(new RecipeDecomposerFluid(new FluidStack((Fluid)ModFluids.FLUID_ELEMENTS.get(element), 125), new Element(element, 1)));
            }
            for (MoleculeEnum molecule : ModFluids.FLUID_MOLECULES.keySet()) {
                RecipeDecomposerFluid.add(new RecipeDecomposerFluid(new FluidStack(ModFluids.FLUID_MOLECULES.get(molecule), 125), molecule.componentsArray()));
            }
        }
        this.registerMFRFluidRecipes();
    }

    private void registerMFRFluidRecipes() {
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("mushroomsoup", 1000, ModRecipes.molecule(MoleculeEnum.water, 4), ModRecipes.molecule(MoleculeEnum.pantherine, 2));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("chocolatemilk", 1000, ModRecipes.element(ElementEnum.Ca, 4), ModRecipes.molecule(MoleculeEnum.theobromine, 1));
        RecipeDecomposerFluid.createAndAddFluidRecipeSafely("milk", 1000, ModRecipes.element(ElementEnum.Ca, 4), ModRecipes.molecule(MoleculeEnum.oleicAcid, 1));
    }

    public static void registerSynthesisRecipes() {
        ModRecipes.getInstance().registerSynthesisMachineRecipes();
    }

    private void registerSynthesisMachineRecipes() {
        RecipeHandlerSynthesis.addShapedRecipe("smooth_stone", COST_SMOOTH, new ItemStack(Blocks.field_150348_b, 16), "ab ", "cd ", Character.valueOf('a'), ModRecipes.element(ElementEnum.Si), Character.valueOf('b'), ModRecipes.element(ElementEnum.O, 2), Character.valueOf('c'), ModRecipes.element(ElementEnum.Al, 2), Character.valueOf('d'), ModRecipes.element(ElementEnum.O, 3));
        RecipeHandlerSynthesis.addShapedRecipe("grass_block", COST_GLASS, new ItemStack((Block)Blocks.field_150349_c, 16), " a ", " bc", Character.valueOf('a'), this.moleculeCellulose, Character.valueOf('b'), ModRecipes.element(ElementEnum.O, 2), Character.valueOf('c'), ModRecipes.element(ElementEnum.Si));
        RecipeHandlerSynthesis.addShapedRecipe("dirt", COST_BLOCK, new ItemStack(Blocks.field_150346_d, 1, 0), "a  ", "   ", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.siliconDioxide));
        RecipeHandlerSynthesis.addShapedRecipe("podzol", COST_BLOCK, new ItemStack(Blocks.field_150346_d, 1, 2), "   ", "a  ", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.siliconDioxide));
        RecipeHandlerSynthesis.addShapedRecipe("cobblestone", COST_SMOOTH, new ItemStack(Blocks.field_150347_e, 16), "ab ", Character.valueOf('a'), ModRecipes.element(ElementEnum.Si, 2), Character.valueOf('b'), ModRecipes.element(ElementEnum.O, 4));
        RecipeHandlerSynthesis.addShapedRecipe("oak_planks", COST_PLANK, this.blockOakWoodPlanks, "   ", "   ", " aa", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("spruce_planks", COST_PLANK, this.blockSpruceWoodPlanks, "   ", "   ", "aa ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("birch_planks", COST_PLANK, this.blockBirchWoodPlanks, "   ", "  a", "a  ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("jungle_planks", COST_PLANK, this.blockJungleWoodPlanks, "   ", " aa", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("acacia_planks", COST_PLANK, this.blockAcaciaWoodPlanks, "   ", "aa ", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("dark_oak_planks", COST_PLANK, this.blockDarkOakWoodPlanks, "  a", "a  ", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("oak_slab", COST_PLANK, this.blockOakWoodSlabs, "   ", "   ", "a a", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("spruce_slab", COST_PLANK, this.blockSpruceWoodSlabs, "   ", "  a", " a ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("birch_slab", COST_PLANK, this.blockBirchWoodSlabs, "   ", " a ", "a  ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("jungle_slab", COST_PLANK, this.blockJungleWoodSlabs, "   ", "a a", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("acacia_slab", COST_PLANK, this.blockAcaciaWoodSlabs, "  a", " a ", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("dark_oak_slab", COST_PLANK, this.blockDarkOakWoodSlabs, " a ", "a  ", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("oak_sapling", COST_PLANT, this.blockOakSapling, "   ", "   ", "  a", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("spruce_sapling", COST_PLANT, this.blockSpruceSapling, "   ", "   ", " a ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("birch_sapling", COST_PLANT, this.blockBirchSapling, "   ", "   ", "a  ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("jungle_sapling", COST_PLANT, this.blockJungleSapling, "   ", "  a", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("acacia_sapling", COST_PLANT, this.blockAcaciaSapling, "   ", " a ", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("dark_oak_sapling", COST_PLANT, this.blockDarkOakSapling, "   ", "a  ", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("block_sand", COST_BLOCK, this.blockSand, "aaa", Character.valueOf('a'), this.moleculeSiliconDioxide);
        RecipeHandlerSynthesis.addShapedRecipe("block_gravel", COST_BLOCK, this.blockGravel, "   ", "   ", "  a", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.siliconDioxide));
        RecipeHandlerSynthesis.addShapedRecipe("oak_log", COST_WOOD, this.blockOakLog, "aaa", " a ", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose, 2));
        RecipeHandlerSynthesis.addShapedRecipe("spruce_log", COST_WOOD, this.blockSpruceLog, "   ", " a ", "aaa", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose, 2));
        RecipeHandlerSynthesis.addShapedRecipe("birch_log", COST_WOOD, this.blockBirchLog, "a a", "   ", "a a", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose, 2));
        RecipeHandlerSynthesis.addShapedRecipe("jungle_log", COST_WOOD, this.blockJungleLog, "a  ", "aa ", "a  ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose, 2));
        RecipeHandlerSynthesis.addShapedRecipe("acacia_log", COST_WOOD, this.blockAcaciaLog, "  a", " aa", "  a", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose, 2));
        RecipeHandlerSynthesis.addShapedRecipe("dark_oak_log", COST_WOOD, this.blockDarkOakLog, " a ", "a a", " a ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose, 2));
        RecipeHandlerSynthesis.addShapedRecipe("oak_leaves", COST_BLOCK, this.blockOakLeaves, "aaa", " a ", "   ", Character.valueOf('a'), this.moleculeCellulose);
        RecipeHandlerSynthesis.addShapedRecipe("spruce_leaves", COST_BLOCK, this.blockSpruceLeaves, "   ", " a ", "aaa", Character.valueOf('a'), this.moleculeCellulose);
        RecipeHandlerSynthesis.addShapedRecipe("birch_leaves", COST_BLOCK, this.blockOakLeaves, "a a", "   ", "a a", Character.valueOf('a'), this.moleculeCellulose);
        RecipeHandlerSynthesis.addShapedRecipe("jungle_leaves", COST_BLOCK, this.blockJungleLeaves, "a  ", "aa ", "a  ", Character.valueOf('a'), this.moleculeCellulose);
        RecipeHandlerSynthesis.addShapedRecipe("acacia_leaves", COST_BLOCK, this.blockAcaciaLeaves, "  a", " aa", "  a", Character.valueOf('a'), this.moleculeCellulose);
        RecipeHandlerSynthesis.addShapedRecipe("dark_oak_leaves", COST_BLOCK, this.blockDarkOakLeaves, " a ", "a a", " a ", Character.valueOf('a'), this.moleculeCellulose);
        RecipeHandlerSynthesis.addShapelessRecipe("dye_black", COST_ITEM, this.itemDyePowderBlack, ModRecipes.molecule(MoleculeEnum.blackPigment));
        RecipeHandlerSynthesis.addShapelessRecipe("dye_red", COST_ITEM, this.itemDyePowderRed, ModRecipes.molecule(MoleculeEnum.redPigment));
        RecipeHandlerSynthesis.addShapelessRecipe("dye_green", COST_ITEM, this.itemDyePowderGreen, ModRecipes.molecule(MoleculeEnum.greenPigment));
        RecipeHandlerSynthesis.addShapelessRecipe("dye_brown", COST_ITEM, this.itemDyePowderBrown, ModRecipes.molecule(MoleculeEnum.theobromine));
        RecipeHandlerSynthesis.addShapelessRecipe("dye_blue", COST_ITEM, this.itemDyePowderBlue, ModRecipes.molecule(MoleculeEnum.lazurite));
        RecipeHandlerSynthesis.addShapelessRecipe("dye_purple", COST_ITEM, this.itemDyePowderPurple, ModRecipes.molecule(MoleculeEnum.purplePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("dye_cyan", COST_ITEM, this.itemDyePowderCyan, ModRecipes.molecule(MoleculeEnum.lightbluePigment), ModRecipes.molecule(MoleculeEnum.whitePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("dye_lightgray", COST_ITEM, this.itemDyePowderLightGray, ModRecipes.molecule(MoleculeEnum.whitePigment), ModRecipes.molecule(MoleculeEnum.blackPigment));
        RecipeHandlerSynthesis.addShapelessRecipe("dye_gray", COST_ITEM, this.itemDyePowderGray, ModRecipes.molecule(MoleculeEnum.whitePigment), ModRecipes.molecule(MoleculeEnum.blackPigment, 2));
        RecipeHandlerSynthesis.addShapelessRecipe("dye_pink", COST_ITEM, this.itemDyePowderPink, ModRecipes.molecule(MoleculeEnum.redPigment), ModRecipes.molecule(MoleculeEnum.whitePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("dye_lime", COST_ITEM, this.itemDyePowderLime, ModRecipes.molecule(MoleculeEnum.limePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("dye_yellow", COST_ITEM, this.itemDyePowderYellow, ModRecipes.molecule(MoleculeEnum.yellowPigment));
        RecipeHandlerSynthesis.addShapelessRecipe("dye_lightblue", COST_ITEM, this.itemDyePowderLightBlue, ModRecipes.molecule(MoleculeEnum.lightbluePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("dye_magenta", COST_ITEM, this.itemDyePowderMagenta, ModRecipes.molecule(MoleculeEnum.lightbluePigment), ModRecipes.molecule(MoleculeEnum.redPigment));
        RecipeHandlerSynthesis.addShapelessRecipe("dye_orange", COST_ITEM, this.itemDyePowderOrange, ModRecipes.molecule(MoleculeEnum.orangePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("dye_white", COST_ITEM, this.itemDyePowderWhite, ModRecipes.molecule(MoleculeEnum.whitePigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass", COST_GLASS, this.blockGlass, "a a", "   ", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide);
        RecipeHandlerSynthesis.addShapedRecipe("block_stained_glass_white", COST_GLASS, this.blockWhiteStainedGlass, "a a", " b ", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.whitePigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_stained_glass_orange", COST_GLASS, this.blockOrangeStainedGlass, "a a", " b ", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.orangePigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_stained_glass_magenta", COST_GLASS, this.blockMagentaStainedGlass, "a a", "b c", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.lightbluePigment), Character.valueOf('c'), ModRecipes.molecule(MoleculeEnum.redPigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_stained_glass_lightblue", COST_GLASS, this.blockLightBlueStainedGlass, "a a", " b ", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.lightbluePigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_stained_glass_yellow", COST_GLASS, this.blockYellowStainedGlass, "a a", " b ", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.yellowPigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_stained_glass_lime", COST_GLASS, this.blockLimeStainedGlass, "a a", " b ", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.limePigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_stained_glass_pink", COST_GLASS, this.blockPinkStainedGlass, "a a", "b c", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.whitePigment), Character.valueOf('c'), ModRecipes.molecule(MoleculeEnum.redPigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_stained_glass_gray", COST_GLASS, this.blockGrayStainedGlass, "a a", "b c", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.whitePigment), Character.valueOf('c'), ModRecipes.molecule(MoleculeEnum.blackPigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_stained_glass_lightgray", COST_GLASS, this.blockLightGrayStainedGlass, "a a", "bbc", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.whitePigment), Character.valueOf('c'), ModRecipes.molecule(MoleculeEnum.blackPigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_stained_glass_cyan", COST_GLASS, this.blockCyanStainedGlass, "a a", "b c", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.whitePigment), Character.valueOf('c'), ModRecipes.molecule(MoleculeEnum.lightbluePigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_stained_glass_purple", COST_GLASS, this.blockPurpleStainedGlass, "a a", " b ", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.purplePigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_stained_glass_blue", COST_GLASS, this.blockBlueStainedGlass, "a a", " b ", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.lazurite));
        RecipeHandlerSynthesis.addShapedRecipe("block_stained_glass_brown", COST_GLASS, this.blockBrownStainedGlass, "a a", " b ", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.tannicacid));
        RecipeHandlerSynthesis.addShapedRecipe("block_stained_glass_green", COST_GLASS, this.blockGreenStainedGlass, "a a", " b ", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.greenPigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_stained_glass_red", COST_GLASS, this.blockRedStainedGlass, "a a", " b ", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.redPigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_stained_glass_black", COST_GLASS, this.blockBlackStainedGlass, "a a", " b ", "a a", Character.valueOf('a'), this.moleculeSiliconDioxide, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.blackPigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane", COST_PANE, this.blockGlassPane, "aaa", "   ", "aaa", Character.valueOf('a'), this.siO);
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane_white", COST_PANE, this.blockWhiteStainedGlassPane, "aaa", " b ", "aaa", Character.valueOf('a'), this.siO, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.whitePigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane_orange", COST_PANE, this.blockOrangeStainedGlassPane, "aaa", " b ", "aaa", Character.valueOf('a'), this.siO, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.orangePigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane_magenta", COST_PANE, this.blockMagentaStainedGlassPane, "aaa", "b c", "aaa", Character.valueOf('a'), this.siO, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.lightbluePigment), Character.valueOf('c'), ModRecipes.molecule(MoleculeEnum.redPigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane_lightblue", COST_PANE, this.blockLightBlueStainedGlassPane, "aaa", " b ", "aaa", Character.valueOf('a'), this.siO, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.lightbluePigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane_yellow", COST_PANE, this.blockYellowStainedGlassPane, "aaa", " b ", "aaa", Character.valueOf('a'), this.siO, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.yellowPigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane_lime", COST_PANE, this.blockLimeStainedGlassPane, "aaa", " b ", "aaa", Character.valueOf('a'), this.siO, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.limePigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane_pink", COST_PANE, this.blockPinkStainedGlassPane, "aaa", "b c", "aaa", Character.valueOf('a'), this.siO, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.whitePigment), Character.valueOf('c'), ModRecipes.molecule(MoleculeEnum.redPigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane_gray", COST_PANE, this.blockGrayStainedGlassPane, "aaa", "b c", "aaa", Character.valueOf('a'), this.siO, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.whitePigment), Character.valueOf('c'), ModRecipes.molecule(MoleculeEnum.blackPigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane_lightgray", COST_PANE, this.blockLightGrayStainedGlassPane, "aaa", "bbc", "aaa", Character.valueOf('a'), this.siO, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.whitePigment), Character.valueOf('c'), ModRecipes.molecule(MoleculeEnum.blackPigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane_cyan", COST_PANE, this.blockCyanStainedGlassPane, "aaa", "b c", "aaa", Character.valueOf('a'), this.siO, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.whitePigment), Character.valueOf('c'), ModRecipes.molecule(MoleculeEnum.lightbluePigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane_purple", COST_PANE, this.blockPurpleStainedGlassPane, "aaa", " b ", "aaa", Character.valueOf('a'), this.siO, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.purplePigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane_blue", COST_PANE, this.blockBlueStainedGlassPane, "aaa", " b ", "aaa", Character.valueOf('a'), this.siO, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.lazurite));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane_brown", COST_PANE, this.blockBrownStainedGlassPane, "aaa", " b ", "aaa", Character.valueOf('a'), this.siO, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.tannicacid));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane_green", COST_PANE, this.blockGreenStainedGlassPane, "aaa", " b ", "aaa", Character.valueOf('a'), this.siO, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.greenPigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane_red", COST_PANE, this.blockRedStainedGlassPane, "aaa", " b ", "aaa", Character.valueOf('a'), this.siO, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.redPigment));
        RecipeHandlerSynthesis.addShapedRecipe("block_glass_pane_black", COST_PANE, this.blockBlackStainedGlassPane, "aaa", " b ", "aaa", Character.valueOf('a'), this.siO, Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.blackPigment));
        RecipeHandlerSynthesis.addShapedRecipe("lapis_block", COST_LAPISBLOCK, this.blockLapis, "a  ", "   ", "   ", Character.valueOf('a'), this.moleculeLazurite);
        RecipeHandlerSynthesis.addShapedRecipe("sunflower", COST_PLANT, this.blockSunFlower, "a", "b", Character.valueOf('a'), new Molecule(MoleculeEnum.shikimicAcid, 2), Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.yellowPigment));
        RecipeHandlerSynthesis.addShapedRecipe("lilac", COST_PLANT, this.blockLilac, "abc", Character.valueOf('a'), new Molecule(MoleculeEnum.shikimicAcid, 2), Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.redPigment), Character.valueOf('c'), new Molecule(MoleculeEnum.whitePigment, 2));
        RecipeHandlerSynthesis.addShapedRecipe("tall_grass", COST_PLANT, this.blockTallGrass, "a  ", "   ", "   ", Character.valueOf('a'), new Molecule(MoleculeEnum.shikimicAcid, 2));
        RecipeHandlerSynthesis.addShapedRecipe("large_fern", COST_PLANT, this.blockLargeFern, " a ", Character.valueOf('a'), new Molecule(MoleculeEnum.shikimicAcid, 2));
        RecipeHandlerSynthesis.addShapedRecipe("rose_bush", COST_PLANT, this.blockRoseBush, "ab ", Character.valueOf('a'), new Molecule(MoleculeEnum.shikimicAcid, 2), Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.redPigment));
        RecipeHandlerSynthesis.addShapedRecipe("peony", COST_PLANT, this.blockPeony, "abc", Character.valueOf('a'), new Molecule(MoleculeEnum.shikimicAcid, 2), Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.redPigment), Character.valueOf('c'), ModRecipes.molecule(MoleculeEnum.whitePigment));
        RecipeHandlerSynthesis.addShapedRecipe("sandstone", COST_PLANT, this.blockSandStone, "   ", " a ", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.siliconDioxide, 16));
        RecipeHandlerSynthesis.addShapedRecipe("chiseled_sandstone", COST_PLANT, this.blockChiseledSandStone, "   ", "   ", " a ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.siliconDioxide, 16));
        RecipeHandlerSynthesis.addShapedRecipe("smooth_sandstone", COST_PLANT, this.blockSmoothSandStone, " a ", "   ", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.siliconDioxide, 16));
        RecipeHandlerSynthesis.addShapelessRecipe("wool", COST_WOOL, this.blockWool, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.whitePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("wool_orange", COST_WOOL, this.blockOrangeWool, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.orangePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("wool_magenta", COST_WOOL, this.blockMagentaWool, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.lightbluePigment), ModRecipes.molecule(MoleculeEnum.redPigment));
        RecipeHandlerSynthesis.addShapelessRecipe("wool_lightblue", COST_WOOL, this.blockLightBlueWool, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.lightbluePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("wool_yellow", COST_WOOL, this.blockYellowWool, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.yellowPigment));
        RecipeHandlerSynthesis.addShapelessRecipe("wool_lime", COST_WOOL, this.blockLimeWool, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.limePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("wool_pink", COST_WOOL, this.blockPinkWool, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.redPigment), ModRecipes.molecule(MoleculeEnum.whitePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("wool_gray", COST_WOOL, this.blockGrayWool, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.whitePigment), ModRecipes.molecule(MoleculeEnum.blackPigment, 2));
        RecipeHandlerSynthesis.addShapelessRecipe("wool_lightgray", COST_WOOL, this.blockLightGrayWool, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.whitePigment), ModRecipes.molecule(MoleculeEnum.blackPigment));
        RecipeHandlerSynthesis.addShapelessRecipe("wool_cyan", COST_WOOL, this.blockCyanWool, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.lightbluePigment), ModRecipes.molecule(MoleculeEnum.whitePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("wool_purple", COST_WOOL, this.blockPurpleWool, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.purplePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("wool_blue", COST_WOOL, this.blockBlueWool, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.lazurite));
        RecipeHandlerSynthesis.addShapelessRecipe("wool_green", COST_WOOL, this.blockGreenWool, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.greenPigment));
        RecipeHandlerSynthesis.addShapelessRecipe("wool_red", COST_WOOL, this.blockRedWool, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.redPigment));
        RecipeHandlerSynthesis.addShapelessRecipe("wool_black", COST_WOOL, this.blockBlackWool, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.blackPigment));
        RecipeHandlerSynthesis.addShapelessRecipe("carpet", COST_CARPET, this.carpetBlockWool, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.whitePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("carpet_orange", COST_CARPET, this.carpetBlockOrangeWool, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.orangePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("carpet_magenta", COST_CARPET, this.carpetBlockMagentaWool, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.lightbluePigment), ModRecipes.molecule(MoleculeEnum.redPigment));
        RecipeHandlerSynthesis.addShapelessRecipe("carpet_lightblue", COST_CARPET, this.carpetBlockLightBlueWool, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.lightbluePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("carpet_yellow", COST_CARPET, this.carpetBlockYellowWool, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.yellowPigment));
        RecipeHandlerSynthesis.addShapelessRecipe("carpet_lime", COST_CARPET, this.carpetBlockLimeWool, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.limePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("carpet_pink", COST_CARPET, this.carpetBlockPinkWool, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.redPigment), ModRecipes.molecule(MoleculeEnum.whitePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("carpet_gray", COST_CARPET, this.carpetBlockGrayWool, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.whitePigment), ModRecipes.molecule(MoleculeEnum.blackPigment, 2));
        RecipeHandlerSynthesis.addShapelessRecipe("carpet_lightgray", COST_CARPET, this.carpetBlockLightGrayWool, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.whitePigment), ModRecipes.molecule(MoleculeEnum.blackPigment));
        RecipeHandlerSynthesis.addShapelessRecipe("carpet_cyan", COST_CARPET, this.carpetBlockCyanWool, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.lightbluePigment), ModRecipes.molecule(MoleculeEnum.whitePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("carpet_purple", COST_CARPET, this.carpetBlockPurpleWool, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.purplePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("carpet_blue", COST_CARPET, this.carpetBlockBlueWool, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.lazurite));
        RecipeHandlerSynthesis.addShapelessRecipe("carpet_green", COST_CARPET, this.carpetBlockGreenWool, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.greenPigment));
        RecipeHandlerSynthesis.addShapelessRecipe("carpet_red", COST_CARPET, this.carpetBlockRedWool, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.orangePigment));
        RecipeHandlerSynthesis.addShapelessRecipe("carpet_black", COST_CARPET, this.carpetBlockBlackWool, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.blackPigment));
        RecipeHandlerSynthesis.addShapedRecipe("gold_block", COST_METALBLOCK, new ItemStack(Blocks.field_150340_R), "aaa", "aaa", "aaa", Character.valueOf('a'), ModRecipes.element(ElementEnum.Au, 16));
        RecipeHandlerSynthesis.addShapedRecipe("iron_block", COST_METALBLOCK, new ItemStack(Blocks.field_150339_S), "aaa", "aaa", "aaa", Character.valueOf('a'), ModRecipes.element(ElementEnum.Fe, 16));
        RecipeHandlerSynthesis.addShapelessRecipe("tnt", COST_OBSIDIAN, this.blockTnt, ModRecipes.molecule(MoleculeEnum.tnt));
        RecipeHandlerSynthesis.addShapedRecipe("obsidian", COST_OBSIDIAN, new ItemStack(Blocks.field_150340_R), "aaa", "b a", "bbb", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.siliconDioxide, 4), Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.magnesiumOxide, 2));
        RecipeHandlerSynthesis.addShapedRecipe("diamond_block", COST_GEMBLOCK, this.blockDiamond, "aaa", "aaa", "aaa", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.fullrene, 3));
        RecipeHandlerSynthesis.addShapedRecipe("cactus_black", COST_PLANT, this.blockCactus, "a a", " b ", "a a", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.water, 5), Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.mescaline));
        RecipeHandlerSynthesis.addShapelessRecipe("block_pumpkin", COST_PLANT, this.blockPumpkin, ModRecipes.molecule(MoleculeEnum.cucurbitacin, 4));
        RecipeHandlerSynthesis.addShapelessRecipe("seed_pumpkin", COST_PLANT, this.pumpkinSeed, ModRecipes.molecule(MoleculeEnum.cucurbitacin));
        RecipeHandlerSynthesis.addShapedRecipe("nether_brick", COST_SMOOTH, this.itemNetherbrick, "aa ", "bc ", "dd ", Character.valueOf('a'), ModRecipes.element(ElementEnum.Si, 2), Character.valueOf('b'), ModRecipes.element(ElementEnum.Zn, 2), Character.valueOf('c'), ModRecipes.element(ElementEnum.W, 1), Character.valueOf('d'), ModRecipes.element(ElementEnum.Be, 2));
        RecipeHandlerSynthesis.addShapedRecipe("water_bottle", COST_ITEM, this.itemPotion, " a ", "aba", " a ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.siliconDioxide, 4), Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.water, 5));
        RecipeHandlerSynthesis.addShapedRecipe("glowstone_block", COST_GLOWBLOCK, this.blockGlowStone, "aa", "aa", Character.valueOf('a'), ModRecipes.element(ElementEnum.P));
        RecipeHandlerSynthesis.addShapelessRecipe("block_mycelium", COST_GRASS, new ItemStack((Block)Blocks.field_150391_bh, 16), ModRecipes.molecule(MoleculeEnum.fingolimod));
        RecipeHandlerSynthesis.addShapedRecipe("emerald_block", COST_GEMBLOCK, this.blockEmerald, "aaa", "bcb", "aaa", Character.valueOf('a'), ModRecipes.element(ElementEnum.Cr, 3), Character.valueOf('b'), ModRecipes.element(ElementEnum.V, 9), Character.valueOf('c'), ModRecipes.molecule(MoleculeEnum.beryl, 18));
        RecipeHandlerSynthesis.addShapelessRecipe("apple", COST_FOOD, this.itemAppleRed, ModRecipes.molecule(MoleculeEnum.malicAcid), ModRecipes.molecule(MoleculeEnum.water, 2));
        RecipeHandlerSynthesis.addShapelessRecipe("charcoal", COST_ITEM, this.itemChar, ModRecipes.element(ElementEnum.C, 4), ModRecipes.element(ElementEnum.C, 4));
        RecipeHandlerSynthesis.addShapedRecipe("diamond", COST_GEM, this.itemDiamond, "   ", " a ", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.fullrene, 3));
        RecipeHandlerSynthesis.addShapedRecipe("polytool", COST_STAR, new ItemStack(ModItems.polytool), " a ", "a a", " a ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.fullrene, 64));
        RecipeHandlerSynthesis.addShapelessRecipe("ingot_iron", COST_INGOT, this.itemIngotIron, ModRecipes.element(ElementEnum.Fe, 16));
        RecipeHandlerSynthesis.addShapelessRecipe("ingot_gold", COST_INGOT, this.itemIngotGold, ModRecipes.element(ElementEnum.Au, 16));
        RecipeHandlerSynthesis.addShapedRecipe("string", COST_ITEM, this.itemString, "abc", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.serine), Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.glycine), Character.valueOf('c'), ModRecipes.molecule(MoleculeEnum.alinine));
        RecipeHandlerSynthesis.addShapedRecipe("feather", COST_ITEM, this.itemFeather, "aba", "aca", "ada", Character.valueOf('a'), ModRecipes.element(ElementEnum.N), Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.water, 2), Character.valueOf('c'), ModRecipes.molecule(MoleculeEnum.water, 1), Character.valueOf('d'), ModRecipes.molecule(MoleculeEnum.water, 5));
        RecipeHandlerSynthesis.addShapedRecipe("gun_powder", COST_ITEM, this.itemGunpowder, "ab ", "c  ", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.potassiumNitrate), Character.valueOf('b'), ModRecipes.element(ElementEnum.C), Character.valueOf('c'), ModRecipes.element(ElementEnum.S, 2));
        RecipeHandlerSynthesis.addShapedRecipe("flint", COST_ITEM, this.itemFlint, " a ", "aaa", Character.valueOf('a'), this.moleculeSiliconDioxide);
        RecipeHandlerSynthesis.addShapedRecipe("bucket", COST_FOOD, this.itemBucket, "a a", " a ", Character.valueOf('a'), ModRecipes.element(ElementEnum.Fe, 16));
        RecipeHandlerSynthesis.addShapedRecipe("water_bucket", COST_FOOD, this.itemBucketWater, "aba", " a ", Character.valueOf('a'), ModRecipes.element(ElementEnum.Fe, 16), Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.water, 16));
        RecipeHandlerSynthesis.addShapedRecipe("redstone_dust", COST_LAPIS, this.itemRedstoneDust, "  a", " b ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.iron3oxide), Character.valueOf('b'), ModRecipes.element(ElementEnum.Cu));
        RecipeHandlerSynthesis.addShapedRecipe("redstone_block", COST_LAPISBLOCK, this.blockRedstone, "  a", " b ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.iron3oxide, 9), Character.valueOf('b'), ModRecipes.element(ElementEnum.Cu, 9));
        RecipeHandlerSynthesis.addShapedRecipe("snowball", COST_FOOD, new ItemStack(Items.field_151126_ay, 5), "a a", " a ", "a a", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.water));
        RecipeHandlerSynthesis.addShapedRecipe("leather", COST_ITEM, new ItemStack(Items.field_151116_aA, 5), "   ", " a ", "   ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.keratin));
        RecipeHandlerSynthesis.addShapedRecipe("brick", COST_ITEM, new ItemStack(Items.field_151118_aC, 8), "aa ", "aa ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.kaolinite));
        RecipeHandlerSynthesis.addShapelessRecipe("item_clay", COST_ITEM, new ItemStack(Items.field_151119_aD, 2), ModRecipes.molecule(MoleculeEnum.kaolinite));
        RecipeHandlerSynthesis.addShapedRecipe("vine", COST_GRASS, this.itemVine, "a a", "a a", "a a", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapedRecipe("paper", COST_ITEM, new ItemStack(Items.field_151121_aF, 8), " a ", " a ", " a ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.cellulose));
        RecipeHandlerSynthesis.addShapelessRecipe("item_bone", COST_ITEM, this.itemBone, ModRecipes.molecule(MoleculeEnum.hydroxylapatite));
        RecipeHandlerSynthesis.addShapelessRecipe("item_sugar", COST_SUGAR, this.itemSugar, ModRecipes.molecule(MoleculeEnum.sucrose));
        RecipeHandlerSynthesis.addShapelessRecipe("item_melon", COST_FOOD, new ItemStack(Items.field_151127_ba), ModRecipes.molecule(MoleculeEnum.cucurbitacin), ModRecipes.molecule(MoleculeEnum.asparticAcid), ModRecipes.molecule(MoleculeEnum.water, 1));
        RecipeHandlerSynthesis.addShapelessRecipe("block_melon", COST_PLANT, this.itemSugar, ModRecipes.molecule(MoleculeEnum.cucurbitacin), ModRecipes.molecule(MoleculeEnum.asparticAcid), ModRecipes.molecule(MoleculeEnum.water, 16));
        RecipeHandlerSynthesis.addShapedRecipe("cooked_chicken", COST_FOOD, this.itemChickenCooked, "abc", Character.valueOf('a'), ModRecipes.element(ElementEnum.K, 16), Character.valueOf('b'), ModRecipes.element(ElementEnum.Na, 16), Character.valueOf('c'), ModRecipes.element(ElementEnum.C, 16));
        RecipeHandlerSynthesis.addShapedRecipe("ender_pearl", COST_TEAR, this.itemEnderPearl, "aaa", "aba", "aaa", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.calciumCarbonate), Character.valueOf('b'), ModRecipes.element(ElementEnum.Es));
        RecipeHandlerSynthesis.addShapedRecipe("dragon_egg", COST_BLOCK, this.blockEnderDragonEgg, "abc", " d ", Character.valueOf('a'), ModRecipes.molecule(MoleculeEnum.calciumCarbonate, 18), Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.hydroxylapatite, 8), Character.valueOf('c'), ModRecipes.element(ElementEnum.Pu, 22), Character.valueOf('d'), ModRecipes.element(ElementEnum.Fm, 12));
        RecipeHandlerSynthesis.addShapedRecipe("blaze_rod", COST_TEAR, this.itemBlazeRod, "a  ", "a  ", "a  ", Character.valueOf('a'), ModRecipes.element(ElementEnum.Pu, 2));
        RecipeHandlerSynthesis.addShapedRecipe("ghast_tear", COST_TEAR, this.itemGhastTear, "aab", " ab", " b ", Character.valueOf('a'), ModRecipes.element(ElementEnum.Yb), Character.valueOf('b'), ModRecipes.element(ElementEnum.No));
        RecipeHandlerSynthesis.addShapedRecipe("spider_eye", COST_ITEM, this.itemSpiderEye, "a  ", " b ", "  a", Character.valueOf('a'), ModRecipes.element(ElementEnum.C), Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.tetrodotoxin));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemFermentedSpiderEye, ModRecipes.element(ElementEnum.Po), ModRecipes.molecule(MoleculeEnum.ethanol)));
        RecipeHandlerSynthesis.addShapedRecipe("magma_cream", COST_TEAR, this.itemMagmaCream, " a ", "bcb", " b ", Character.valueOf('a'), ModRecipes.element(ElementEnum.Pu), Character.valueOf('b'), ModRecipes.molecule(MoleculeEnum.pmma), Character.valueOf('c'), ModRecipes.element(ElementEnum.Hg));
        RecipeHandlerSynthesis.addShapedRecipe("emerald", 5000, this.itemEmerald, " a ", "bcb", " a ", Character.valueOf('a'), ModRecipes.element(ElementEnum.Cr), Character.valueOf('b'), ModRecipes.element(ElementEnum.V), Character.valueOf('c'), ModRecipes.molecule(MoleculeEnum.beryl, 2));
        RecipeHandlerSynthesis.addShapedRecipe("nether_star", COST_STAR, this.itemNetherStar, "aaa", "bca", "ddd", Character.valueOf('a'), this.elementHelium, Character.valueOf('b'), this.elementCarbon, Character.valueOf('c'), ModRecipes.element(ElementEnum.Cn, 16), Character.valueOf('d'), this.elementHydrogen);
        RecipeHandlerSynthesis.addShapedRecipe("record_13", COST_GEM, this.itemRecord13, "aa ", "   ", "   ", Character.valueOf('a'), this.moleculePolyvinylChloride);
        RecipeHandlerSynthesis.addShapedRecipe("record_cat", COST_GEM, this.itemRecordCat, " aa", "   ", "   ", Character.valueOf('a'), this.moleculePolyvinylChloride);
        RecipeHandlerSynthesis.addShapedRecipe("record_far", COST_GEM, this.itemRecordFar, "  a", "a  ", "   ", Character.valueOf('a'), this.moleculePolyvinylChloride);
        RecipeHandlerSynthesis.addShapedRecipe("record_mall", COST_GEM, this.itemRecordMall, "   ", "aa ", "   ", Character.valueOf('a'), this.moleculePolyvinylChloride);
        RecipeHandlerSynthesis.addShapedRecipe("record_mellohi", COST_GEM, this.itemRecordMellohi, "   ", " aa", "   ", Character.valueOf('a'), this.moleculePolyvinylChloride);
        RecipeHandlerSynthesis.addShapedRecipe("record_stal", COST_GEM, this.itemRecordStal, "   ", "  a", "a  ", Character.valueOf('a'), this.moleculePolyvinylChloride);
        RecipeHandlerSynthesis.addShapedRecipe("record_strad", COST_GEM, this.itemRecordStrad, "   ", "   ", "aa ", Character.valueOf('a'), this.moleculePolyvinylChloride);
        RecipeHandlerSynthesis.addShapedRecipe("record_ward", COST_GEM, this.itemRecordWard, "   ", "   ", " aa", Character.valueOf('a'), this.moleculePolyvinylChloride);
        RecipeHandlerSynthesis.addShapedRecipe("record_chirp", COST_GEM, this.itemRecordChirp, "a  ", "   ", "  a", Character.valueOf('a'), this.moleculePolyvinylChloride);
        RecipeHandlerSynthesis.addShapedRecipe("record_11", COST_GEM, this.itemRecord11, "a  ", " a ", "   ", Character.valueOf('a'), this.moleculePolyvinylChloride);
        RecipeHandlerSynthesis.addShapedRecipe("record_wait", COST_GEM, this.itemRecordWait, "a  ", "a  ", "   ", Character.valueOf('a'), this.moleculePolyvinylChloride);
        RecipeHandlerSynthesis.addShapedRecipe("record_blocks", COST_GEM, this.itemRecordBlocks, "a  ", " a ", "   ", Character.valueOf('a'), this.moleculePolyvinylChloride);
        RecipeHandlerSynthesis.addShapelessOreDictRecipe("ingotIron", COST_INGOT, ModRecipes.element(ElementEnum.Fe, 16));
        RecipeHandlerSynthesis.addShapelessOreDictRecipe("ingotGold", COST_INGOT, ModRecipes.element(ElementEnum.Au, 16));
        RecipeHandlerSynthesis.addShapelessOreDictRecipe("ingotCopper", COST_INGOT, ModRecipes.element(ElementEnum.Cu, 16));
        RecipeHandlerSynthesis.addShapelessOreDictRecipe("ingotTin", COST_INGOT, ModRecipes.element(ElementEnum.Sn, 16));
        RecipeHandlerSynthesis.addShapelessOreDictRecipe("ingotSilver", COST_INGOT, ModRecipes.element(ElementEnum.Ag, 16));
        RecipeHandlerSynthesis.addShapelessOreDictRecipe("ingotLead", COST_INGOT, ModRecipes.element(ElementEnum.Pb, 16));
        RecipeHandlerSynthesis.addShapelessOreDictRecipe("ingotPlatinum", COST_INGOT, ModRecipes.element(ElementEnum.Pt, 16));
        RecipeHandlerSynthesis.addShapelessOreDictRecipe("ingotAluminium", COST_INGOT, ModRecipes.element(ElementEnum.Al, 16));
        RecipeHandlerSynthesis.addShapelessOreDictRecipe("ingotMagnesium", COST_INGOT, ModRecipes.element(ElementEnum.Mg, 16));
        RecipeHandlerSynthesis.addShapelessOreDictRecipe("ingotSteel", COST_INGOT, ModRecipes.element(ElementEnum.Fe, 15), ModRecipes.element(ElementEnum.C, 1));
        RecipeHandlerSynthesis.addShapelessOreDictRecipe("ingotHSLA", COST_INGOT, ModRecipes.element(ElementEnum.Fe, 15), ModRecipes.element(ElementEnum.C, 1));
        RecipeHandlerSynthesis.addShapelessOreDictRecipe("ingotBronze", COST_INGOT, ModRecipes.element(ElementEnum.Cu, 12), ModRecipes.element(ElementEnum.Sn, 4));
        RecipeHandlerSynthesis.addShapelessOreDictRecipe("ingotElectrum", COST_INGOT, ModRecipes.element(ElementEnum.Ag, 8), ModRecipes.element(ElementEnum.Au, 8));
        RecipeHandlerSynthesis.addShapelessOreDictRecipe("ingotInvar", COST_INGOT, ModRecipes.element(ElementEnum.Fe, 10), ModRecipes.element(ElementEnum.Ni, 6));
        RecipeHandlerSynthesis.addShapelessRecipe("block_ironbars", COST_BLOCK, this.bars, ModRecipes.element(ElementEnum.Fe, 3), ModRecipes.element(ElementEnum.Fe, 3));
        for (MoleculeEnum molecule : MoleculeEnum.molecules.values()) {
            if (molecule == null) continue;
            ItemStack moleculeItemStack = new ItemStack((Item)ModItems.molecule, 1, molecule.id());
            RecipeHandlerSynthesis.addShapelessRecipe("molecule_" + molecule.name().toLowerCase(Locale.US), COST_ITEM * molecule.components().size(), moleculeItemStack, molecule.components().toArray(new PotionChemical[molecule.components().size()]));
        }
    }

    public void registerDecomposerRecipes() {
        RecipeDecomposer.add(new RecipeDecomposerSelect(this.blockStone, 0.07f, Lists.newArrayList((Object[])new ArrayList[]{Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Fe), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Mg), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Ti), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Pb), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Zn), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Al), ModRecipes.element(ElementEnum.O)})})));
        RecipeDecomposer.add(new RecipeDecomposerSelect(this.blockGrass, 0.07f, Lists.newArrayList((Object[])new ArrayList[]{Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Fe), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Mg), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Ti), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Pb), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Zn), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{this.moleculeCellulose})})));
        RecipeDecomposer.add(new RecipeDecomposerSelect(this.blockDirt, 0.07f, Lists.newArrayList((Object[])new ArrayList[]{Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Fe), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Mg), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Ti), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Pb), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Zn), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Ga), ModRecipes.element(ElementEnum.O)})})));
        RecipeDecomposer.add(new RecipeDecomposerSelect(this.blockPodzol, 0.07f, Lists.newArrayList((Object[])new ArrayList[]{Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Fe), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Mg), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Ti), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Pb), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Zn), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Ga), ModRecipes.element(ElementEnum.O)})})));
        RecipeDecomposer.add(new RecipeDecomposerSelect(this.blockCobblestone, 0.07f, Lists.newArrayList((Object[])new ArrayList[]{Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Fe), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Mg), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Ti), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Pb), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Na), ModRecipes.element(ElementEnum.Cl)})})));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockOakWoodPlanks, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockSpruceWoodPlanks, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockBirchWoodPlanks, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockJungleWoodPlanks, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockAcaciaWoodPlanks, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockDarkOakWoodPlanks, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockOakWoodSlabs, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockSpruceWoodSlabs, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockBirchWoodSlabs, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockJungleWoodSlabs, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockAcaciaWoodSlabs, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockDarkOakWoodSlabs, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockOakSapling, 0.25f, ModRecipes.molecule(MoleculeEnum.cellulose)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockSpruceSapling, 0.25f, ModRecipes.molecule(MoleculeEnum.cellulose)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockBirchSapling, 0.25f, ModRecipes.molecule(MoleculeEnum.cellulose)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockJungleSapling, 0.25f, ModRecipes.molecule(MoleculeEnum.cellulose)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockAcaciaSapling, 0.25f, ModRecipes.molecule(MoleculeEnum.cellulose)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockDarkOakSapling, 0.25f, ModRecipes.molecule(MoleculeEnum.cellulose)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockSand, ModRecipes.molecule(MoleculeEnum.siliconDioxide, 16)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockGravel, 0.35f, ModRecipes.molecule(MoleculeEnum.siliconDioxide)));
        RecipeDecomposer.add(new RecipeDecomposer(this.goldOre, ModRecipes.element(ElementEnum.Au, 48)));
        RecipeDecomposer.add(new RecipeDecomposer(this.ironOre, ModRecipes.element(ElementEnum.Fe, 48)));
        RecipeDecomposer.add(new RecipeDecomposer(this.coalOre, ModRecipes.element(ElementEnum.C, 48)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockOakLog, 0.5f, ModRecipes.molecule(MoleculeEnum.cellulose, 8)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockSpruceLog, 0.5f, ModRecipes.molecule(MoleculeEnum.cellulose, 8)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockBirchLog, 0.5f, ModRecipes.molecule(MoleculeEnum.cellulose, 8)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockJungleLog, 0.5f, ModRecipes.molecule(MoleculeEnum.cellulose, 8)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockAcaciaLog, 0.5f, ModRecipes.molecule(MoleculeEnum.cellulose, 8)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockDarkOakLog, 0.5f, ModRecipes.molecule(MoleculeEnum.cellulose, 8)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockOakLeaves, 0.5f, ModRecipes.molecule(MoleculeEnum.cellulose, 4)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockSpruceLeaves, 0.5f, ModRecipes.molecule(MoleculeEnum.cellulose, 4)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockBirchLeaves, 0.5f, ModRecipes.molecule(MoleculeEnum.cellulose, 4)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockJungleLeaves, 0.5f, ModRecipes.molecule(MoleculeEnum.cellulose, 4)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockAcaciaLeaves, 0.5f, ModRecipes.molecule(MoleculeEnum.cellulose, 4)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockDarkOakLeaves, 0.5f, ModRecipes.molecule(MoleculeEnum.cellulose, 4)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemDyePowderBlack, ModRecipes.molecule(MoleculeEnum.blackPigment)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemDyePowderRed, ModRecipes.molecule(MoleculeEnum.redPigment)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemDyePowderGreen, ModRecipes.molecule(MoleculeEnum.greenPigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemDyePowderBrown, 0.4f, ModRecipes.molecule(MoleculeEnum.theobromine), ModRecipes.molecule(MoleculeEnum.tannicacid)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemDyePowderBlue, ModRecipes.molecule(MoleculeEnum.lazurite)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemDyePowderPurple, ModRecipes.molecule(MoleculeEnum.purplePigment)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemDyePowderCyan, ModRecipes.molecule(MoleculeEnum.lightbluePigment), ModRecipes.molecule(MoleculeEnum.whitePigment)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemDyePowderLightGray, ModRecipes.molecule(MoleculeEnum.whitePigment), ModRecipes.molecule(MoleculeEnum.blackPigment)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemDyePowderGray, ModRecipes.molecule(MoleculeEnum.whitePigment), ModRecipes.molecule(MoleculeEnum.blackPigment, 2)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemDyePowderPink, ModRecipes.molecule(MoleculeEnum.redPigment), ModRecipes.molecule(MoleculeEnum.whitePigment)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemDyePowderLime, ModRecipes.molecule(MoleculeEnum.limePigment)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemDyePowderYellow, ModRecipes.molecule(MoleculeEnum.yellowPigment)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemDyePowderLightBlue, ModRecipes.molecule(MoleculeEnum.lightbluePigment)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemDyePowderMagenta, ModRecipes.molecule(MoleculeEnum.lightbluePigment), ModRecipes.molecule(MoleculeEnum.redPigment)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemDyePowderOrange, ModRecipes.molecule(MoleculeEnum.orangePigment)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemDyePowderWhite, ModRecipes.molecule(MoleculeEnum.whitePigment)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockGlass, ModRecipes.molecule(MoleculeEnum.siliconDioxide, 16)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockGlassPane, ModRecipes.molecule(MoleculeEnum.siliconDioxide, 6)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockOreLapis, ModRecipes.molecule(MoleculeEnum.lazurite, 6), ModRecipes.molecule(MoleculeEnum.sodalite), ModRecipes.molecule(MoleculeEnum.noselite), ModRecipes.molecule(MoleculeEnum.calciumCarbonate), ModRecipes.molecule(MoleculeEnum.pyrite)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockLapis, ModRecipes.molecule(MoleculeEnum.lazurite, 9)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockCobweb, ModRecipes.molecule(MoleculeEnum.fibroin)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockSunFlower, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockLilac, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockTallGrass, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockLargeFern, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockRoseBush, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockPeony, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockSandStone, ModRecipes.molecule(MoleculeEnum.siliconDioxide, 16)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockChiseledSandStone, ModRecipes.molecule(MoleculeEnum.siliconDioxide, 16)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockSmoothSandStone, ModRecipes.molecule(MoleculeEnum.siliconDioxide, 16)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockWool, 0.6f, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.whitePigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockOrangeWool, 0.6f, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.orangePigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockMagentaWool, 0.6f, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.lightbluePigment), ModRecipes.molecule(MoleculeEnum.redPigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockLightBlueWool, 0.6f, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.lightbluePigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockYellowWool, 0.6f, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.yellowPigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockLimeWool, 0.6f, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.limePigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockPinkWool, 0.6f, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.redPigment), ModRecipes.molecule(MoleculeEnum.whitePigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockGrayWool, 0.6f, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.whitePigment), ModRecipes.molecule(MoleculeEnum.blackPigment, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockLightGrayWool, 0.6f, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.whitePigment), ModRecipes.molecule(MoleculeEnum.blackPigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockCyanWool, 0.6f, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.lightbluePigment), ModRecipes.molecule(MoleculeEnum.whitePigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockPurpleWool, 0.6f, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.purplePigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockBlueWool, 0.6f, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.lazurite)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockBrownWool, 0.6f, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.tannicacid)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockGreenWool, 0.6f, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.greenPigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockRedWool, 0.6f, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.redPigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockBlackWool, 0.6f, ModRecipes.molecule(MoleculeEnum.glycine, 2), ModRecipes.molecule(MoleculeEnum.blackPigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.carpetBlockWool, 0.4f, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.whitePigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.carpetBlockOrangeWool, 0.4f, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.orangePigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.carpetBlockMagentaWool, 0.4f, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.lightbluePigment), ModRecipes.molecule(MoleculeEnum.redPigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.carpetBlockLightBlueWool, 0.2f, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.lightbluePigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.carpetBlockYellowWool, 0.4f, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.yellowPigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.carpetBlockLimeWool, 0.4f, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.limePigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.carpetBlockPinkWool, 0.4f, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.redPigment), ModRecipes.molecule(MoleculeEnum.whitePigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.carpetBlockGrayWool, 0.4f, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.whitePigment), ModRecipes.molecule(MoleculeEnum.blackPigment, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.carpetBlockLightGrayWool, 0.4f, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.whitePigment), ModRecipes.molecule(MoleculeEnum.blackPigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.carpetBlockCyanWool, 0.4f, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.lightbluePigment), ModRecipes.molecule(MoleculeEnum.whitePigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.carpetBlockPurpleWool, 0.4f, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.purplePigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.carpetBlockBlueWool, 0.4f, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.lazurite)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.carpetBlockBrownWool, 0.4f, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.tannicacid)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.carpetBlockGreenWool, 0.4f, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.greenPigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.carpetBlockRedWool, 0.4f, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.redPigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.carpetBlockBlackWool, 0.4f, ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.blackPigment)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockYellowFlower, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.yellowPigment, 1)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockPoppyFlower, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.redPigment, 1)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockBlueOrchid, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), ModRecipes.molecule(MoleculeEnum.lazurite)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockAllium, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.purplePigment, 1)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockAsureBluet, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.whitePigment, 1)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockRedTulip, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.redPigment, 1)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockOrangeTulip, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.orangePigment, 1)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockWhiteTulip, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.whitePigment, 1)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockPinkTulip, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.whitePigment, 1), new Molecule(MoleculeEnum.redPigment, 1)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockOxeyeDaisy, 0.3f, new Molecule(MoleculeEnum.shikimicAcid, 2), new Molecule(MoleculeEnum.whitePigment, 1)));
        if (ModConfig.recreationalChemicalEffects) {
            RecipeDecomposer.add(new RecipeDecomposer(this.blockMushroomBrown, ModRecipes.molecule(MoleculeEnum.psilocybin), ModRecipes.molecule(MoleculeEnum.water, 2)));
        }
        RecipeDecomposer.add(new RecipeDecomposer(this.blockMushroomRed, ModRecipes.molecule(MoleculeEnum.pantherine), ModRecipes.molecule(MoleculeEnum.water, 2)));
        RecipeDecomposer.add(new RecipeDecomposer(new ItemStack(Blocks.field_150340_R), ModRecipes.element(ElementEnum.Au, 144)));
        RecipeDecomposer.add(new RecipeDecomposer(new ItemStack(Blocks.field_150339_S), ModRecipes.element(ElementEnum.Fe, 144)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockTnt, ModRecipes.molecule(MoleculeEnum.tnt)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockObsidian, ModRecipes.molecule(MoleculeEnum.siliconDioxide, 16), ModRecipes.molecule(MoleculeEnum.magnesiumOxide, 8)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockOreDiamond, ModRecipes.molecule(MoleculeEnum.fullrene, 6)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockDiamond, ModRecipes.molecule(MoleculeEnum.fullrene, 27)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockPressurePlatePlanks, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 4)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockOreRedstone, 0.8f, ModRecipes.molecule(MoleculeEnum.iron3oxide, 9), ModRecipes.element(ElementEnum.Cu, 9)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockCactus, ModRecipes.molecule(MoleculeEnum.mescaline), ModRecipes.molecule(MoleculeEnum.water, 20)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockPumpkin, ModRecipes.molecule(MoleculeEnum.cucurbitacin, 4)));
        RecipeDecomposer.add(new RecipeDecomposer(this.pumpkinSeed, ModRecipes.molecule(MoleculeEnum.cucurbitacin)));
        RecipeDecomposer.add(new RecipeDecomposerSelect(this.blockNetherrack, 0.15f, Lists.newArrayList((Object[])new ArrayList[]{Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si, 2), ModRecipes.element(ElementEnum.O), ModRecipes.element(ElementEnum.Fe)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si, 2), ModRecipes.element(ElementEnum.Ni), ModRecipes.element(ElementEnum.Tc)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si, 3), ModRecipes.element(ElementEnum.Ti), ModRecipes.element(ElementEnum.Fe)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si), ModRecipes.element(ElementEnum.W, 4), ModRecipes.element(ElementEnum.Cr, 2)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si, 10), ModRecipes.element(ElementEnum.W), ModRecipes.element(ElementEnum.Zn, 8), ModRecipes.element(ElementEnum.Be, 4)})})));
        RecipeDecomposer.add(new RecipeDecomposerSelect(this.itemNetherbrick, 0.15f, Lists.newArrayList((Object[])new ArrayList[]{Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si, 2), ModRecipes.element(ElementEnum.C), ModRecipes.element(ElementEnum.Fe)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si, 2), ModRecipes.element(ElementEnum.Ni), ModRecipes.element(ElementEnum.Tc)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si, 3), ModRecipes.element(ElementEnum.Ti), ModRecipes.element(ElementEnum.Fe)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si), ModRecipes.element(ElementEnum.W, 4), ModRecipes.element(ElementEnum.Cr, 2)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si, 10), ModRecipes.element(ElementEnum.W), ModRecipes.element(ElementEnum.Zn, 8), ModRecipes.element(ElementEnum.Be, 4)})})));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemPotion, ModRecipes.molecule(MoleculeEnum.water, 5), ModRecipes.molecule(MoleculeEnum.siliconDioxide, 16)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockIce, ModRecipes.molecule(MoleculeEnum.water, 8)));
        RecipeDecomposer.add(new RecipeDecomposerSelect(this.blockSlowSand, 0.2f, Lists.newArrayList((Object[])new ArrayList[]{Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Pb, 2), ModRecipes.element(ElementEnum.Be), ModRecipes.element(ElementEnum.Si, 2), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Pb), ModRecipes.element(ElementEnum.Si, 5), ModRecipes.element(ElementEnum.O, 2)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si, 2), ModRecipes.element(ElementEnum.O)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si, 6), ModRecipes.element(ElementEnum.O, 2)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Es), ModRecipes.element(ElementEnum.O, 2)})})));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockGlowStone, ModRecipes.element(ElementEnum.P, 4)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockMycelium, 0.09f, ModRecipes.molecule(MoleculeEnum.fingolimod)));
        RecipeDecomposer.add(new RecipeDecomposerSelect(this.blockWhiteStone, 0.8f, Lists.newArrayList((Object[])new ArrayList[]{Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si, 2), ModRecipes.element(ElementEnum.O), ModRecipes.element(ElementEnum.H, 4), ModRecipes.element(ElementEnum.Li)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Es)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Pu)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Fr)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Nd)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Nd)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Si, 2), ModRecipes.element(ElementEnum.O, 4)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.H, 4)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Be, 8)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Li, 2)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Zr)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Rb)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Ga), ModRecipes.element(ElementEnum.As)})})));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockOreEmerald, ModRecipes.molecule(MoleculeEnum.beryl, 6), ModRecipes.element(ElementEnum.Cr, 6), ModRecipes.element(ElementEnum.V, 6)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockEmerald, ModRecipes.molecule(MoleculeEnum.beryl, 18), ModRecipes.element(ElementEnum.Cr, 18), ModRecipes.element(ElementEnum.V, 18)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemAppleRed, ModRecipes.molecule(MoleculeEnum.malicAcid)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemArrow, ModRecipes.element(ElementEnum.Si), ModRecipes.element(ElementEnum.O, 2), ModRecipes.element(ElementEnum.N, 6)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemCoal, 0.92f, ModRecipes.element(ElementEnum.C, 8)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockCoal, 0.82f, ModRecipes.element(ElementEnum.C, 72)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemChar, 0.82f, ModRecipes.element(ElementEnum.C, 8)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemDiamond, ModRecipes.molecule(MoleculeEnum.fullrene, 3)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemIngotIron, ModRecipes.element(ElementEnum.Fe, 16)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemIngotGold, ModRecipes.element(ElementEnum.Au, 16)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemStick, 0.3f, ModRecipes.molecule(MoleculeEnum.cellulose)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemString, 0.45f, ModRecipes.molecule(MoleculeEnum.serine), ModRecipes.molecule(MoleculeEnum.glycine), ModRecipes.molecule(MoleculeEnum.alinine)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemFeather, ModRecipes.molecule(MoleculeEnum.water, 8), ModRecipes.element(ElementEnum.N, 6)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemGunpowder, ModRecipes.molecule(MoleculeEnum.potassiumNitrate), ModRecipes.element(ElementEnum.S, 2), ModRecipes.element(ElementEnum.C)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemBread, 0.1f, ModRecipes.molecule(MoleculeEnum.starch), ModRecipes.molecule(MoleculeEnum.sucrose)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemFlint, 0.5f, ModRecipes.molecule(MoleculeEnum.siliconDioxide)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemAppleGold, ModRecipes.molecule(MoleculeEnum.malicAcid), ModRecipes.element(ElementEnum.Au, 64)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemDoorAcacia, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 12)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemDoorBirch, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 12)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemDoorDarkOak, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 12)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemDoorJungle, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 12)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemDoorOak, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 12)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemDoorSpruce, 0.4f, ModRecipes.molecule(MoleculeEnum.cellulose, 12)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemBucket, ModRecipes.element(ElementEnum.Fe, 48)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemBucketWater, ModRecipes.molecule(MoleculeEnum.water, 16), ModRecipes.element(ElementEnum.Fe, 48)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemRedstoneDust, 0.42f, ModRecipes.molecule(MoleculeEnum.iron3oxide), ModRecipes.element(ElementEnum.Cu)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.blockRedstone, 0.42f, ModRecipes.molecule(MoleculeEnum.iron3oxide, 9), ModRecipes.element(ElementEnum.Cu, 9)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemSnowball, ModRecipes.molecule(MoleculeEnum.water)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemLeather, 0.2f, ModRecipes.molecule(MoleculeEnum.keratin)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemBrick, 0.5f, ModRecipes.molecule(MoleculeEnum.kaolinite)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemClayBall, 0.5f, ModRecipes.molecule(MoleculeEnum.kaolinite)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemReed, 0.65f, ModRecipes.molecule(MoleculeEnum.sucrose), ModRecipes.element(ElementEnum.H, 2), ModRecipes.element(ElementEnum.O)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemVine, ModRecipes.molecule(MoleculeEnum.cellulose, 6)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemPaper, 0.35f, ModRecipes.molecule(MoleculeEnum.cellulose)));
        RecipeDecomposer.add(new RecipeDecomposerSelect(this.itemCompass, 1.0f, Lists.newArrayList((Object[])new ArrayList[]{Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Fe, 64)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Fe, 64), ModRecipes.molecule(MoleculeEnum.iron3oxide)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Fe, 64), ModRecipes.molecule(MoleculeEnum.iron3oxide), ModRecipes.element(ElementEnum.Cu)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Fe, 64), ModRecipes.element(ElementEnum.Cu)})})));
        RecipeDecomposer.add(new RecipeDecomposerSuper(this.itemMap, (NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{this.itemPaper, this.itemPaper, this.itemPaper, this.itemPaper, this.itemPaper, this.itemPaper, this.itemPaper, this.itemPaper, this.itemCompass})));
        RecipeDecomposer.add(new RecipeDecomposerSuper(this.itemBook, (NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{this.itemPaper, this.itemPaper, this.itemPaper, this.itemLeather})));
        RecipeDecomposer.add(new RecipeDecomposerSuper(this.blockBook, (NonNullList<ItemStack>)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{this.blockBirchWoodPlanks, this.blockBirchWoodPlanks, this.blockBirchWoodPlanks, this.itemBook, this.itemBook, this.itemBook, this.blockBirchWoodPlanks, this.blockBirchWoodPlanks, this.blockBirchWoodPlanks})));
        RecipeDecomposer.add(new RecipeDecomposerSelect(this.itemCompass, 1.0f, Lists.newArrayList((Object[])new ArrayList[]{Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.molecule(MoleculeEnum.pmma)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.element(ElementEnum.Hg)}), Lists.newArrayList((Object[])new PotionChemical[]{ModRecipes.molecule(MoleculeEnum.water, 10)})})));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemGlowstone, ModRecipes.element(ElementEnum.P)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemBone, ModRecipes.molecule(MoleculeEnum.hydroxylapatite)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemSugar, 0.75f, ModRecipes.molecule(MoleculeEnum.sucrose)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemMelon, ModRecipes.molecule(MoleculeEnum.water, 1)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockMelon, ModRecipes.molecule(MoleculeEnum.cucurbitacin), ModRecipes.molecule(MoleculeEnum.asparticAcid), ModRecipes.molecule(MoleculeEnum.water, 16)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemChickenCooked, ModRecipes.element(ElementEnum.K), ModRecipes.element(ElementEnum.Na), ModRecipes.element(ElementEnum.C, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemRottenFlesh, 0.05f, new Molecule(MoleculeEnum.nodularin, 1)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemEnderPearl, ModRecipes.element(ElementEnum.Es), ModRecipes.molecule(MoleculeEnum.calciumCarbonate, 8)));
        RecipeDecomposer.add(new RecipeDecomposer(this.blockEnderDragonEgg, ModRecipes.molecule(MoleculeEnum.calciumCarbonate, 16), ModRecipes.molecule(MoleculeEnum.hydroxylapatite, 6), ModRecipes.element(ElementEnum.Pu, 18), ModRecipes.element(ElementEnum.Fm, 8)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemBlazeRod, ModRecipes.element(ElementEnum.Pu, 6)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemBlazePowder, ModRecipes.element(ElementEnum.Pu)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemGhastTear, ModRecipes.element(ElementEnum.Yb, 4), ModRecipes.element(ElementEnum.No, 4)));
        if (ModConfig.recreationalChemicalEffects) {
            RecipeDecomposer.add(new RecipeDecomposerChance(this.itemNetherStalkSeeds, 0.5f, ModRecipes.molecule(MoleculeEnum.cocainehcl)));
        }
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemSpiderEye, 0.2f, ModRecipes.molecule(MoleculeEnum.tetrodotoxin)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemFermentedSpiderEye, ModRecipes.element(ElementEnum.Po), ModRecipes.molecule(MoleculeEnum.ethanol)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemMagmaCream, ModRecipes.element(ElementEnum.Hg), ModRecipes.element(ElementEnum.Pu), ModRecipes.molecule(MoleculeEnum.pmma, 3)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemSpeckledMelon, ModRecipes.molecule(MoleculeEnum.water, 4), ModRecipes.molecule(MoleculeEnum.whitePigment), ModRecipes.element(ElementEnum.Au, 1)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemEmerald, ModRecipes.molecule(MoleculeEnum.beryl, 2), ModRecipes.element(ElementEnum.Cr, 2), ModRecipes.element(ElementEnum.V, 2)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemWheat, 0.3f, ModRecipes.molecule(MoleculeEnum.cellulose, 2)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemCarrot, ModRecipes.molecule(MoleculeEnum.retinol)));
        RecipeDecomposer.add(new RecipeDecomposerChance(this.itemPotato, 0.4f, ModRecipes.molecule(MoleculeEnum.water, 8), ModRecipes.element(ElementEnum.K, 2), ModRecipes.molecule(MoleculeEnum.cellulose)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemGoldenCarrot, ModRecipes.molecule(MoleculeEnum.retinol), ModRecipes.element(ElementEnum.Au, 4)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemNetherStar, this.elementHelium, this.elementHelium, this.elementHelium, this.elementCarbon, ModRecipes.element(ElementEnum.Cn, 16), this.elementHelium, this.elementHydrogen, this.elementHydrogen, this.elementHydrogen));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemNetherQuartz, ModRecipes.molecule(MoleculeEnum.siliconDioxide, 4), ModRecipes.molecule(MoleculeEnum.galliumarsenide, 1)));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemRecord13, this.moleculePolyvinylChloride, this.moleculePolyvinylChloride));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemRecordCat, this.moleculePolyvinylChloride, this.moleculePolyvinylChloride));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemRecordFar, this.moleculePolyvinylChloride, this.moleculePolyvinylChloride));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemRecordMall, this.moleculePolyvinylChloride, this.moleculePolyvinylChloride));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemRecordMellohi, this.moleculePolyvinylChloride, this.moleculePolyvinylChloride));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemRecordStal, this.moleculePolyvinylChloride, this.moleculePolyvinylChloride));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemRecordStrad, this.moleculePolyvinylChloride, this.moleculePolyvinylChloride));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemRecordWard, this.moleculePolyvinylChloride, this.moleculePolyvinylChloride));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemRecordChirp, this.moleculePolyvinylChloride, this.moleculePolyvinylChloride));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemRecord11, this.moleculePolyvinylChloride, this.moleculePolyvinylChloride));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemRecordWait, this.moleculePolyvinylChloride, this.moleculePolyvinylChloride));
        RecipeDecomposer.add(new RecipeDecomposer(this.itemRecordBlocks, this.moleculePolyvinylChloride, this.moleculePolyvinylChloride));
        RecipeDecomposer.add(new RecipeDecomposer(this.bars, ModRecipes.element(ElementEnum.Fe, 3), ModRecipes.element(ElementEnum.Fe, 3)));
        RecipeDecomposer.addOreDictRecipe("oreUranium", ModRecipes.element(ElementEnum.U, 48));
        for (MoleculeEnum molecule : MoleculeEnum.molecules.values()) {
            if (molecule == null) continue;
            ItemStack itemStack = new ItemStack((Item)ModItems.molecule, 1, molecule.id());
            RecipeDecomposer.add(new RecipeDecomposer(itemStack, molecule.components()));
        }
    }

    public void registerOreDictRecipes() {
        RecipeDecomposer.addOreDictRecipe("dustSalt", new Element(ElementEnum.Na), new Element(ElementEnum.Cl));
        RecipeDecomposer.addOreDictRecipe("logWood", new Molecule(MoleculeEnum.cellulose, 8));
        RecipeDecomposer.addOreDictRecipe("plankWood", new Molecule(MoleculeEnum.cellulose, 2));
        RecipeDecomposer.addOreDictRecipe("ingotIron", ModRecipes.element(ElementEnum.Fe, 16));
        RecipeDecomposer.addOreDictRecipe("ingotGold", ModRecipes.element(ElementEnum.Au, 16));
        RecipeDecomposer.addOreDictRecipe("ingotCopper", ModRecipes.element(ElementEnum.Cu, 16));
        RecipeDecomposer.addOreDictRecipe("ingotTin", ModRecipes.element(ElementEnum.Sn, 16));
        RecipeDecomposer.addOreDictRecipe("ingotSilver", ModRecipes.element(ElementEnum.Ag, 16));
        RecipeDecomposer.addOreDictRecipe("ingotLead", ModRecipes.element(ElementEnum.Pb, 16));
        RecipeDecomposer.addOreDictRecipe("ingotPlatinum", ModRecipes.element(ElementEnum.Pt, 16));
        RecipeDecomposer.addOreDictRecipe("ingotAluminium", ModRecipes.element(ElementEnum.Al, 16));
        RecipeDecomposer.addOreDictRecipe("ingotMagnesium", ModRecipes.element(ElementEnum.Mg, 16));
        RecipeDecomposer.addOreDictRecipe("ingotSteel", ModRecipes.element(ElementEnum.Fe, 15), ModRecipes.element(ElementEnum.C, 1));
        RecipeDecomposer.addOreDictRecipe("ingotHSLA", ModRecipes.element(ElementEnum.Fe, 15), ModRecipes.element(ElementEnum.C, 1));
        RecipeDecomposer.addOreDictRecipe("ingotBronze", ModRecipes.element(ElementEnum.Cu, 12), ModRecipes.element(ElementEnum.Sn, 4));
        RecipeDecomposer.addOreDictRecipe("ingotElectrum", ModRecipes.element(ElementEnum.Ag, 8), ModRecipes.element(ElementEnum.Au, 8));
        RecipeDecomposer.addOreDictRecipe("ingotInvar", ModRecipes.element(ElementEnum.Fe, 10), ModRecipes.element(ElementEnum.Ni, 6));
        for (String oreName : OreDictionary.getOreNames()) {
            if (oreName.contains("gemApatite")) {
                RecipeDecomposer.addOreDictRecipe(oreName, ModRecipes.element(ElementEnum.Ca, 5), ModRecipes.molecule(MoleculeEnum.phosphate, 4), ModRecipes.element(ElementEnum.Cl));
                RecipeHandlerSynthesis.addShapelessOreDictRecipe(oreName, 1000, ModRecipes.element(ElementEnum.Ca, 5), ModRecipes.molecule(MoleculeEnum.phosphate, 4), ModRecipes.element(ElementEnum.Cl));
                continue;
            }
            if (oreName.contains("plateSilicon")) {
                RecipeDecomposer.addOreDictRecipe(oreName, ModRecipes.element(ElementEnum.Si, 2));
                RecipeHandlerSynthesis.addShapelessOreDictRecipe(oreName, 1000, ModRecipes.element(ElementEnum.Si, 2));
                continue;
            }
            if (oreName.contains("xychoriumBlue")) {
                RecipeDecomposer.addOreDictRecipe(oreName, ModRecipes.element(ElementEnum.Zr, 2), ModRecipes.element(ElementEnum.Cu, 1));
                RecipeHandlerSynthesis.addShapelessOreDictRecipe(oreName, 300, ModRecipes.element(ElementEnum.Zr, 2), ModRecipes.element(ElementEnum.Cu, 1));
                continue;
            }
            if (oreName.contains("xychoriumRed")) {
                RecipeDecomposer.addOreDictRecipe(oreName, ModRecipes.element(ElementEnum.Zr, 2), ModRecipes.element(ElementEnum.Fe, 1));
                RecipeHandlerSynthesis.addShapelessOreDictRecipe(oreName, 300, ModRecipes.element(ElementEnum.Zr, 2), ModRecipes.element(ElementEnum.Fe, 1));
                continue;
            }
            if (oreName.contains("xychoriumGreen")) {
                RecipeDecomposer.addOreDictRecipe(oreName, ModRecipes.element(ElementEnum.Zr, 2), ModRecipes.element(ElementEnum.V, 1));
                RecipeHandlerSynthesis.addShapelessOreDictRecipe(oreName, 300, ModRecipes.element(ElementEnum.Zr, 2), ModRecipes.element(ElementEnum.V, 1));
                continue;
            }
            if (oreName.contains("xychoriumDark")) {
                RecipeDecomposer.addOreDictRecipe(oreName, ModRecipes.element(ElementEnum.Zr, 2), ModRecipes.element(ElementEnum.Si, 1));
                RecipeHandlerSynthesis.addShapelessOreDictRecipe(oreName, 300, ModRecipes.element(ElementEnum.Zr, 2), ModRecipes.element(ElementEnum.Si, 1));
                continue;
            }
            if (oreName.contains("xychoriumLight")) {
                RecipeDecomposer.addOreDictRecipe(oreName, ModRecipes.element(ElementEnum.Zr, 2), ModRecipes.element(ElementEnum.Ti, 1));
                RecipeHandlerSynthesis.addShapelessOreDictRecipe(oreName, 300, ModRecipes.element(ElementEnum.Zr, 2), ModRecipes.element(ElementEnum.Ti, 1));
                continue;
            }
            if (oreName.contains("gemPeridot")) {
                RecipeDecomposer.addOreDictRecipe(oreName, ModRecipes.molecule(MoleculeEnum.olivine));
                RecipeHandlerSynthesis.addShapelessOreDictRecipe(oreName, 1000, ModRecipes.molecule(MoleculeEnum.olivine));
                continue;
            }
            if (oreName.contains("cropMaloberry")) {
                RecipeDecomposer.addOreDictRecipe(oreName, ModRecipes.molecule(MoleculeEnum.xylitol), ModRecipes.molecule(MoleculeEnum.sucrose));
                RecipeHandlerSynthesis.addShapelessOreDictRecipe(oreName, 1000, ModRecipes.molecule(MoleculeEnum.xylitol), ModRecipes.molecule(MoleculeEnum.sucrose));
                continue;
            }
            if (oreName.contains("cropDuskberry")) {
                if (!ModConfig.recreationalChemicalEffects) continue;
                RecipeDecomposer.addOreDictRecipe(oreName, ModRecipes.molecule(MoleculeEnum.psilocybin), ModRecipes.element(ElementEnum.S, 2));
                RecipeHandlerSynthesis.addShapelessOreDictRecipe(oreName, 1000, ModRecipes.molecule(MoleculeEnum.psilocybin), ModRecipes.element(ElementEnum.S, 2));
                continue;
            }
            if (oreName.contains("cropSkyberry")) {
                RecipeDecomposer.addOreDictRecipe(oreName, ModRecipes.molecule(MoleculeEnum.theobromine), ModRecipes.element(ElementEnum.S, 2));
                RecipeHandlerSynthesis.addShapelessOreDictRecipe(oreName, 1000, ModRecipes.molecule(MoleculeEnum.theobromine), ModRecipes.element(ElementEnum.S, 2));
                continue;
            }
            if (oreName.contains("cropBlightberry")) {
                RecipeDecomposer.addOreDictRecipe(oreName, ModRecipes.molecule(MoleculeEnum.asprin), ModRecipes.element(ElementEnum.S, 2));
                RecipeHandlerSynthesis.addShapelessOreDictRecipe(oreName, 1000, ModRecipes.molecule(MoleculeEnum.asprin), ModRecipes.element(ElementEnum.S, 2));
                continue;
            }
            if (oreName.contains("cropBlueberry")) {
                RecipeDecomposer.addOreDictRecipe(oreName, ModRecipes.molecule(MoleculeEnum.blueorgodye), ModRecipes.molecule(MoleculeEnum.sucrose, 2));
                RecipeHandlerSynthesis.addShapelessOreDictRecipe(oreName, 1000, ModRecipes.molecule(MoleculeEnum.blueorgodye), ModRecipes.molecule(MoleculeEnum.sucrose, 2));
                continue;
            }
            if (oreName.contains("cropRaspberry")) {
                RecipeDecomposer.addOreDictRecipe(oreName, ModRecipes.molecule(MoleculeEnum.redorgodye), ModRecipes.molecule(MoleculeEnum.sucrose, 2));
                RecipeHandlerSynthesis.addShapelessOreDictRecipe(oreName, 1000, ModRecipes.molecule(MoleculeEnum.redorgodye), ModRecipes.molecule(MoleculeEnum.sucrose, 2));
                continue;
            }
            if (oreName.contains("cropBlackberry")) {
                RecipeDecomposer.addOreDictRecipe(oreName, ModRecipes.molecule(MoleculeEnum.purpleorgodye), ModRecipes.molecule(MoleculeEnum.sucrose, 2));
                RecipeHandlerSynthesis.addShapelessOreDictRecipe(oreName, 1000, ModRecipes.molecule(MoleculeEnum.purpleorgodye), ModRecipes.molecule(MoleculeEnum.sucrose, 2));
                continue;
            }
            for (IOreDictionaryHandler handler : ModRecipes.getOreDictionaryHandlers()) {
                if (!handler.canHandle(oreName)) continue;
                handler.handle(oreName);
                return;
            }
        }
    }

    public boolean shouldCreateSynthesis(ItemStack item) {
        if (item.func_77973_b() == Items.field_151055_y) {
            return false;
        }
        if (item.func_77973_b() instanceof ItemBlock) {
            return this.shouldCreateSynthesis((ItemBlock)item.func_77973_b());
        }
        return true;
    }

    public boolean shouldCreateSynthesis(ItemBlock block) {
        return !(block.func_179223_d() instanceof BlockOre);
    }

    public static ArrayList<IOreDictionaryHandler> getOreDictionaryHandlers() {
        ArrayList oreDictionaryHandlers = Lists.newArrayList();
        oreDictionaryHandlers.add(new OreDictionaryDefaultHandler());
        if (ModIntegration.Mods.AE2.isLoaded()) {
            oreDictionaryHandlers.add(new OreDictionaryAppliedEnergisticsHandler());
        }
        if (ModIntegration.Mods.EXU2.isLoaded()) {
            oreDictionaryHandlers.add(new OreDictionaryExtraUtilitiesHandler());
        }
        return oreDictionaryHandlers;
    }

    public static Element element(ElementEnum var1, int var2) {
        return new Element(var1, var2);
    }

    public static Element element(ElementEnum var1) {
        return new Element(var1, 1);
    }

    public static Molecule molecule(MoleculeEnum var1, int var2) {
        return new Molecule(var1, var2);
    }

    public static Molecule molecule(MoleculeEnum var1) {
        return new Molecule(var1, 1);
    }

    public static void registerCustomRecipes(IForgeRegistry<IRecipe> registry) {
        registry.register((IForgeRegistryEntry)new RecipePotionCoating());
        registry.register((IForgeRegistryEntry)new RecipePotionSpiking());
        registry.register((IForgeRegistryEntry)new RecipeCloneChemistJournal());
        block0: for (String oreName : OreDictionary.getOreNames()) {
            ModLogger.debug("Checking oredict " + oreName);
            if (ModRecipes.getOreDictionaryHandlers() == null) continue;
            for (IOreDictionaryHandler handler : ModRecipes.getOreDictionaryHandlers()) {
                if (!handler.canHandle(oreName)) continue;
                handler.handle(oreName);
                continue block0;
            }
        }
    }
}

