/*
 * Decompiled with CFR 0.152.
 */
package minechem.init;

import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BuiltInModel;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ModRendering {
    private static final ModelResourceLocation TEISR_LOC = new ModelResourceLocation(new ResourceLocation("minechem", "teisr"), "inventory");
    public static final ModelResourceLocation ITEM_ELEMENT_LOC = new ModelResourceLocation(new ResourceLocation("minechem", "tube_filled"), "inventory");
    public static final ModelResourceLocation ITEM_MOLECULE_LOC = new ModelResourceLocation(new ResourceLocation("minechem", "molecule"), "inventory");
    private static List<Pair<ModelResourceLocation, IBakedModel>> particleModels = new LinkedList<Pair<ModelResourceLocation, IBakedModel>>();

    public static void setItemTEISR(Item item, TileEntityItemStackRenderer renderer) {
        ModRendering.setItemTEISR(item, renderer, 0);
    }

    public static void setItemTEISR(Item item, TileEntityItemStackRenderer renderer, int meta) {
        ModRendering.setItemTEISR(item, renderer, meta, TEISR_LOC);
    }

    public static void setItemTEISR(Item item, TileEntityItemStackRenderer renderer, int meta, ModelResourceLocation location) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)location);
        item.setTileEntityItemStackRenderer(renderer);
    }

    public static void setBlockTEISR(Block block, TileEntityItemStackRenderer renderer) {
        ModRendering.setItemTEISR(Item.func_150898_a((Block)block), renderer);
    }

    public static void registerParticle(ModelResourceLocation location, IBakedModel model) {
        particleModels.add((Pair<ModelResourceLocation, IBakedModel>)new ImmutablePair((Object)location, (Object)model));
    }

    public static <T extends TileEntity> void setBlockRendering(Block block, TileEntitySpecialRenderer<? super T> blockRenderer, Class<T> tile, TileEntityItemStackRenderer itemRenderer, final ResourceLocation particleTexture) {
        ModRendering.setItemTEISR(Item.func_150898_a((Block)block), itemRenderer);
        ClientRegistry.bindTileEntitySpecialRenderer(tile, blockRenderer);
        ModelResourceLocation particleLoc = new ModelResourceLocation(block.getRegistryName(), "particle");
        ModRendering.registerParticle(particleLoc, (IBakedModel)new BuiltInModel(ItemCameraTransforms.field_178357_a, ItemOverrideList.field_188022_a){

            public TextureAtlasSprite func_177554_e() {
                return Minecraft.func_71410_x().func_147117_R().func_110572_b(particleTexture.toString());
            }
        });
        ModelLoader.setCustomStateMapper((Block)block, blockIn -> Maps.toMap((Iterable)blockIn.func_176194_O().func_177619_a(), input -> particleLoc));
    }

    public static List<Pair<ModelResourceLocation, IBakedModel>> getParticleModels() {
        return particleModels;
    }
}

