/*
 * Decompiled with CFR 0.152.
 */
package minechem.integration;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import minechem.init.ModBlocks;
import minechem.init.ModNetworking;
import minechem.init.ModRegistries;
import minechem.integration.jei.PacketSynthesisRecipeTransfer;
import minechem.integration.jei.ShapedSynthesisWrapper;
import minechem.integration.jei.ShapelessSynthesisWrapper;
import minechem.integration.jei.SynthesisRecipeCategory;
import minechem.integration.jei.SynthesisTransferHandler;
import minechem.integration.jei.TabMover;
import minechem.recipe.RecipeSynthesisShaped;
import minechem.recipe.RecipeSynthesisShapeless;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;

@JEIPlugin
public class JEI
implements IModPlugin {
    public static final String CAT_SYNTH = "minechem.synthesis";

    public static void registerPackets() {
        ModNetworking.INSTANCE.registerMessage(PacketSynthesisRecipeTransfer.class, PacketSynthesisRecipeTransfer.class, ModNetworking.nextID(), Side.SERVER);
    }

    public void register(IModRegistry registry) {
        IIngredientBlacklist blacklist = registry.getJeiHelpers().getIngredientBlacklist();
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        blacklist.addIngredientToBlacklist((Object)new ItemStack(ModBlocks.ghostBlock));
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new TabMover()});
        registry.addRecipes(ModRegistries.SYNTHESIS_RECIPES.getValuesCollection(), CAT_SYNTH);
        registry.handleRecipes(RecipeSynthesisShapeless.class, recipe -> new ShapelessSynthesisWrapper<RecipeSynthesisShapeless>(registry.getJeiHelpers(), (RecipeSynthesisShapeless)recipe), CAT_SYNTH);
        registry.handleRecipes(RecipeSynthesisShaped.class, recipe -> new ShapedSynthesisWrapper(registry.getJeiHelpers(), (RecipeSynthesisShaped)recipe), CAT_SYNTH);
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.synthesis), new String[]{CAT_SYNTH});
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)new SynthesisTransferHandler(jeiHelpers.recipeTransferHandlerHelper()), CAT_SYNTH);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new SynthesisRecipeCategory(guiHelper)});
    }
}

