/*
 * Decompiled with CFR 0.152.
 */
package minechem.integration.jei;

import java.util.ArrayList;
import javax.annotation.Nullable;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.recipes.BrokenCraftingRecipeException;
import mezz.jei.util.ErrorUtil;
import minechem.api.recipe.ISynthesisRecipe;
import minechem.recipe.RecipeSynthesisShapeless;
import minechem.recipe.SingleItemStackBasedIngredient;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

public class ShapelessSynthesisWrapper<T extends ISynthesisRecipe>
implements ICraftingRecipeWrapper {
    private final IJeiHelpers jeiHelpers;
    protected final T recipe;

    public ShapelessSynthesisWrapper(IJeiHelpers jeiHelpers, T recipe) {
        this.jeiHelpers = jeiHelpers;
        this.recipe = recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        ItemStack recipeOutput = this.recipe.getRecipeOutput();
        IStackHelper stackHelper = this.jeiHelpers.getStackHelper();
        try {
            ArrayList inputLists = new ArrayList();
            if (this.recipe instanceof RecipeSynthesisShapeless) {
                RecipeSynthesisShapeless synthRecipe = (RecipeSynthesisShapeless)this.recipe;
                for (int i = 0; i < synthRecipe.getSingleIngredients().size(); ++i) {
                    ArrayList<ItemStack> tmpList = new ArrayList<ItemStack>();
                    for (int j = 0; j < ((SingleItemStackBasedIngredient)((Object)synthRecipe.getSingleIngredients().get(i))).func_193365_a().length; ++j) {
                        tmpList.add(((SingleItemStackBasedIngredient)((Object)synthRecipe.getSingleIngredients().get(i))).func_193365_a()[j]);
                    }
                    inputLists.add(tmpList);
                }
            } else {
                for (int i = 0; i < this.recipe.getIngredients().size(); ++i) {
                    ArrayList<ItemStack> tmpList = new ArrayList<ItemStack>();
                    for (int j = 0; j < ((Ingredient)this.recipe.getIngredients().get(i)).func_193365_a().length; ++j) {
                        tmpList.add(((Ingredient)this.recipe.getIngredients().get(i)).func_193365_a()[j]);
                    }
                    inputLists.add(tmpList);
                }
            }
            ingredients.setInputLists(ItemStack.class, inputLists);
            ingredients.setOutput(ItemStack.class, (Object)recipeOutput);
        }
        catch (RuntimeException e) {
            String info = ErrorUtil.getInfoFromBrokenCraftingRecipe(this.recipe, this.recipe.getIngredients(), (ItemStack)recipeOutput);
            throw new BrokenCraftingRecipeException(info, (Throwable)e);
        }
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.recipe.getRegistryName();
    }
}

