/*
 * Decompiled with CFR 0.152.
 */
package minechem.integration.jei;

import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import mezz.jei.config.Constants;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.util.Translator;
import minechem.init.ModBlocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class SynthesisRecipeCategory
implements IRecipeCategory<IRecipeWrapper> {
    private static final int craftOutputSlot = 0;
    private static final int craftInputSlot1 = 1;
    public static final int width = 116;
    public static final int height = 54;
    private final IDrawable background;
    private final IDrawable icon;
    private final String localizedName;
    private final ICraftingGridHelper craftingGridHelper;

    public SynthesisRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = Constants.RECIPE_GUI_VANILLA;
        this.background = guiHelper.createDrawable(location, 0, 60, 116, 54);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModBlocks.synthesis));
        this.localizedName = Translator.translateToLocal((String)"gui.title.synthesis");
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
    }

    public String getUid() {
        return "minechem.synthesis";
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getModName() {
        return "Minechem";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        ICraftingRecipeWrapper craftingRecipeWrapper;
        ResourceLocation registryName;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 94, 18);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        if (recipeWrapper instanceof ICustomCraftingRecipeWrapper) {
            ICustomCraftingRecipeWrapper customWrapper = (ICustomCraftingRecipeWrapper)recipeWrapper;
            customWrapper.setRecipe(recipeLayout, ingredients);
            return;
        }
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        if (recipeWrapper instanceof IShapedCraftingRecipeWrapper) {
            IShapedCraftingRecipeWrapper wrapper = (IShapedCraftingRecipeWrapper)recipeWrapper;
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs, wrapper.getWidth(), wrapper.getHeight());
        } else {
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
            recipeLayout.setShapeless();
        }
        guiItemStacks.set(0, (List)outputs.get(0));
        if (recipeWrapper instanceof ICraftingRecipeWrapper && (registryName = (craftingRecipeWrapper = (ICraftingRecipeWrapper)recipeWrapper).getRegistryName()) != null) {
            guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 0) {
                    boolean showAdvanced;
                    String modName;
                    String recipeModId = registryName.func_110624_b();
                    boolean modIdDifferent = false;
                    ResourceLocation itemRegistryName = ingredient.func_77973_b().getRegistryName();
                    if (itemRegistryName != null) {
                        String itemModId = itemRegistryName.func_110624_b();
                        boolean bl = modIdDifferent = !recipeModId.equals(itemModId);
                    }
                    if (modIdDifferent && (modName = ForgeModIdHelper.getInstance().getFormattedModNameForModId(recipeModId)) != null) {
                        tooltip.add(TextFormatting.GRAY + Translator.translateToLocalFormatted((String)"jei.tooltip.recipe.by", (Object[])new Object[]{modName}));
                    }
                    boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || GuiScreen.func_146272_n();
                    if (showAdvanced) {
                        tooltip.add(TextFormatting.DARK_GRAY + Translator.translateToLocalFormatted((String)"jei.tooltip.recipe.id", (Object[])new Object[]{registryName.toString()}));
                    }
                }
            });
        }
    }
}

