/*
 * Decompiled with CFR 0.152.
 */
package minechem.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Iterator;
import minechem.Minechem;
import minechem.api.ICustomRenderer;
import minechem.init.ModCreativeTab;
import minechem.item.ItemElement;
import minechem.item.element.ElementEnum;
import minechem.item.polytool.PolytoolHelper;
import minechem.item.polytool.PolytoolTypeAlloy;
import minechem.item.polytool.PolytoolUpgradeType;
import minechem.utils.MinechemUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemPolytool
extends ItemPickaxe
implements ICustomRenderer {
    public static ItemPolytool instance;

    public ItemPolytool() {
        super(Item.ToolMaterial.IRON);
        instance = this;
        this.func_77637_a(ModCreativeTab.CREATIVE_TAB_ITEMS);
        this.func_77655_b("polytool");
        this.setRegistryName("minechem:polytool");
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
    }

    public static boolean validAlloyInfusion(ItemStack polytool, ItemStack element) {
        PolytoolUpgradeType upgrade;
        if (element.func_77973_b() instanceof ItemElement && (upgrade = PolytoolHelper.getTypeFromElement(MinechemUtil.getElement(element), 1.0f)) instanceof PolytoolTypeAlloy) {
            ItemStack toApply = polytool.func_77946_l();
            ItemPolytool.addTypeToNBT(toApply, upgrade);
            if (!(instance.getSwordStr(toApply) > 0.0f && instance.getPickaxeStr(toApply) > 0.0f && instance.getStoneStr(toApply) > 0.0f && instance.getAxeStr(toApply) > 0.0f && instance.getShovelStr(toApply) > 0.0f)) {
                return false;
            }
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.openGui((Object)Minechem.INSTANCE, 3, world, player.field_70176_ah, player.field_70162_ai, player.field_70162_ai);
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public float getSwordStr(ItemStack stack) {
        float result = 8.0f;
        Iterator<PolytoolTypeAlloy> itr = ItemPolytool.getAlloyUpgrades(stack).iterator();
        while (itr.hasNext()) {
            result += itr.next().getStrSword();
        }
        return result;
    }

    public float getPickaxeStr(ItemStack stack) {
        float result = 8.0f;
        Iterator<PolytoolTypeAlloy> itr = ItemPolytool.getAlloyUpgrades(stack).iterator();
        while (itr.hasNext()) {
            result += itr.next().getStrOre();
        }
        return result;
    }

    public float getStoneStr(ItemStack stack) {
        float result = 8.0f;
        Iterator<PolytoolTypeAlloy> itr = ItemPolytool.getAlloyUpgrades(stack).iterator();
        while (itr.hasNext()) {
            result += itr.next().getStrStone();
        }
        return result;
    }

    public float getAxeStr(ItemStack stack) {
        float result = 8.0f;
        Iterator<PolytoolTypeAlloy> itr = ItemPolytool.getAlloyUpgrades(stack).iterator();
        while (itr.hasNext()) {
            result += itr.next().getStrAxe();
        }
        return result;
    }

    public float getShovelStr(ItemStack stack) {
        float result = 8.0f;
        Iterator<PolytoolTypeAlloy> itr = ItemPolytool.getAlloyUpgrades(stack).iterator();
        while (itr.hasNext()) {
            result += itr.next().getStrShovel();
        }
        return result;
    }

    public static ArrayList<PolytoolUpgradeType> getUpgrades(ItemStack stack) {
        ItemPolytool.ensureNBT(stack);
        ArrayList<PolytoolUpgradeType> toReturn = new ArrayList<PolytoolUpgradeType>();
        NBTTagList list = stack.func_77978_p().func_150295_c("Upgrades", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            toReturn.add(PolytoolHelper.getTypeFromElement(ElementEnum.getByID(nbt.func_74762_e("Element")), nbt.func_74760_g("Power")));
        }
        return toReturn;
    }

    public static ArrayList<PolytoolTypeAlloy> getAlloyUpgrades(ItemStack stack) {
        ArrayList<PolytoolTypeAlloy> result = new ArrayList<PolytoolTypeAlloy>();
        for (PolytoolUpgradeType type : ItemPolytool.getUpgrades(stack)) {
            if (!(type instanceof PolytoolTypeAlloy)) continue;
            result.add((PolytoolTypeAlloy)type);
        }
        return result;
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        par2EntityLivingBase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)par3EntityLivingBase)), this.getSwordStr(par1ItemStack));
        ArrayList<PolytoolUpgradeType> upgrades = ItemPolytool.getUpgrades(par1ItemStack);
        Iterator<PolytoolUpgradeType> iter = upgrades.iterator();
        while (iter.hasNext()) {
            iter.next().hitEntity(par1ItemStack, par2EntityLivingBase, par3EntityLivingBase);
        }
        return true;
    }

    public boolean func_179218_a(ItemStack p_150894_1_, World p_150894_2_, IBlockState state, BlockPos pos, EntityLivingBase p_150894_7_) {
        ArrayList<PolytoolUpgradeType> upgrades = ItemPolytool.getUpgrades(p_150894_1_);
        Iterator<PolytoolUpgradeType> iter = upgrades.iterator();
        while (iter.hasNext()) {
            iter.next().onBlockDestroyed(p_150894_1_, p_150894_2_, state.func_177230_c(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), p_150894_7_);
        }
        return true;
    }

    public static void addTypeToNBT(ItemStack stack, PolytoolUpgradeType type) {
        ItemPolytool.ensureNBT(stack);
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList list = stack.func_77978_p().func_150295_c("Upgrades", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            if (list.func_150305_b(i).func_74762_e("Element") != type.getElement().atomicNumber()) continue;
            list.func_150305_b(i).func_74776_a("Power", list.func_150305_b(i).func_74760_g("Power") + type.power);
            return;
        }
        compound.func_74776_a("Power", type.power);
        compound.func_74768_a("Element", type.getElement().atomicNumber());
        list.func_74742_a((NBTBase)compound);
    }

    public void func_77663_a(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        ArrayList<PolytoolUpgradeType> upgrades = ItemPolytool.getUpgrades(par1ItemStack);
        Iterator<PolytoolUpgradeType> iter = upgrades.iterator();
        while (iter.hasNext()) {
            iter.next().onTickFull(par1ItemStack, par2World, par3Entity, par4, par5);
        }
    }

    public static void ensureNBT(ItemStack item) {
        if (item.func_77978_p() == null) {
            item.func_77982_d(new NBTTagCompound());
        }
        if (!item.func_77978_p().func_74764_b("Upgrades")) {
            item.func_77978_p().func_74782_a("Upgrades", (NBTBase)new NBTTagList());
        }
        if (!item.func_77978_p().func_74764_b("Energy")) {
            item.func_77978_p().func_74768_a("Energy", 0);
        }
    }

    public static float getPowerOfType(ItemStack item, ElementEnum element) {
        ArrayList<PolytoolUpgradeType> upgrades = ItemPolytool.getUpgrades(item);
        for (PolytoolUpgradeType next : upgrades) {
            if (next.getElement().atomicNumber() != element.atomicNumber()) continue;
            return next.power;
        }
        return 0.0f;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        float result = 8.0f;
        Iterator<PolytoolUpgradeType> itr = ItemPolytool.getUpgrades(stack).iterator();
        while (itr.hasNext()) {
            result += itr.next().getStrVsBlock(stack, state.func_177230_c(), state.func_177230_c().func_176201_c(state));
        }
        return result;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.getSwordStr(stack), 0));
        return multimap;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderer() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

