/*
 * Decompiled with CFR 0.152.
 */
package minechem.network.message;

import io.netty.buffer.ByteBuf;
import minechem.api.IMinechemBlueprint;
import minechem.block.multiblock.tile.TileFusionCore;
import minechem.block.multiblock.tile.TileReactorCore;
import minechem.block.tile.TileMinechemEnergyBase;
import minechem.init.ModRegistries;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class FusionUpdateMessage
implements IMessage,
IMessageHandler<FusionUpdateMessage, IMessage> {
    private BlockPos pos;
    private int energyStored;
    private IMinechemBlueprint blueprint;
    private EnumFacing facing;
    private boolean doLink;

    public FusionUpdateMessage() {
    }

    public FusionUpdateMessage(TileFusionCore tile, boolean doLink) {
        this.pos = tile.func_174877_v();
        this.energyStored = tile.getEnergyStored();
        if (tile.getBlueprint() != null) {
            this.blueprint = tile.getBlueprint();
        }
        if (tile.getStructureFacing() != null) {
            this.facing = tile.getStructureFacing();
        }
        this.doLink = doLink;
    }

    public void fromBytes(ByteBuf buf) {
        int facingindex;
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.pos = new BlockPos(x, y, z);
        this.energyStored = buf.readInt();
        String bp = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (!bp.isEmpty()) {
            this.blueprint = (IMinechemBlueprint)ModRegistries.MINECHEM_BLUEPRINTS.getValue(new ResourceLocation(bp));
        }
        this.facing = (facingindex = buf.readInt()) == -1 ? null : EnumFacing.values()[facingindex];
        this.doLink = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.energyStored);
        String bp = "";
        if (this.blueprint != null && this.blueprint.getRegistryName() != null) {
            bp = this.blueprint.getRegistryName().toString();
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)bp);
        buf.writeInt(this.facing == null ? -1 : this.facing.ordinal());
        buf.writeBoolean(this.doLink);
    }

    public IMessage onMessage(FusionUpdateMessage message, MessageContext ctx) {
        TileEntity tileEntity = FMLClientHandler.instance().getClient().field_71441_e.func_175625_s(message.pos);
        if (tileEntity != null) {
            TileFusionCore te;
            if (!message.doLink && tileEntity instanceof TileReactorCore) {
                ((TileReactorCore)tileEntity).unlinkProxies();
            }
            if (!(tileEntity instanceof TileFusionCore)) {
                te = new TileFusionCore();
                te.func_145834_a(tileEntity.func_145831_w());
                te.func_174878_a(message.pos);
                te.setBlockType(tileEntity.func_145831_w().func_180495_p(message.pos).func_177230_c());
            } else {
                te = (TileFusionCore)tileEntity;
            }
            IEnergyStorage energyStorage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, null);
            if (energyStorage != null && energyStorage instanceof TileMinechemEnergyBase.EnergySettable) {
                ((TileMinechemEnergyBase.EnergySettable)te.getCapability(CapabilityEnergy.ENERGY, null)).setEnergy(message.energyStored);
            }
            te.setBlueprint(message.blueprint);
            te.setStructureFacing(message.facing);
            if (message.doLink) {
                te.linkProxies();
            } else {
                te.unlinkProxies();
            }
        }
        return null;
    }
}

