/*
 * Decompiled with CFR 0.152.
 */
package minechem.potion;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import minechem.utils.MinechemUtil;
import minechem.utils.PotionHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.TextFormatting;

public abstract class PharmacologyEffect {
    private String colour;

    PharmacologyEffect(TextFormatting colour) {
        this.colour = colour.toString();
    }

    public abstract void applyEffect(EntityLivingBase var1);

    public String getColour() {
        return this.colour;
    }

    public static class Magic
    extends PharmacologyEffect {
        private int duration = 0;
        private int power = 0;
        private Potion potion;

        public Magic(String potionName, int power, int duration) {
            this(PotionHelper.getPotionByName(potionName), power, duration);
        }

        public Magic(String potionName, int duration) {
            this(potionName, 0, duration);
        }

        public Magic(Potion potion, int duration) {
            this(potion, 0, duration);
        }

        public Magic(Potion potion, int power, int duration) {
            super(TextFormatting.DARK_PURPLE);
            this.duration = duration;
            this.potion = potion;
            this.power = power;
        }

        @Override
        public void applyEffect(EntityLivingBase entityLivingBase) {
            entityLivingBase.func_70690_d(new PotionEffect(this.potion, this.duration * 20, this.power));
        }

        public String toString() {
            if (this.potion != null) {
                return "Potion Effect: " + MinechemUtil.getLocalString(this.potion.func_76393_a()) + ", Duration: " + this.duration + ", Power: " + this.power;
            }
            return "";
        }

        public Potion getPotion() {
            return this.potion;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Magic) {
                Magic other = (Magic)obj;
                if (other.duration == this.duration && other.potion == this.potion && other.power == this.power) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Damage
    extends PharmacologyEffect {
        private float damage;

        public Damage(float damage) {
            super(TextFormatting.GOLD);
            this.damage = damage;
        }

        @Override
        public void applyEffect(EntityLivingBase entityLivingBase) {
            entityLivingBase.func_70097_a(DamageSource.field_76377_j, this.damage);
        }

        public String toString() {
            float print = this.damage / 2.0f;
            return "Damage Effect: " + print + " heart" + (print == 1.0f ? "" : "s");
        }

        public boolean equals(Object obj) {
            if (obj instanceof Damage) {
                Damage other = (Damage)obj;
                if (other.damage == this.damage) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Cure
    extends PharmacologyEffect {
        private Potion potion;

        public Cure() {
            this((Potion)null);
        }

        public Cure(Potion potion) {
            super(TextFormatting.AQUA);
            this.potion = potion;
        }

        public Cure(String potionName) {
            this(PotionHelper.getPotionByName(potionName));
        }

        @Override
        public void applyEffect(EntityLivingBase entityLivingBase) {
            if (this.potion == null) {
                ArrayList effectsToRemove = Lists.newArrayList();
                for (PotionEffect potionEffect : entityLivingBase.func_70651_bq()) {
                    if (!potionEffect.func_188419_a().func_76398_f()) continue;
                    effectsToRemove.add(potionEffect);
                }
                for (PotionEffect effect : effectsToRemove) {
                    entityLivingBase.func_184589_d(effect.func_188419_a());
                }
            } else {
                entityLivingBase.func_184589_d(this.potion);
            }
        }

        public String toString() {
            return "Cure Effect: " + (this.potion == null ? "all" : MinechemUtil.getLocalString(this.potion.func_76393_a()));
        }

        public boolean equals(Object obj) {
            if (obj instanceof Cure) {
                Cure other = (Cure)obj;
                if (other.potion == this.potion) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Burn
    extends PharmacologyEffect {
        private int duration;

        public Burn(int duration) {
            super(TextFormatting.RED);
            this.duration = duration;
        }

        @Override
        public void applyEffect(EntityLivingBase entityLivingBase) {
            entityLivingBase.func_70015_d(this.duration);
        }

        public String toString() {
            return "Burn Effect: " + this.duration + " s";
        }

        public boolean equals(Object obj) {
            if (obj instanceof Burn) {
                Burn other = (Burn)obj;
                if (other.duration == this.duration) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Food
    extends PharmacologyEffect {
        private int level;
        private float saturation;

        public Food(int level, float saturation) {
            super(TextFormatting.DARK_GREEN);
            this.level = level;
            this.saturation = saturation;
        }

        @Override
        public void applyEffect(EntityLivingBase entityLivingBase) {
            if (entityLivingBase instanceof EntityPlayer) {
                ((EntityPlayer)entityLivingBase).func_71024_bL().func_75122_a(this.level, this.saturation);
            }
        }

        public String toString() {
            return "Food Effect: " + this.level + ", Saturation: " + this.saturation;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Food) {
                Food other = (Food)obj;
                if (other.level == this.level && other.saturation == this.saturation) {
                    return true;
                }
            }
            return false;
        }
    }
}

