/*
 * Decompiled with CFR 0.152.
 */
package minechem.potion;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import minechem.init.ModConfig;
import minechem.init.ModPotions;
import minechem.item.molecule.MoleculeEnum;
import minechem.potion.PharmacologyEffect;
import net.minecraft.entity.EntityLivingBase;

public class PharmacologyEffectRegistry {
    private static Map<MoleculeEnum, List<PharmacologyEffect>> effects = new HashMap<MoleculeEnum, List<PharmacologyEffect>>();

    public static void addEffect(MoleculeEnum molecule, PharmacologyEffect effect) {
        List<PharmacologyEffect> list = effects.get(molecule);
        if (list == null) {
            list = new LinkedList<PharmacologyEffect>();
        }
        for (PharmacologyEffect existingEffect : list) {
            if (!existingEffect.equals(effect)) continue;
            return;
        }
        list.add(effect);
        effects.put(molecule, list);
    }

    public static void addEffects(MoleculeEnum molecule, List<PharmacologyEffect> toAdd) {
        for (PharmacologyEffect effect : toAdd) {
            PharmacologyEffectRegistry.addEffect(molecule, effect);
        }
    }

    public static void addEffect(List<MoleculeEnum> molecules, PharmacologyEffect effect) {
        for (MoleculeEnum molecule : molecules) {
            PharmacologyEffectRegistry.addEffect(molecule, effect);
        }
    }

    public static boolean hasEffect(MoleculeEnum molecule) {
        return effects.containsKey(molecule);
    }

    public static List<PharmacologyEffect> getEffects(MoleculeEnum molecule) {
        return effects.get(molecule);
    }

    public static void applyEffect(MoleculeEnum molecule, EntityLivingBase entityLivingBase) {
        if (PharmacologyEffectRegistry.hasEffect(molecule)) {
            for (PharmacologyEffect effect : effects.get(molecule)) {
                if (effect instanceof PharmacologyEffect.Magic && ((PharmacologyEffect.Magic)effect).getPotion() == null) continue;
                effect.applyEffect(entityLivingBase);
            }
        }
    }

    public static List<PharmacologyEffect> removeEffects(MoleculeEnum molecule) {
        List<PharmacologyEffect> list = effects.get(molecule);
        effects.remove(molecule);
        return list;
    }

    public static void removeEffect(MoleculeEnum molecule, PharmacologyEffect effect) {
        if (PharmacologyEffectRegistry.hasEffect(molecule)) {
            effects.get(molecule).remove(effect);
        }
    }

    public static void init() {
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.water, (PharmacologyEffect)new PharmacologyEffect.Food(1, 0.1f));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.starch, (PharmacologyEffect)new PharmacologyEffect.Food(6, 0.2f));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.xylitol, (PharmacologyEffect)new PharmacologyEffect.Food(6, 0.2f));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.sucrose, (PharmacologyEffect)new PharmacologyEffect.Magic("speed", 1, 20));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.sucrose, (PharmacologyEffect)new PharmacologyEffect.Food(1, 0.1f));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.mycotoxin, (PharmacologyEffect)new PharmacologyEffect.Magic("wither", 7, 8));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.mycotoxin, (PharmacologyEffect)new PharmacologyEffect.Magic("weakness", 1, 12));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.ethanol, (PharmacologyEffect)new PharmacologyEffect.Magic("confusion", 5, 30));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.ethanol, (PharmacologyEffect)new PharmacologyEffect.Food(1, 0.1f));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.cyanide, (PharmacologyEffect)new PharmacologyEffect.Magic("wither", 3, 40));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.penicillin, (PharmacologyEffect)new PharmacologyEffect.Cure());
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.penicillin, (PharmacologyEffect)new PharmacologyEffect.Magic("regeneration", 3, 40));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.testosterone, (PharmacologyEffect)new PharmacologyEffect.Magic("strength", 20));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.testosterone, (PharmacologyEffect)new PharmacologyEffect.Magic("speed", 1, 20));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.xanax, (PharmacologyEffect)new PharmacologyEffect.Magic("confusion", 3, 30));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.xanax, (PharmacologyEffect)new PharmacologyEffect.Magic("speed", 1, 20));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.pantherine, (PharmacologyEffect)new PharmacologyEffect.Magic("confusion", 3, 30));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.pantherine, (PharmacologyEffect)new PharmacologyEffect.Magic("slowness", 2, 40));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.mescaline, (PharmacologyEffect)new PharmacologyEffect.Damage(2.0f));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.mescaline, (PharmacologyEffect)new PharmacologyEffect.Magic("confusion", 4, 60));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.mescaline, (PharmacologyEffect)new PharmacologyEffect.Magic("blindness", 4, 30));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.asprin, (PharmacologyEffect)new PharmacologyEffect.Cure());
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.asprin, (PharmacologyEffect)new PharmacologyEffect.Magic("regeneration", 1, 2));
        PharmacologyEffectRegistry.addEffect(Arrays.asList(MoleculeEnum.phosgene, MoleculeEnum.aalc, MoleculeEnum.sulfuricAcid, MoleculeEnum.buli), (PharmacologyEffect)new PharmacologyEffect.Burn(2));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.tetrodotoxin, (PharmacologyEffect)new PharmacologyEffect.Magic("slowness", 8, 5));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.tetrodotoxin, (PharmacologyEffect)new PharmacologyEffect.Magic("weakness", 1, 2));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.fingolimod, (PharmacologyEffect)new PharmacologyEffect.Magic("strength", 1, 60));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.fingolimod, (PharmacologyEffect)new PharmacologyEffect.Magic("speed", 1, 60));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.fingolimod, (PharmacologyEffect)new PharmacologyEffect.Magic("regeneration", 1, 60));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.fingolimod, (PharmacologyEffect)new PharmacologyEffect.Magic("hunger", 1, 300));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.nodularin, (PharmacologyEffect)new PharmacologyEffect.Magic("poison", 3, 30));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.nodularin, (PharmacologyEffect)new PharmacologyEffect.Magic("hunger", 3, 60));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.hist, (PharmacologyEffect)new PharmacologyEffect.Cure());
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.hist, (PharmacologyEffect)new PharmacologyEffect.Magic("confusion", 5, 20));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.pal2, (PharmacologyEffect)new PharmacologyEffect.Magic("slowness", 7, 5));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.pal2, (PharmacologyEffect)new PharmacologyEffect.Magic("wither", 5));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.theobromine, (PharmacologyEffect)new PharmacologyEffect.Magic("haste", 10, 30));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.theobromine, (PharmacologyEffect)new PharmacologyEffect.Magic("speed", 10, 30));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.retinol, (PharmacologyEffect)new PharmacologyEffect.Magic("night_vision", 5, 30));
        List<MoleculeEnum> aminoAcids = Arrays.asList(MoleculeEnum.glycine, MoleculeEnum.alinine, MoleculeEnum.arginine, MoleculeEnum.proline, MoleculeEnum.leucine, MoleculeEnum.isoleucine, MoleculeEnum.cysteine, MoleculeEnum.valine, MoleculeEnum.threonine, MoleculeEnum.histidine, MoleculeEnum.methionine, MoleculeEnum.tyrosine, MoleculeEnum.asparagine, MoleculeEnum.asparticAcid, MoleculeEnum.phenylalanine, MoleculeEnum.serine);
        PharmacologyEffectRegistry.addEffect(aminoAcids, (PharmacologyEffect)new PharmacologyEffect.Food(2, 0.1f));
        PharmacologyEffectRegistry.addEffect(aminoAcids, (PharmacologyEffect)new PharmacologyEffect.Magic("mining_fatigue", 1, 20));
        PharmacologyEffectRegistry.addEffect(aminoAcids, (PharmacologyEffect)new PharmacologyEffect.Magic("jump_boost", 1, 20));
        if (ModConfig.recreationalChemicalEffects) {
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.amphetamine, (PharmacologyEffect)new PharmacologyEffect.Damage(4.0f));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.amphetamine, (PharmacologyEffect)new PharmacologyEffect.Magic("confusion", 5, 20));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.amphetamine, (PharmacologyEffect)new PharmacologyEffect.Magic("speed", 15, 30));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.amphetamine, (PharmacologyEffect)new PharmacologyEffect.Magic(ModPotions.ATROPINE_HIGH.getRegistryName().toString(), 15, 30));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.cocaine, (PharmacologyEffect)new PharmacologyEffect.Damage(4.0f));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.cocaine, (PharmacologyEffect)new PharmacologyEffect.Magic("confusion", 5, 120));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.cocaine, (PharmacologyEffect)new PharmacologyEffect.Magic("speed", 12, 120));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.cocaine, (PharmacologyEffect)new PharmacologyEffect.Magic("night_vision", 5, 120));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.cocainehcl, (PharmacologyEffect)new PharmacologyEffect.Damage(4.0f));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.cocainehcl, (PharmacologyEffect)new PharmacologyEffect.Magic("confusion", 5, 60));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.cocainehcl, (PharmacologyEffect)new PharmacologyEffect.Magic("speed", 10, 60));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.cocainehcl, (PharmacologyEffect)new PharmacologyEffect.Magic("night_vision", 5, 60));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.dimethyltryptamine, (PharmacologyEffect)new PharmacologyEffect.Damage(2.0f));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.dimethyltryptamine, (PharmacologyEffect)new PharmacologyEffect.Magic("confusion", 5, 30));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.dimethyltryptamine, (PharmacologyEffect)new PharmacologyEffect.Magic("night_vision", 5, 60));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.methamphetamine, (PharmacologyEffect)new PharmacologyEffect.Damage(4.0f));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.methamphetamine, (PharmacologyEffect)new PharmacologyEffect.Magic("confusion", 5, 40));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.methamphetamine, (PharmacologyEffect)new PharmacologyEffect.Magic("speed", 7, 60));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.psilocybin, (PharmacologyEffect)new PharmacologyEffect.Damage(2.0f));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.psilocybin, (PharmacologyEffect)new PharmacologyEffect.Magic("confusion", 5, 10));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.psilocybin, (PharmacologyEffect)new PharmacologyEffect.Magic("night_vision", 5, 20));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.thc, (PharmacologyEffect)new PharmacologyEffect.Magic("confusion", 5, 60));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.thc, (PharmacologyEffect)new PharmacologyEffect.Magic("hunger", 20, 120));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.thc, (PharmacologyEffect)new PharmacologyEffect.Magic("slowness", 3, 60));
            PharmacologyEffectRegistry.addEffect(MoleculeEnum.thc, (PharmacologyEffect)new PharmacologyEffect.Magic("regeneration", 1, 60));
        }
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.metblue, (PharmacologyEffect)new PharmacologyEffect.Cure());
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.metblue, (PharmacologyEffect)new PharmacologyEffect.Magic("regeneration", 4, 30));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.metblue, (PharmacologyEffect)new PharmacologyEffect.Magic("weakness", 4, 30));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.meoh, (PharmacologyEffect)new PharmacologyEffect.Magic("blindness", 6, 20));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.meoh, (PharmacologyEffect)new PharmacologyEffect.Magic("wither", 2, 10));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.radchlor, (PharmacologyEffect)new PharmacologyEffect.Magic("weakness", 6, 120));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.radchlor, (PharmacologyEffect)new PharmacologyEffect.Magic("poison", 6, 20));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.radchlor, (PharmacologyEffect)new PharmacologyEffect.Magic("wither", 1, 30));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.caulerpenyne, (PharmacologyEffect)new PharmacologyEffect.Magic("weakness", 6, 2));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.caulerpenyne, (PharmacologyEffect)new PharmacologyEffect.Magic("confusion", 4, 2));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.latropine, (PharmacologyEffect)new PharmacologyEffect.Damage(4.0f));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.latropine, (PharmacologyEffect)new PharmacologyEffect.Magic("confusion", 2, 12));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.latropine, (PharmacologyEffect)new PharmacologyEffect.Magic("delirium", 1, 18));
        PharmacologyEffectRegistry.addEffect(MoleculeEnum.latropine, (PharmacologyEffect)new PharmacologyEffect.Magic("moveSlowdown", 2, 45));
    }
}

