/*
 * Decompiled with CFR 0.152.
 */
package minechem.potion;

import java.util.ArrayList;
import minechem.item.molecule.Molecule;
import minechem.item.molecule.MoleculeEnum;
import minechem.potion.PotionChemical;
import net.minecraft.client.resources.I18n;

public enum PotionMineralEnum {
    quartz(new Molecule(MoleculeEnum.siliconDioxide)),
    berlinite(new Molecule(MoleculeEnum.aluminiumPhosphate, 4));

    private final ArrayList<PotionChemical> components = new ArrayList();

    public PotionChemical[] getComposition() {
        return this.components.toArray(new PotionChemical[this.components.size()]);
    }

    public String getName() {
        String name = I18n.func_135052_a((String)("mineral." + this.name().toLowerCase()), (Object[])new Object[0]);
        if (name.length() == 8) {
            name = this.name().substring(0, 1).toUpperCase() + this.name().substring(1);
        }
        return this.name();
    }

    private PotionMineralEnum(PotionChemical ... chemicals) {
        for (PotionChemical potionChemical : chemicals) {
            this.components.add(potionChemical);
        }
    }
}

