/*
 * Decompiled with CFR 0.152.
 */
package minechem.recipe;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import minechem.api.IDecomposerControl;
import minechem.init.ModConfig;
import minechem.init.ModLogger;
import minechem.potion.PotionChemical;
import minechem.recipe.RecipeDecomposer;
import minechem.utils.MapKey;
import minechem.utils.MinechemUtil;
import minechem.utils.RecipeUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class RecipeDecomposerSuper
extends RecipeDecomposer {
    static Random random = new Random();
    public Map<MapKey, Double> recipes = new Hashtable<MapKey, Double>();

    public RecipeDecomposerSuper(@Nonnull ItemStack input, NonNullList<ItemStack> components, int level) {
        super(new PotionChemical[0]);
        this.input = input.func_77946_l();
        this.input.func_190920_e(1);
        ModLogger.debug(input.toString());
        for (ItemStack component : components) {
            RecipeUtil recipe;
            if (component.func_190926_b() || component.func_77973_b() == null || component.func_77973_b() instanceof IDecomposerControl && ((IDecomposerControl)component.func_77973_b()).getDecomposerMultiplier(component) == 0.0) continue;
            RecipeDecomposer decompRecipe = RecipeDecomposer.get(component);
            if (decompRecipe != null) {
                this.addDecompRecipe(decompRecipe, 1.0 / (double)Math.max(input.func_190916_E(), 1));
                continue;
            }
            if (component.func_77969_a(input) && component.func_77952_i() == input.func_77952_i() || (recipe = RecipeUtil.get(component)) == null || level >= ModConfig.recursiveDepth) continue;
            RecipeDecomposerSuper newSuper = new RecipeDecomposerSuper(recipe.output, recipe.inStacks, level + 1);
            RecipeDecomposer.add(newSuper);
            this.addDecompRecipe(newSuper, 1.0 / (double)recipe.getOutStackSize());
        }
    }

    private void addDecompRecipe(RecipeDecomposer decompRecipe, double d) {
        Double current;
        MapKey key = MapKey.getKey(decompRecipe.input);
        if (key != null && (current = this.recipes.put(key, d)) != null) {
            this.recipes.put(key, d + current);
        }
    }

    public RecipeDecomposerSuper(@Nonnull ItemStack input, NonNullList<ItemStack> components) {
        this(input, components, 0);
    }

    public RecipeDecomposerSuper(@Nonnull ItemStack input, NonNullList<ItemStack> components, ArrayList<PotionChemical> chemicals) {
        this(input, components, 0);
        this.addPotionChemical(chemicals);
    }

    private void addPotionChemical(ArrayList<PotionChemical> out) {
        if (out != null) {
            for (PotionChemical add : out) {
                super.addChemicals(add);
            }
        }
    }

    @Override
    public ArrayList<PotionChemical> getOutput() {
        ArrayList<PotionChemical> result = super.getOutput();
        for (MapKey currentKey : this.recipes.keySet()) {
            ArrayList<PotionChemical> partialResult;
            RecipeDecomposer current = RecipeDecomposer.get(currentKey);
            if (current == null) continue;
            Double i = this.recipes.get(currentKey);
            ModLogger.debug("getOutput :" + currentKey + " chance: " + i);
            while (i >= 1.0) {
                partialResult = current.getOutput();
                if (partialResult != null && partialResult.size() > 0) {
                    result.addAll(partialResult);
                }
                Double d = i;
                Double d2 = i = Double.valueOf(i - 1.0);
            }
            if (!(random.nextDouble() < i) || (partialResult = current.getOutput()) == null) continue;
            result.addAll(partialResult);
        }
        return result;
    }

    @Override
    public ArrayList<PotionChemical> getOutputRaw() {
        ArrayList<PotionChemical> result = super.getOutputRaw();
        for (MapKey currentKey : this.recipes.keySet()) {
            RecipeDecomposer current = RecipeDecomposer.get(currentKey);
            ModLogger.debug("getOutputRaw: " + currentKey);
            if (current == null) continue;
            int i = 0;
            while ((double)i < this.recipes.get(currentKey)) {
                ArrayList<PotionChemical> partialResult = current.getOutputRaw();
                if ((partialResult = MinechemUtil.pushTogetherChemicals(partialResult)) != null) {
                    result.addAll(partialResult);
                }
                ++i;
            }
        }
        return MinechemUtil.pushTogetherChemicals(result);
    }

    public ArrayList<PotionChemical> getGuaranteedOutput() {
        return super.getOutput();
    }

    @Override
    public boolean isNull() {
        return super.getOutput() == null || this.recipes == null || !this.hasOutput();
    }

    @Override
    public ArrayList<PotionChemical> getPartialOutputRaw(int f) {
        return super.getPartialOutputRaw(f);
    }

    @Override
    public boolean hasOutput() {
        if (!this.output.isEmpty()) {
            return true;
        }
        if (this.recipes.isEmpty()) {
            return false;
        }
        for (MapKey key : this.recipes.keySet()) {
            RecipeDecomposer recipe = RecipeDecomposer.get(key);
            if (recipe == null || recipe.isNull()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean outputContains(PotionChemical potionChemical) {
        boolean contains = super.outputContains(potionChemical);
        if (!contains) {
            for (MapKey key : this.recipes.keySet()) {
                RecipeDecomposer dr = RecipeDecomposer.get(key);
                ModLogger.debug("outputContains: " + key);
                if (dr == null || !(contains = dr.outputContains(potionChemical))) continue;
                break;
            }
        }
        return contains;
    }

    @Override
    public float getChance() {
        float chances = 1.0f;
        for (Map.Entry<MapKey, Double> entry : this.recipes.entrySet()) {
            RecipeDecomposer dr = RecipeDecomposer.get(entry.getKey());
            if (dr == null) continue;
            chances = (float)((double)chances * ((double)dr.getChance() / entry.getValue()));
        }
        return chances;
    }
}

