/*
 * Decompiled with CFR 0.152.
 */
package minechem.recipe;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import minechem.api.recipe.ISynthesisRecipe;
import minechem.potion.PotionChemical;
import minechem.recipe.SingleItemStackBasedIngredient;
import minechem.utils.MinechemUtil;
import minechem.utils.RadiationUtil;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeSynthesisShaped
extends IForgeRegistryEntry.Impl<ISynthesisRecipe>
implements ISynthesisRecipe {
    public static final String GROUP = "minechem:synthesis_shaped";
    private int energyCost = 0;
    public final NonNullList<SingleItemStackBasedIngredient> recipeItems;
    public final NonNullList<Ingredient> vanillaIngredients = NonNullList.func_191196_a();
    private final ItemStack recipeOutput;
    private final int recipeWidth;
    private final int recipeHeight;

    public RecipeSynthesisShaped(int width, int height, int energyCost, NonNullList<SingleItemStackBasedIngredient> ingredients, ItemStack result) {
        this.recipeItems = ingredients;
        for (SingleItemStackBasedIngredient ingredient : ingredients) {
            this.vanillaIngredients.add((Object)ingredient);
        }
        this.recipeOutput = result;
        this.energyCost = energyCost;
        this.recipeWidth = width;
        this.recipeHeight = height;
    }

    @Override
    public NonNullList<Ingredient> getIngredients() {
        return this.vanillaIngredients;
    }

    @Override
    public NonNullList<SingleItemStackBasedIngredient> getSingleIngredients() {
        return this.recipeItems;
    }

    public static MinechemShapedPrimer parseShaped(Object ... recipe) {
        MinechemShapedPrimer ret = new MinechemShapedPrimer();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            ret.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                ret.width = s.length();
                shape = shape + (String)s;
            }
            ret.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                ret.width = s.length();
                ++ret.height;
            }
        }
        if (ret.width * ret.height != shape.length() || shape.length() == 0) {
            String err = "Invalid shaped recipe: ";
            for (Object tmp : recipe) {
                err = err + tmp + ", ";
            }
            throw new RuntimeException(err);
        }
        HashMap itemMap = Maps.newHashMap();
        itemMap.put(Character.valueOf(' '), SingleItemStackBasedIngredient.EMPTY);
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            SingleItemStackBasedIngredient ing = RecipeSynthesisShaped.getIngredient(in);
            if (' ' == chr.charValue()) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            if (ing == null) {
                String err = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    err = err + tmp + ", ";
                }
                throw new RuntimeException(err);
            }
            itemMap.put(chr, ing);
            idx += 2;
        }
        ret.input = NonNullList.func_191197_a((int)(ret.width * ret.height), (Object)((Object)SingleItemStackBasedIngredient.EMPTY));
        HashSet keys = Sets.newHashSet(itemMap.keySet());
        keys.remove(Character.valueOf(' '));
        int x = 0;
        for (char chr : shape.toCharArray()) {
            SingleItemStackBasedIngredient ing = (SingleItemStackBasedIngredient)((Object)itemMap.get(Character.valueOf(chr)));
            if (ing == null) {
                throw new IllegalArgumentException("Pattern references symbol '" + chr + "' but it's not defined in the key");
            }
            ret.input.set(x++, (Object)ing);
            keys.remove(Character.valueOf(chr));
        }
        if (!keys.isEmpty()) {
            throw new IllegalArgumentException("Key defines symbols that aren't used in pattern: " + keys);
        }
        return ret;
    }

    public static SingleItemStackBasedIngredient getIngredient(Object obj) {
        if (obj instanceof PotionChemical) {
            PotionChemical chemical = (PotionChemical)obj;
            return SingleItemStackBasedIngredient.fromStack(MinechemUtil.chemicalToItemStack(chemical, chemical.amount));
        }
        return SingleItemStackBasedIngredient.EMPTY;
    }

    @Override
    public String getGroup() {
        return GROUP;
    }

    @Override
    public boolean matches(InventoryCrafting inv, World worldIn) {
        int i;
        HashMap<Integer, ItemStack> inputs = new HashMap<Integer, ItemStack>();
        HashMap<Integer, ItemStack> inputsR = new HashMap<Integer, ItemStack>();
        for (i = 0; i < inv.func_174923_h(); ++i) {
            for (int j = 0; j < inv.func_174922_i(); ++j) {
                ItemStack itemstack = inv.func_70463_b(j, i).func_77946_l();
                inputs.put(j + i * 3, itemstack);
            }
        }
        for (i = 0; i < this.recipeItems.size(); ++i) {
            ItemStack itemstack = ((SingleItemStackBasedIngredient)((Object)this.recipeItems.get(i))).getIngredientStack().func_77946_l();
            inputsR.put(i, itemstack);
        }
        boolean hasEnough = true;
        for (int i2 = 0; i2 < this.recipeItems.size(); ++i2) {
            ItemStack tmp2 = RadiationUtil.getStackWithoutRadiation(((ItemStack)inputs.get(i2)).func_77946_l());
            if (ItemStack.func_77989_b((ItemStack)((ItemStack)inputsR.get(i2)), (ItemStack)tmp2)) continue;
            hasEnough = false;
            break;
        }
        return hasEnough;
    }

    @Override
    public boolean isShaped() {
        return true;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inv) {
        return this.getRecipeOutput().func_77946_l();
    }

    @Override
    public boolean canFit(int width, int height) {
        return width == 3 && height == 3;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    @Override
    public int getEnergyCost() {
        return this.energyCost;
    }

    private boolean checkMatch(InventoryCrafting p_77573_1_, int p_77573_2_, int p_77573_3_, boolean p_77573_4_) {
        for (int i = 0; i < p_77573_1_.func_174922_i(); ++i) {
            for (int j = 0; j < p_77573_1_.func_174923_h(); ++j) {
                int k = i - p_77573_2_;
                int l = j - p_77573_3_;
                SingleItemStackBasedIngredient ingredient = SingleItemStackBasedIngredient.EMPTY;
                if (k >= 0 && l >= 0 && k < this.recipeWidth && l < this.recipeHeight) {
                    ingredient = p_77573_4_ ? (SingleItemStackBasedIngredient)((Object)this.recipeItems.get(this.recipeWidth - k - 1 + l * this.recipeWidth)) : (SingleItemStackBasedIngredient)((Object)this.recipeItems.get(k + l * this.recipeWidth));
                }
                if (ingredient.apply(p_77573_1_.func_70463_b(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    public static class MinechemShapedPrimer {
        public int height;
        public int width;
        public boolean mirrored = true;
        public NonNullList<SingleItemStackBasedIngredient> input;
    }
}

