/*
 * Decompiled with CFR 0.152.
 */
package minechem.recipe;

import minechem.api.recipe.ISynthesisRecipe;
import minechem.recipe.SingleItemStackBasedIngredient;
import minechem.recipe.handler.RecipeHandlerSynthesis;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeSynthesisShapeless
extends IForgeRegistryEntry.Impl<ISynthesisRecipe>
implements ISynthesisRecipe {
    public static final String GROUP = "minechem:synthesis_shapeless";
    private int energyCost = 0;
    private final boolean isSimple;
    private final ItemStack recipeOutput;
    public final NonNullList<Ingredient> vanillaIngredients = NonNullList.func_191196_a();
    public final NonNullList<SingleItemStackBasedIngredient> recipeItems;

    public RecipeSynthesisShapeless(ItemStack output, int energyCost, NonNullList<SingleItemStackBasedIngredient> ingredients) {
        this.energyCost = energyCost;
        this.recipeItems = ingredients;
        this.recipeOutput = output;
        for (SingleItemStackBasedIngredient ingredient : ingredients) {
            this.vanillaIngredients.add((Object)ingredient);
        }
        boolean simple = true;
        for (SingleItemStackBasedIngredient i : ingredients) {
            simple &= i.isSimple();
        }
        this.isSimple = simple;
    }

    @Override
    public int getEnergyCost() {
        return this.energyCost;
    }

    @Override
    public NonNullList<SingleItemStackBasedIngredient> getSingleIngredients() {
        return this.recipeItems;
    }

    @Override
    public String getGroup() {
        return GROUP;
    }

    @Override
    public boolean matches(InventoryCrafting inv, World worldIn) {
        int ingredientCount = 0;
        NonNullList inputs = NonNullList.func_191196_a();
        for (int i = 0; i < inv.func_174923_h(); ++i) {
            for (int j = 0; j < inv.func_174922_i(); ++j) {
                ItemStack itemstack = inv.func_70463_b(j, i);
                if (itemstack.func_190926_b()) continue;
                ++ingredientCount;
                if (this.isSimple) {
                    // empty if block
                }
                inputs.add((Object)itemstack);
            }
        }
        if (ingredientCount != this.recipeItems.size()) {
            return false;
        }
        if (this.isSimple) {
            // empty if block
        }
        return RecipeHandlerSynthesis.itemStacksMatchesShapelessRecipe((NonNullList<ItemStack>)inputs, this, 1);
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inv) {
        return this.getRecipeOutput().func_77946_l();
    }

    @Override
    public boolean canFit(int width, int height) {
        return width >= 1 && width <= 3 && height >= 1 && height <= 3;
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }
}

