/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import minechem.block.fluid.BlockFluidMinechem;
import minechem.fluid.FluidElement;
import minechem.fluid.FluidMinechem;
import minechem.fluid.FluidMolecule;
import minechem.init.ModConfig;
import minechem.init.ModFluids;
import minechem.init.ModItems;
import minechem.init.ModLogger;
import minechem.item.ItemElement;
import minechem.item.ItemMolecule;
import minechem.item.MinechemChemicalType;
import minechem.item.element.Element;
import minechem.item.element.ElementEnum;
import minechem.item.molecule.Molecule;
import minechem.item.molecule.MoleculeEnum;
import minechem.potion.PotionChemical;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public final class MinechemUtil {
    public static final Random random = new Random();

    private MinechemUtil() {
    }

    public static ItemStack addItemToInventory(IInventory inventory, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int l = inventory.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) {
                int append = itemStack.func_190916_E() > inventory.func_70297_j_() ? inventory.func_70297_j_() : itemStack.func_190916_E();
                ItemStack newStack = itemStack.func_77946_l();
                newStack.func_190920_e(append);
                inventory.func_70299_a(i, newStack);
                itemStack.func_190918_g(append);
            } else if (stack.func_77973_b() == itemStack.func_77973_b() && stack.func_77952_i() == itemStack.func_77952_i()) {
                int free = inventory.func_70297_j_() - stack.func_190916_E();
                int append = itemStack.func_190916_E() > free ? free : itemStack.func_190916_E();
                itemStack.func_190918_g(append);
                stack.func_190917_f(append);
                inventory.func_70299_a(i, stack);
            }
            if (itemStack.func_190916_E() > 0) continue;
            itemStack = ItemStack.field_190927_a;
            break;
        }
        return itemStack;
    }

    public static void throwItemStack(World world, ItemStack stack, BlockPos pos) {
        MinechemUtil.throwItemStack(world, stack, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void throwItemStack(World world, ItemStack itemStack, double x, double y, double z) {
        if (!itemStack.func_190926_b()) {
            float f = random.nextFloat() * 0.8f + 0.1f;
            float f1 = random.nextFloat() * 0.8f + 0.1f;
            float f2 = random.nextFloat() * 0.8f + 0.1f;
            EntityItem entityitem = new EntityItem(world, (double)((float)x + f), (double)((float)y + f1), (double)((float)z + f2), itemStack);
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)random.nextGaussian() * f3;
            entityitem.field_70181_x = (float)random.nextGaussian() * f3 + 0.2f;
            entityitem.field_70179_y = (float)random.nextGaussian() * f3;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static ItemStack createItemStack(MinechemChemicalType chemical, int amount) {
        ItemStack itemStack = ItemStack.field_190927_a;
        if (chemical instanceof ElementEnum) {
            itemStack = ItemElement.createStackOf(ElementEnum.getByID(((ElementEnum)chemical).atomicNumber()), amount);
        } else if (chemical instanceof MoleculeEnum) {
            itemStack = new ItemStack((Item)ModItems.molecule, amount, ((MoleculeEnum)chemical).id());
        }
        return itemStack;
    }

    public static boolean canDrain(World world, Block block, int x, int y, int z) {
        if ((block == Blocks.field_150355_j || block == Blocks.field_150358_i) && world.func_180495_p(new BlockPos(x, y, z)).func_177230_c().func_176201_c(world.func_180495_p(new BlockPos(x, y, z))) == 0) {
            return true;
        }
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).canDrain(world, new BlockPos(x, y, z));
        }
        return false;
    }

    public static MinechemChemicalType getChemical(Block block) {
        MinechemChemicalType chemical = null;
        if (block instanceof IFluidBlock) {
            Fluid fluid = ((IFluidBlock)block).getFluid();
            chemical = MinechemUtil.getChemical(fluid);
        } else if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            chemical = MoleculeEnum.water;
        }
        return chemical;
    }

    public static MinechemChemicalType getChemical(Fluid fluid) {
        if (fluid instanceof FluidElement) {
            return ((FluidElement)fluid).element;
        }
        if (fluid instanceof FluidMolecule) {
            return ((FluidMolecule)fluid).molecule;
        }
        if (fluid == FluidRegistry.WATER) {
            return MoleculeEnum.water;
        }
        return null;
    }

    public static ElementEnum getElement(Fluid fluid) {
        for (Map.Entry<ElementEnum, FluidElement> entry : ModFluids.FLUID_ELEMENTS.entrySet()) {
            if (entry.getValue() != fluid) continue;
            return entry.getKey();
        }
        return null;
    }

    public static MoleculeEnum getMolecule(Fluid fluid) {
        for (Map.Entry<MoleculeEnum, Fluid> entry : ModFluids.FLUID_MOLECULES.entrySet()) {
            if (entry.getValue() != fluid) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Fluid getFluid(TileEntity te) {
        if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return ((IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).getTankProperties()[0].getContents().getFluid();
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Fluid fluid;
            if (!te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing) || (fluid = ((IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)).getTankProperties()[0].getContents().getFluid()) == null) continue;
            return fluid;
        }
        return null;
    }

    public static void incPlayerInventory(ItemStack current, int inc, EntityPlayer player, ItemStack give) {
        if (inc < 0) {
            current.func_77979_a(-inc);
        } else if (inc > 0) {
            if (current.func_190916_E() + inc <= current.func_77976_d()) {
                current.func_190917_f(inc);
            } else {
                int added = current.func_77976_d() - current.func_190916_E();
                current.func_190920_e(current.func_77976_d());
                ItemStack extraStack = current.func_77946_l();
                extraStack.func_190920_e(inc - added);
                if (!player.field_71071_by.func_70441_a(extraStack)) {
                    player.func_71019_a(extraStack, false);
                }
            }
        }
        if (!player.field_71071_by.func_70441_a(give)) {
            player.func_71019_a(give, false);
        }
    }

    public static Set<ItemStack> findItemStacks(IInventory inventory, Item item, int damage) {
        HashSet<ItemStack> stacks = new HashSet<ItemStack>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item || stack.func_77952_i() != damage) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public static void removeStackInInventory(IInventory inventory, ItemStack stack) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (stack != inventory.func_70301_a(i)) continue;
            inventory.func_70299_a(i, ItemStack.field_190927_a);
            break;
        }
    }

    public static String subscriptNumbers(String string) {
        string = string.replace('0', '\u2080');
        string = string.replace('1', '\u2081');
        string = string.replace('2', '\u2082');
        string = string.replace('3', '\u2083');
        string = string.replace('4', '\u2084');
        string = string.replace('5', '\u2085');
        string = string.replace('6', '\u2086');
        string = string.replace('7', '\u2087');
        string = string.replace('8', '\u2088');
        string = string.replace('9', '\u2089');
        return string;
    }

    public static void addDisabledStacks(String[] stringInputs, NonNullList<ItemStack> decomposerBlacklist, ArrayList<String> ids) {
        for (String string : stringInputs) {
            int meta;
            if (string == null || string.equals("")) continue;
            String[] splitString = string.split(":");
            ArrayList<String> wildcardMatch = new ArrayList<String>();
            if (splitString.length < 2 || splitString.length > 3) {
                ModLogger.debug(string + " is an invalid blacklist input");
                continue;
            }
            if (splitString[0].equals("ore")) {
                String itemID = splitString[1];
                if (itemID.contains("*")) {
                    itemID = itemID.replaceAll("\\*", ".*");
                }
                Pattern itemPattern = Pattern.compile(itemID, 2);
                for (String item : OreDictionary.getOreNames()) {
                    if (!itemPattern.matcher(item).matches()) continue;
                    wildcardMatch.add(item);
                }
                if (wildcardMatch.isEmpty()) {
                    ModLogger.debug(splitString[1] + " has no matches in the OreDictionary");
                    continue;
                }
                for (String key : wildcardMatch) {
                    decomposerBlacklist.addAll((Collection)OreDictionary.getOres((String)key));
                }
                continue;
            }
            try {
                meta = splitString.length == 3 ? Integer.valueOf(splitString[2]) : Short.MAX_VALUE;
            }
            catch (NumberFormatException e) {
                if (splitString[2].equals("*")) {
                    meta = Short.MAX_VALUE;
                }
                ModLogger.debug(splitString[2] + " is an invalid damage value - defaulting to all values");
                meta = Short.MAX_VALUE;
            }
            String itemID = splitString[0] + ":" + splitString[1];
            if (itemID.contains("*")) {
                itemID = itemID.replaceAll("\\*", ".*");
            }
            Pattern itemPattern = Pattern.compile(itemID, 2);
            for (String item : ids) {
                if (!itemPattern.matcher(item).matches()) continue;
                wildcardMatch.add(item);
            }
            if (wildcardMatch.isEmpty()) {
                ModLogger.debug(string + " has no matches in the ItemRegistry");
                continue;
            }
            for (String key : wildcardMatch) {
                Object disable = Item.field_150901_e.func_82594_a((Object)new ResourceLocation(key));
                if (disable instanceof Item) {
                    decomposerBlacklist.add((Object)new ItemStack((Item)disable, 1, meta));
                    continue;
                }
                if (!(disable instanceof Block)) continue;
                decomposerBlacklist.add((Object)new ItemStack((Block)disable, 1, meta));
            }
        }
    }

    public static void populateBlacklists() {
        ModConfig.decomposerBlacklist.add((Object)ModItems.emptyTube);
        ArrayList<String> registeredItems = new ArrayList<String>();
        for (ResourceLocation key : Item.field_150901_e.func_148742_b()) {
            registeredItems.add(key.toString());
        }
        MinechemUtil.addDisabledStacks(ModConfig.DecomposerBlacklist, ModConfig.decomposerBlacklist, registeredItems);
        MinechemUtil.addDisabledStacks(ModConfig.SynthesisMachineBlacklist, ModConfig.synthesisBlacklist, registeredItems);
    }

    @SideOnly(value=Side.CLIENT)
    public static int getSplitStringHeight(FontRenderer fontRenderer, String string, int width) {
        List stringRows = fontRenderer.func_78271_c(string, width);
        return stringRows.size() * fontRenderer.field_78288_b;
    }

    public static float translateValue(float value, float leftMin, float leftMax, float rightMin, float rightMax) {
        float leftRange = leftMax - leftMin;
        float rightRange = rightMax - rightMin;
        float valueScaled = (value - leftMin) / leftRange;
        return rightMin + valueScaled * rightRange;
    }

    public static String getLocalString(String key) {
        return MinechemUtil.getLocalString(key, false);
    }

    public static String getLocalString(String key, boolean capitalize) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            String localString = I18n.func_74838_a((String)key);
            return capitalize ? MinechemUtil.capitalizeFully(localString.replaceAll("molecule\\.", "")) : localString;
        }
        return key;
    }

    public static String capitalizeFully(String input) {
        String[] splitString = input.split(" ");
        String result = "";
        for (int i = 0; i < splitString.length; ++i) {
            char[] digit = splitString[i].toCharArray();
            if (digit.length < 1) continue;
            digit[0] = Character.toUpperCase(digit[0]);
            for (int j = 1; j < digit.length; ++j) {
                digit[j] = Character.toLowerCase(digit[j]);
            }
            result = result + new String(digit) + (i < splitString.length - 1 ? " " : "");
        }
        return result;
    }

    public static NBTTagList writeItemStackListToTagList(NonNullList<ItemStack> list) {
        NBTTagList taglist = new NBTTagList();
        for (ItemStack itemstack : list) {
            NBTTagCompound itemstackCompound = new NBTTagCompound();
            itemstack.func_77955_b(itemstackCompound);
            taglist.func_74742_a((NBTBase)itemstackCompound);
        }
        return taglist;
    }

    public static NonNullList<ItemStack> readTagListToItemStackList(NBTTagList taglist) {
        NonNullList itemlist = NonNullList.func_191197_a((int)taglist.func_74745_c(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < taglist.func_74745_c(); ++i) {
            NBTTagCompound itemstackCompound = taglist.func_150305_b(i);
            ItemStack itemstack = new ItemStack(itemstackCompound);
            itemlist.set(i, (Object)itemstack);
        }
        return itemlist;
    }

    public static NonNullList<ItemStack> convertChemicalsIntoItemStacks(List<PotionChemical> potionChemicals) {
        return MinechemUtil.convertChemicalsIntoItemStacks(potionChemicals.toArray(new PotionChemical[potionChemicals.size()]));
    }

    public static NonNullList<ItemStack> convertChemicalsIntoItemStacks(PotionChemical[] potionChemicals) {
        if (potionChemicals != null && potionChemicals.length > 0) {
            NonNullList stacks = NonNullList.func_191197_a((int)potionChemicals.length, (Object)ItemStack.field_190927_a);
            if (potionChemicals != null && potionChemicals.length > 0) {
                for (int i = 0; i < potionChemicals.length; ++i) {
                    PotionChemical potionChemical = potionChemicals[i];
                    if (potionChemical instanceof Element && ((Element)potionChemical).element != null) {
                        stacks.set(i, (Object)new ItemStack((Item)ModItems.element, potionChemical.amount, ((Element)potionChemical).element.atomicNumber()));
                        continue;
                    }
                    if (!(potionChemical instanceof Molecule) || ((Molecule)potionChemical).molecule == null) continue;
                    stacks.set(i, (Object)new ItemStack((Item)ModItems.molecule, potionChemical.amount, ((Molecule)potionChemical).molecule.id()));
                }
            }
            return stacks;
        }
        return NonNullList.func_191196_a();
    }

    public static NonNullList<ItemStack> copyStackList(NonNullList<ItemStack> stackList) {
        NonNullList newStackList = NonNullList.func_191196_a();
        for (ItemStack stack : stackList) {
            newStackList.add((Object)stack.func_77946_l());
        }
        return newStackList;
    }

    public static boolean isStackListEmpty(NonNullList<ItemStack> stackList) {
        for (ItemStack stack : stackList) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static ArrayList<PotionChemical> pushTogetherChemicals(ArrayList<PotionChemical> oldList) {
        ArrayList<PotionChemical> list = new ArrayList<PotionChemical>();
        for (PotionChemical chemical : oldList) {
            list.add(chemical.copy());
        }
        block1: for (int i = list.size() - 1; i >= 0; --i) {
            if (list.get(i) == null) continue;
            for (int j = 0; j < i; ++j) {
                if (list.get(j) == null) {
                    list.set(j, list.get(i));
                    list.set(j, null);
                    continue block1;
                }
                if (!list.get(j).sameAs(list.get(i))) continue;
                list.get((int)j).amount += list.get((int)i).amount;
                list.set(i, null);
                continue block1;
            }
        }
        list.removeAll(Collections.singleton(null));
        return list;
    }

    public static boolean itemStackMatchesChemical(ItemStack itemstack, PotionChemical potionChemical) {
        return MinechemUtil.itemStackMatchesChemical(itemstack, potionChemical, 1);
    }

    public static boolean itemStackMatchesChemical(ItemStack itemstack, PotionChemical potionChemical, int factor) {
        if (potionChemical instanceof Element && itemstack.func_77973_b() == ModItems.element) {
            Element element = (Element)potionChemical;
            return itemstack.func_77952_i() == element.element.atomicNumber() && itemstack.func_190916_E() >= element.amount * factor;
        }
        if (potionChemical instanceof Molecule && itemstack.func_77973_b() == ModItems.molecule) {
            Molecule molecule = (Molecule)potionChemical;
            return itemstack.func_77952_i() == molecule.molecule.id() && itemstack.func_190916_E() >= molecule.amount * factor;
        }
        return false;
    }

    public static ItemStack chemicalToItemStack(PotionChemical potionChemical, int amount) {
        if (potionChemical instanceof Element) {
            return new ItemStack((Item)ModItems.element, amount, ((Element)potionChemical).element.atomicNumber());
        }
        if (potionChemical instanceof Molecule) {
            return new ItemStack((Item)ModItems.molecule, amount, ((Molecule)potionChemical).molecule.id());
        }
        return ItemStack.field_190927_a;
    }

    public static PotionChemical[] stackListToChemicalArray(List<ItemStack> stackList) {
        PotionChemical[] chemicalList = new PotionChemical[stackList.size()];
        for (int i = 0; i < stackList.size(); ++i) {
            chemicalList[i] = MinechemUtil.itemStackToChemical(stackList.get(i));
        }
        return chemicalList;
    }

    public static PotionChemical itemStackToChemical(@Nonnull ItemStack itemstack) {
        if (MinechemUtil.isStackAnElement(itemstack)) {
            if (itemstack.func_77952_i() == 0) {
                return null;
            }
            return new Element(MinechemUtil.getElement(itemstack), itemstack.func_190916_E());
        }
        if (MinechemUtil.isStackAMolecule(itemstack)) {
            return new Molecule(MinechemUtil.getMolecule(itemstack), itemstack.func_190916_E());
        }
        return null;
    }

    public static ItemStack getBucketForChemical(MinechemChemicalType type) {
        for (Block block : ModFluids.getFluidBlocks()) {
            if (!(block instanceof BlockFluidMinechem) || !(((BlockFluidMinechem)block).getFluid() instanceof FluidMinechem)) continue;
            BlockFluidMinechem fluidBlock = (BlockFluidMinechem)block;
            MinechemChemicalType blockType = ((FluidMinechem)fluidBlock.getFluid()).getChemical();
            if (blockType instanceof MoleculeEnum && ((MoleculeEnum)blockType).name().equals("water")) {
                return new ItemStack(Items.field_151131_as);
            }
            if (type != blockType) continue;
            return FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluidBlock.getFluid(), 1000));
        }
        return ItemStack.field_190927_a;
    }

    public static ElementEnum getElement(ItemStack stack) {
        return stack.func_77973_b() == ModItems.element && stack.func_77952_i() != 0 ? ElementEnum.getByID(stack.func_77952_i()) : null;
    }

    public static MoleculeEnum getMolecule(ItemStack itemstack) {
        int itemDamage = itemstack.func_77952_i();
        MoleculeEnum mol = MoleculeEnum.getById(itemDamage);
        if (mol == null) {
            itemstack.func_77964_b(0);
            mol = MoleculeEnum.getById(0);
        }
        return mol;
    }

    public static ItemStack getBucketForFluid(Fluid fluid) {
        return FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000));
    }

    public static int getElementIDFromBucket(@Nonnull ItemStack bucket) {
        FluidElement fluidElement;
        Fluid fluid;
        if (bucket.func_77973_b() instanceof UniversalBucket && (fluid = ((UniversalBucket)bucket.func_77973_b()).getFluid(bucket).getFluid()) instanceof FluidElement && (fluidElement = (FluidElement)fluid).getChemical() instanceof ElementEnum) {
            return ((ElementEnum)fluidElement.getChemical()).atomicNumber();
        }
        return -1;
    }

    public static int getMoleculeIDFromBucket(@Nonnull ItemStack bucket) {
        FluidMolecule fluidElement;
        Fluid fluid;
        if (bucket.func_77973_b() instanceof UniversalBucket && (fluid = ((UniversalBucket)bucket.func_77973_b()).getFluid(bucket).getFluid()) instanceof FluidMolecule && (fluidElement = (FluidMolecule)fluid).getChemical() instanceof MoleculeEnum) {
            return ((MoleculeEnum)fluidElement.getChemical()).id();
        }
        return -1;
    }

    public static MinechemChemicalType getChemicalTypeFromBucket(@Nonnull ItemStack bucket) {
        Fluid fluid;
        if (bucket.func_77973_b() instanceof UniversalBucket && (fluid = ((UniversalBucket)bucket.func_77973_b()).getFluid(bucket).getFluid()) instanceof FluidMinechem) {
            return ((FluidMinechem)fluid).getChemical();
        }
        return null;
    }

    public static void openURL(String url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(url));
        }
        catch (Throwable throwable) {
            ModLogger.debug("Couldn't open link: " + url);
        }
    }

    public static boolean stacksAreSameKind(ItemStack is1, ItemStack is2) {
        boolean damageMatters = false;
        if (MinechemUtil.isStackAnElement(is1) && MinechemUtil.isStackAnElement(is2)) {
            damageMatters = true;
        }
        int dmg1 = is1.func_77952_i();
        int dmg2 = is2.func_77952_i();
        if (damageMatters && dmg1 != dmg2) {
            return false;
        }
        NBTTagCompound nbt1 = is1.serializeNBT();
        NBTTagCompound nbt2 = is2.serializeNBT();
        boolean sameNBT = true;
        if (nbt1 != null && nbt2 != null) {
            sameNBT = nbt1.equals((Object)nbt2);
        }
        return is1.func_77973_b() == is2.func_77973_b() && sameNBT;
    }

    public static boolean isStackAChemical(ItemStack itemstack) {
        return itemstack.func_77973_b() instanceof ItemElement || itemstack.func_77973_b() instanceof ItemMolecule;
    }

    public static boolean isStackAnElement(ItemStack itemstack) {
        return itemstack.func_77973_b() instanceof ItemElement && !MinechemUtil.isStackAnEmptyTestTube(itemstack);
    }

    public static boolean isStackAMolecule(ItemStack itemstack) {
        return itemstack.func_77973_b() instanceof ItemMolecule && !MinechemUtil.isStackAnEmptyTestTube(itemstack);
    }

    public static boolean isStackAnEmptyTestTube(ItemStack itemstack) {
        return itemstack.toString().contains("minechem.itemTestTube");
    }

    public static String stringSieve(String str) {
        return str.toLowerCase().trim().replaceAll("\\s", "").replaceAll("block", "").replaceAll("item", "");
    }
}

