/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import minechem.init.ModItems;
import minechem.item.element.ElementEnum;
import minechem.item.molecule.MoleculeEnum;
import minechem.radiation.RadiationEnum;
import minechem.utils.MinechemUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.UniversalBucket;

public class RadiationUtil
implements Cloneable {
    public long decayStarted;
    public long lastDecayUpdate;
    public int radiationDamage;
    public int dimensionID;
    public ItemStack itemstack;
    public RadiationEnum radioactivity;

    public RadiationUtil(ItemStack itemstack, long decayStarted, long lastDecayUpdate, int dimensionID, RadiationEnum radioactivity) {
        this.itemstack = itemstack;
        this.decayStarted = decayStarted;
        this.dimensionID = dimensionID;
        this.lastDecayUpdate = lastDecayUpdate;
        this.radioactivity = radioactivity;
    }

    public RadiationUtil(ItemStack itemstack, RadiationEnum radioactivity) {
        this.itemstack = itemstack;
        this.radioactivity = radioactivity;
        this.decayStarted = 0L;
        this.dimensionID = 0;
        this.lastDecayUpdate = 0L;
    }

    public boolean isRadioactive() {
        return this.radioactivity != RadiationEnum.stable;
    }

    public RadiationUtil clone() {
        return new RadiationUtil(this.itemstack.func_77946_l(), this.decayStarted, this.lastDecayUpdate, this.dimensionID, this.radioactivity);
    }

    public static RadiationEnum getRadioactivity(ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        if (item == ModItems.element) {
            int id = itemstack.func_77952_i();
            ElementEnum element = ElementEnum.getByID(id);
            return id != 0 && element != null ? element.radioactivity() : RadiationEnum.stable;
        }
        if (item == ModItems.molecule) {
            int id = itemstack.func_77952_i();
            if (id >= MoleculeEnum.molecules.size() || MoleculeEnum.molecules.get(id) == null) {
                return RadiationEnum.stable;
            }
            return MoleculeEnum.molecules.get(id).radioactivity();
        }
        if (item instanceof UniversalBucket) {
            return MinechemUtil.getChemicalTypeFromBucket(itemstack).radioactivity();
        }
        return RadiationEnum.stable;
    }

    public static void setRadiationInfo(RadiationUtil radiationInfo, ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74772_a("lastUpdate", radiationInfo.lastDecayUpdate);
        nbt.func_74772_a("decayStart", radiationInfo.decayStarted);
        nbt.func_74768_a("dimensionID", radiationInfo.dimensionID);
        stack.func_77982_d(nbt);
    }

    public static ItemStack getStackWithoutRadiation(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt.func_150297_b("lastUpdate", 4)) {
                nbt.func_82580_o("lastUpdate");
            }
            if (nbt.func_150297_b("decayStart", 4)) {
                nbt.func_82580_o("decayStart");
            }
            if (nbt.func_150297_b("dimensionID", 3)) {
                nbt.func_82580_o("dimensionID");
            }
            ItemStack returnStack = stack.func_77946_l();
            if (nbt.func_82582_d()) {
                returnStack.func_77982_d(null);
            } else {
                returnStack.func_77982_d(nbt);
            }
            return returnStack;
        }
        return stack;
    }
}

