/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import minechem.api.recipe.ISynthesisRecipe;
import minechem.init.ModLogger;
import minechem.potion.PotionChemical;
import minechem.recipe.RecipeDecomposer;
import minechem.recipe.SingleItemStackBasedIngredient;
import minechem.utils.MapKey;
import minechem.utils.MinechemUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.RegistryManager;

public class RecipeUtil {
    public static Map<MapKey, RecipeUtil> recipes = new LinkedHashMap<MapKey, RecipeUtil>();
    public static Map<ItemStack, ItemStack> smelting;
    public ItemStack output = ItemStack.field_190927_a;
    public NonNullList<ItemStack> inStacks = NonNullList.func_191196_a();
    private int depth;
    private static final int MAXDEPTH = 20;

    @Optional.Method(modid="RotaryCraft")
    public static List getRotaryRecipes() {
        try {
            boolean add;
            Class<?> worktable = Class.forName("Reika.RotaryCraft.Auxiliary.WorktableRecipes");
            Method instance = worktable.getMethod("getInstance", new Class[0]);
            Method list = worktable.getMethod("getRecipeListCopy", new Class[0]);
            Class<?> config = Class.forName("Reika.RotaryCraft.Registry.ConfigRegistry");
            Method state = config.getMethod("getState", new Class[0]);
            boolean bl = add = (Boolean)state.invoke(Enum.valueOf(config, "TABLEMACHINES"), new Object[0]) == false;
            if (add) {
                return (List)list.invoke(instance.invoke(null, new Object[0]), new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Optional.Method(modid="Railcraft")
    public static List getRailcraftRecipes() {
        try {
            Class<?> rollingMachine = Class.forName("mods.railcraft.common.util.crafting.RollingMachineCraftingManager");
            Method instance = rollingMachine.getMethod("getInstance", new Class[0]);
            Method list = rollingMachine.getMethod("getRecipeList", new Class[0]);
            return (List)list.invoke(instance.invoke(null, new Object[0]), new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void init() {
        List add;
        Hashtable<MapKey, ArrayList<RecipeUtil>> preCullRecipes = new Hashtable<MapKey, ArrayList<RecipeUtil>>();
        recipes = new LinkedHashMap<MapKey, RecipeUtil>();
        smelting = FurnaceRecipes.func_77602_a().func_77599_b();
        Collection craftingRecipes = ForgeRegistries.RECIPES.getValuesCollection();
        if (Loader.isModLoaded((String)"RotaryCraft") && (add = RecipeUtil.getRotaryRecipes()) != null) {
            craftingRecipes.addAll(add);
        }
        if (Loader.isModLoaded((String)"Railcaft") && (add = RecipeUtil.getRailcraftRecipes()) != null) {
            craftingRecipes.addAll(add);
        }
        for (Object e : craftingRecipes) {
            ItemStack input;
            if (!(e instanceof IRecipe) || RecipeUtil.invalidStack(input = ((IRecipe)e).func_77571_b())) continue;
            ModLogger.debug("Adding recipe for " + input.toString());
            NonNullList components = NonNullList.func_191196_a();
            NonNullList inputs = NonNullList.func_191196_a();
            if (e.getClass().equals(ShapelessOreRecipe.class) && ((ShapelessOreRecipe)e).func_192400_c().size() > 0) {
                for (Object o : ((ShapelessOreRecipe)e).func_192400_c()) {
                    if (!(o instanceof ItemStack)) continue;
                    inputs.add((Object)((ItemStack)o));
                }
            } else if (e.getClass().equals(ShapedOreRecipe.class)) {
                for (Object o : ((ShapedOreRecipe)e).func_192400_c()) {
                    if (o instanceof ItemStack) {
                        inputs.add((Object)((ItemStack)o));
                        continue;
                    }
                    if (o instanceof String) {
                        inputs.add(OreDictionary.getOres((String)((String)o)).get(0));
                        continue;
                    }
                    if (!(o instanceof ArrayList) || ((ArrayList)o).isEmpty()) continue;
                    inputs.add((Object)((ItemStack)((ArrayList)o).get(0)));
                }
            } else if (e.getClass().equals(ShapelessRecipes.class) && ((ShapelessRecipes)e).field_77579_b.toArray() instanceof ItemStack[]) {
                inputs = ((ShapelessRecipes)e).field_77579_b;
            } else if (e.getClass().equals(ShapedRecipes.class)) {
                for (Ingredient inputStack : ((ShapedRecipes)e).field_77574_d) {
                    inputs.addAll(Arrays.asList(inputStack.func_193365_a()));
                }
            }
            MapKey key = MapKey.getKey(input);
            if (inputs.size() <= 0 || key == null) continue;
            Iterator itr = inputs.iterator();
            while (itr.hasNext()) {
                ItemStack component = (ItemStack)itr.next();
                if (!RecipeUtil.invalidStack(component) && !component.func_77973_b().hasContainerItem(component)) continue;
                itr.remove();
            }
            components = inputs;
            if (components.size() <= 0) continue;
            RecipeUtil addRecipe = new RecipeUtil(input, (NonNullList<ItemStack>)components);
            RecipeUtil.addPreCullRecipe(key, addRecipe, preCullRecipes);
        }
        for (ItemStack itemStack : smelting.keySet()) {
            MapKey key;
            ItemStack output = smelting.get(itemStack);
            if (RecipeUtil.invalidStack(itemStack) || RecipeUtil.invalidStack(output) || (key = MapKey.getKey(output)) == null) continue;
            RecipeUtil addRecipe = new RecipeUtil(output, (NonNullList<ItemStack>)NonNullList.func_191197_a((int)1, (Object)itemStack));
            ModLogger.debug("Adding Smelting recipe for " + output.toString());
            RecipeUtil.addPreCullRecipe(key, addRecipe, preCullRecipes);
        }
        for (Map.Entry entry : preCullRecipes.entrySet()) {
            if (entry.getValue() != null && ((ArrayList)entry.getValue()).size() > 0) {
                ModLogger.debug("Culling recipe for " + ((RecipeUtil)((ArrayList)entry.getValue()).get((int)0)).output.toString());
            }
            int depth = RecipeUtil.cullRecipes(entry, preCullRecipes);
            if (((ArrayList)entry.getValue()).size() != 1) continue;
            RecipeUtil addRecipe = (RecipeUtil)((ArrayList)entry.getValue()).get(0);
            addRecipe.depth = depth;
            recipes.put((MapKey)entry.getKey(), addRecipe);
        }
    }

    private static boolean invalidStack(ItemStack stack) {
        return stack.func_190926_b() || stack.func_77973_b() == null || stack.func_190916_E() < 1 || stack.func_77952_i() < 0;
    }

    private static void addPreCullRecipe(MapKey key, RecipeUtil addRecipe, Map<MapKey, ArrayList<RecipeUtil>> preCullRecipes) {
        ArrayList<RecipeUtil> recipeList = preCullRecipes.get(key);
        if (recipeList == null) {
            recipeList = new ArrayList();
        }
        recipeList.add(addRecipe);
        preCullRecipes.put(key, recipeList);
    }

    public RecipeUtil(ItemStack outStack, NonNullList<ItemStack> componentsParam) {
        this.output = outStack;
        NonNullList components = NonNullList.func_191197_a((int)componentsParam.size(), (Object)ItemStack.field_190927_a);
        int i = 0;
        for (ItemStack itemStack : componentsParam) {
            if (!itemStack.func_190926_b() && itemStack.func_77973_b() != null) {
                if (itemStack.func_77952_i() == Short.MAX_VALUE) {
                    components.set(i, (Object)new ItemStack(itemStack.func_77973_b(), itemStack.func_190916_E(), 0));
                } else {
                    components.set(i, (Object)new ItemStack(itemStack.func_77973_b(), itemStack.func_190916_E(), itemStack.func_77952_i()));
                }
            }
            ++i;
        }
        this.inStacks = components;
    }

    public int getOutStackSize() {
        return this.output.func_190916_E();
    }

    public static RecipeUtil get(ItemStack output) {
        return RecipeUtil.get(new MapKey(output));
    }

    public static RecipeUtil get(MapKey key) {
        if (recipes.containsKey(key)) {
            return recipes.get(key);
        }
        return null;
    }

    public static RecipeUtil get(String string) {
        return recipes.get(string);
    }

    private static int cullRecipes(Map.Entry<MapKey, ArrayList<RecipeUtil>> entry, Map<MapKey, ArrayList<RecipeUtil>> preCullRecipes) {
        int returnVal = 0;
        ArrayList<RecipeUtil> value = entry.getValue();
        if (RecipeDecomposer.get(entry.getKey()) != null) {
            value.clear();
            entry.setValue(value);
            return 0;
        }
        Hashtable<RecipeUtil, Integer> result = new Hashtable<RecipeUtil, Integer>();
        for (RecipeUtil check : value) {
            int depth = 0;
            if (check.inStacks != null && check.inStacks.size() > 0) {
                MapKey key;
                ItemStack stack;
                Iterator iterator = check.inStacks.iterator();
                while (iterator.hasNext() && ((stack = (ItemStack)iterator.next()).func_190926_b() || (depth = Math.max(depth, RecipeUtil.getSize(key = MapKey.getKey(stack), 0, preCullRecipes))) < 20)) {
                }
                result.put(check, depth);
                continue;
            }
            result.put(check, 20);
        }
        value.clear();
        RecipeUtil minValue = null;
        for (RecipeUtil key : result.keySet()) {
            if (minValue == null && (Integer)result.get(key) < 20) {
                minValue = key;
                continue;
            }
            if (minValue == null) continue;
            if (key.getOutStackSize() < minValue.getOutStackSize()) {
                minValue = key;
                continue;
            }
            if (key.getOutStackSize() != minValue.getOutStackSize() || (Integer)result.get(key) >= (Integer)result.get(minValue)) continue;
            minValue = key;
        }
        if (minValue != null) {
            returnVal = (Integer)result.get(minValue);
            value.add(minValue);
        }
        entry.setValue(value);
        return returnVal;
    }

    private static int getSize(MapKey key, int depth, Map<MapKey, ArrayList<RecipeUtil>> preCullRecipes) {
        if (depth > 20) {
            return depth;
        }
        if (RecipeDecomposer.get(key) != null) {
            return 0;
        }
        if (!preCullRecipes.containsKey(key) || preCullRecipes.get(key).size() < 1) {
            return 1;
        }
        if (recipes.containsKey(key)) {
            return RecipeUtil.recipes.get((Object)key).depth;
        }
        ModLogger.debug("Depth: " + depth + ", stack: " + preCullRecipes.get((Object)key).get((int)0).output.toString());
        int result = 0;
        for (RecipeUtil recipe : preCullRecipes.get(key)) {
            MapKey nextKey;
            int nextDepth;
            ItemStack stack;
            int thisDepth = 0;
            Iterator iterator = recipe.inStacks.iterator();
            while (iterator.hasNext() && ((stack = (ItemStack)iterator.next()).func_190926_b() || (thisDepth = Math.max(thisDepth, nextDepth = RecipeUtil.getSize(nextKey = MapKey.getKey(stack), depth + 1, preCullRecipes))) <= 20)) {
            }
            if ((result = Math.max(thisDepth, result)) <= 20) continue;
            break;
        }
        return result + 1;
    }

    public static void removeRecipe(ResourceLocation recipe) {
        RecipeUtil.removeRecipes(Lists.newArrayList((Object[])new ResourceLocation[]{recipe}));
    }

    public static void removeRecipes(List<ResourceLocation> removingRecipes) {
        removingRecipes.forEach(recipe -> RegistryManager.ACTIVE.getRegistry(GameData.RECIPES).remove(recipe));
    }

    public static Ingredient getIngredient(Object obj) {
        if (obj instanceof PotionChemical) {
            PotionChemical chemical = (PotionChemical)obj;
            return CraftingHelper.getIngredient((Object)MinechemUtil.chemicalToItemStack(chemical, chemical.amount));
        }
        return CraftingHelper.getIngredient((Object)obj);
    }

    public static NonNullList<ItemStack> getRecipeAsStackList(IRecipe recipe) {
        return RecipeUtil.ingredientListToStackList((List<Ingredient>)recipe.func_192400_c());
    }

    public static NonNullList<ItemStack> ingredientListToStackList(List<Ingredient> ingredients) {
        NonNullList stackList = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < ingredients.size(); ++i) {
            ItemStack[] matchingStacks = ingredients.get(i).func_193365_a();
            if (matchingStacks == null || matchingStacks.length <= 0) continue;
            stackList.set(i, (Object)matchingStacks[0]);
        }
        return stackList;
    }

    public static NonNullList<ItemStack> getRecipeAsStackList(ISynthesisRecipe recipe) {
        return RecipeUtil.singleIngredientListToStackList(recipe.getSingleIngredients());
    }

    public static NonNullList<ItemStack> singleIngredientListToStackList(List<SingleItemStackBasedIngredient> ingredients) {
        NonNullList stackList = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < ingredients.size(); ++i) {
            ItemStack[] matchingStacks = ingredients.get(i).func_193365_a();
            if (matchingStacks == null || matchingStacks.length <= 0) continue;
            stackList.set(i, (Object)matchingStacks[0]);
        }
        return stackList;
    }
}

