/*
 * Decompiled with CFR 0.152.
 */
package minechem.utils;

import minechem.utils.MinechemUtil;

public class TickTimeUtil {
    public static String getTimeFromTicks(long ticks) {
        if (ticks < 0L) {
            return MinechemUtil.getLocalString("minechem.unstable", true);
        }
        String timeLeft = "";
        String hourabbr = MinechemUtil.getLocalString("minechem.hour.abbr", true);
        String minabbr = MinechemUtil.getLocalString("minechem.min.abbr", true);
        String secabbr = MinechemUtil.getLocalString("minechem.sec.abbr", true);
        if (ticks < 1728000L) {
            int hrs = (int)(ticks / 72000L);
            ticks -= (long)(72000 * hrs);
            if (hrs > 0) {
                timeLeft = hourabbr.isEmpty() || hourabbr.equals("minechem.hour.abbr") ? hrs + "hr " : hrs + hourabbr + " ";
            }
        }
        if (ticks < 72000L) {
            int mins = (int)(ticks / 1200L);
            ticks -= (long)(1200 * mins);
            if (mins > 0) {
                timeLeft = minabbr.isEmpty() || minabbr.equals("minechem.min.abbr") ? timeLeft + mins + "m" : timeLeft + mins + minabbr;
            }
        }
        if (ticks < 1200L) {
            int secs = (int)(ticks / 20L);
            ticks -= (long)(20 * secs);
            if (secs > 0) {
                if (!timeLeft.equals("")) {
                    timeLeft = timeLeft + " ";
                }
                timeLeft = secabbr.isEmpty() || secabbr.equals("minechem.sec.abbr") ? timeLeft + secs + "s" : timeLeft + secs + secabbr;
            }
        }
        return timeLeft;
    }

    public static int getSecondsFromTicks(long ticks) {
        return (int)(ticks / 20L);
    }

    public static String getTimeFormattedFromSeconds(int totalSeconds) {
        String hourabbr = MinechemUtil.getLocalString("minechem.hour.abbr", true);
        String minabbr = MinechemUtil.getLocalString("minechem.min.abbr", true);
        String secabbr = MinechemUtil.getLocalString("minechem.sec.abbr", true);
        if (hourabbr.isEmpty() || hourabbr.equals("minechem.hour.abbr")) {
            hourabbr = "H";
        }
        if (minabbr.isEmpty() || minabbr.equals("minechem.min.abbr")) {
            minabbr = "M";
        }
        if (secabbr.isEmpty() || secabbr.equals("minechem.sec.abbr")) {
            secabbr = "S";
        }
        int hours = totalSeconds % 86400 / 3600;
        int minutes = totalSeconds % 86400;
        minutes %= 3600;
        minutes /= 60;
        int seconds = totalSeconds % 86400;
        seconds %= 3600;
        seconds %= 60;
        String timeString = "";
        if (hours > 0) {
            timeString = hours + "" + hourabbr;
        }
        if (minutes > 0) {
            timeString = timeString + " " + minutes + "" + minabbr;
        }
        if (seconds > 0) {
            timeString = timeString + " " + seconds + "" + secabbr;
        }
        return timeString;
    }
}

