/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.Random;
import lumien.randomthings.block.BlockIgniter;
import lumien.randomthings.lib.ContainerSynced;
import lumien.randomthings.lib.IRedstoneSensitive;
import lumien.randomthings.tileentity.TileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityIgniter
extends TileEntityBase
implements IRedstoneSensitive {
    @ContainerSynced
    MODE mode = MODE.TOGGLE;

    @Override
    public void writeDataToNBT(NBTTagCompound compound, boolean sync) {
        if (!sync) {
            compound.func_74768_a("mode", this.mode.ordinal());
        }
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound, boolean sync) {
        if (!sync) {
            this.mode = MODE.values()[compound.func_74762_e("mode")];
        }
    }

    @Override
    public void neighborChanged(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos changedPos) {
        super.neighborChanged(state, worldIn, pos, neighborBlock, changedPos);
        if (this.mode == MODE.KEEP_IGNITED) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockIgniter.FACING);
            BlockPos frontPos = pos.func_177972_a(facing);
            IBlockState front = this.field_145850_b.func_180495_p(frontPos);
            if (this.field_145850_b.func_175623_d(frontPos) && Blocks.field_150480_ab.func_176196_c(worldIn, frontPos)) {
                this.field_145850_b.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, new Random().nextFloat() * 0.4f + 0.8f);
                this.field_145850_b.func_175656_a(frontPos, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    @Override
    public void redstoneChange(boolean oldState, boolean newState) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockIgniter.FACING);
        if (oldState && !newState) {
            IBlockState front = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing));
            if (front.func_177230_c() == Blocks.field_150480_ab && this.mode == MODE.TOGGLE) {
                this.field_145850_b.func_175698_g(this.field_174879_c.func_177972_a(facing));
            }
        } else if (newState && !oldState) {
            if (this.field_145850_b.func_175623_d(this.field_174879_c.func_177972_a(facing)) && this.mode != MODE.KEEP_IGNITED && Blocks.field_150480_ab.func_176196_c(this.field_145850_b, this.field_174879_c.func_177972_a(facing))) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, new Random().nextFloat() * 0.4f + 0.8f);
                this.field_145850_b.func_175656_a(this.field_174879_c.func_177972_a(facing), Blocks.field_150480_ab.func_176223_P());
            }
        } else {
            return;
        }
    }

    public void rotateMode() {
        switch (this.mode) {
            case IGNITE: {
                this.mode = MODE.KEEP_IGNITED;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockIgniter.FACING);
                BlockPos frontPos = this.field_174879_c.func_177972_a(facing);
                IBlockState front = this.field_145850_b.func_180495_p(frontPos);
                if (!this.field_145850_b.func_175623_d(frontPos) || !Blocks.field_150480_ab.func_176196_c(this.field_145850_b, frontPos)) break;
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, new Random().nextFloat() * 0.4f + 0.8f);
                this.field_145850_b.func_175656_a(frontPos, Blocks.field_150480_ab.func_176223_P());
                break;
            }
            case KEEP_IGNITED: {
                this.mode = MODE.TOGGLE;
                break;
            }
            case TOGGLE: {
                this.mode = MODE.IGNITE;
                break;
            }
        }
    }

    public static enum MODE {
        TOGGLE,
        IGNITE,
        KEEP_IGNITED;

    }
}

