/*
 * Decompiled with CFR 0.152.
 */
package nc.block.tile;

import nc.block.property.ISidedEnergy;
import nc.block.tile.BlockSimpleTile;
import nc.block.tile.INBTDrop;
import nc.enumm.BlockEnums;
import nc.tile.energy.ITileEnergy;
import nc.tile.energy.battery.IBattery;
import nc.tile.internal.energy.EnergyStorage;
import nc.util.Lang;
import nc.util.UnitHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBattery
extends BlockSimpleTile
implements ISidedEnergy,
INBTDrop {
    public BlockBattery(BlockEnums.SimpleTileType type) {
        super(type);
    }

    protected BlockStateContainer func_180661_e() {
        return this.createEnergyBlockState(this);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getActualEnergyState(state, world, pos);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        if (player != null) {
            if (player.func_70093_af() && world.func_175625_s(pos) instanceof ITileEnergy) {
                ((ITileEnergy)world.func_175625_s(pos)).toggleEnergyConnection(facing);
            } else if (!world.field_72995_K && !player.func_70093_af() && world.func_175625_s(pos) instanceof IBattery) {
                EnergyStorage storage = ((IBattery)world.func_175625_s(pos)).getEnergyStorage();
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("gui.container.energy_stored") + " " + UnitHelper.prefix((long)storage.getEnergyStored(), (long)storage.getMaxEnergyStored(), 5, "RF")));
            }
        }
        return true;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IBattery) {
            EnergyStorage storage = ((IBattery)tile).getEnergyStorage();
            return (int)Math.round(15.0 * (double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored());
        }
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    @Override
    public ItemStack getNBTDrop(IBlockAccess world, BlockPos pos, IBlockState state) {
        ItemStack stack = new ItemStack((Block)this);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ITileEnergy) {
            NBTTagCompound nbt = new NBTTagCompound();
            ((ITileEnergy)tile).writeEnergy(nbt);
            ((ITileEnergy)tile).writeEnergyConnections(nbt);
            stack.func_77982_d(nbt);
        }
        return stack;
    }

    @Override
    public void readStackData(World world, BlockPos pos, EntityLivingBase player, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ITileEnergy) {
            ((ITileEnergy)tile).readEnergy(stack.func_77978_p());
            if (player != null && player.func_70093_af()) {
                ((ITileEnergy)tile).readEnergyConnections(stack.func_77978_p());
            }
        }
    }
}

