/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.saltFission.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.saltFission.SaltFissionReactor;
import nc.multiblock.saltFission.tile.TileSaltFissionModerator;
import nc.multiblock.saltFission.tile.TileSaltFissionPartBase;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.IngredientSorption;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.fluid.ITileFluid;
import nc.tile.generator.IFluidGenerator;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.passive.ITilePassive;
import nc.util.GasHelper;
import nc.util.RadiationHelper;
import nc.util.RecipeHelper;
import nc.util.RegistryHelper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileSaltFissionVessel
extends TileSaltFissionPartBase
implements IFluidGenerator,
ITileFluid {
    private static final FluidConnection DEPLETED_OUT = FluidConnection.IN;
    private static final FluidConnection FUEL_OUT = FluidConnection.OUT;
    private static final FluidConnection DEFAULT = FluidConnection.BOTH;
    private static final FluidConnection DISABLED = FluidConnection.NON;
    @Nonnull
    private final List<Tank> tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(1296, TankSorption.IN, RecipeHelper.validFluids(NCRecipes.Type.SALT_FISSION).get(0)), new Tank(5184, TankSorption.OUT, new ArrayList<String>()), new Tank(1296, TankSorption.NON, new ArrayList<String>())});
    @Nonnull
    private FluidConnection[] fluidConnections = ITileFluid.fluidConnectionAll(FluidConnection.BOTH);
    @Nonnull
    private FluidTileWrapper[] fluidSides;
    @Nonnull
    private GasTileWrapper gasWrapper;
    public final int fluidInputSize = 1;
    public final int fluidOutputSize = 1;
    public double baseProcessTime = 1.0;
    public double baseProcessHeat = 0.0;
    public double baseProcessRadiation = 0.0;
    private int baseVesselEfficiency;
    private double moderatorExtraEfficiency;
    private double moderatorHeatFactor;
    private int fluidToHold;
    public boolean distributedTo = false;
    public boolean retrievedFrom = false;
    public double time;
    public boolean isProcessing;
    public boolean hasConsumed;
    public boolean canProcessInputs;
    public final NCRecipes.Type recipeType = NCRecipes.Type.SALT_FISSION;
    protected ProcessorRecipe recipe;
    protected int vesselCount;

    public TileSaltFissionVessel() {
        super(CuboidalPartPositionType.INTERIOR);
        this.fluidSides = ITileFluid.getDefaultFluidSides(this);
        this.gasWrapper = new GasTileWrapper(this);
    }

    @Override
    public void onMachineAssembled(SaltFissionReactor controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
    }

    public void calculateEfficiency() {
        int newEfficiency = 1;
        block0: for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (this.isVessel(dir, 1)) {
                ++newEfficiency;
                continue;
            }
            for (int i = 1; i <= NCConfig.fission_neutron_reach && this.isModerator(dir, i, false); ++i) {
                if (!this.isVessel(dir, i + 1)) continue;
                ++newEfficiency;
                continue block0;
            }
        }
        int moderatorCount = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.isModerator(dir, 1, true)) continue;
            ++moderatorCount;
        }
        this.baseVesselEfficiency = newEfficiency;
        this.moderatorExtraEfficiency = (double)(newEfficiency * moderatorCount) * NCConfig.fission_moderator_extra_power / 6.0;
        this.moderatorHeatFactor = (double)(newEfficiency * moderatorCount) * NCConfig.fission_moderator_extra_heat / 6.0;
    }

    private boolean isVessel(EnumFacing dir, int offset) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(dir, offset));
        if (!(tile instanceof TileSaltFissionVessel)) {
            return false;
        }
        TileSaltFissionVessel vessel = (TileSaltFissionVessel)tile;
        return vessel.canProcessInputs && vessel.isMultiblockAssembled();
    }

    private boolean isModerator(EnumFacing dir, int offset, boolean isInValidPosition) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177967_a(dir, offset));
        if (!(tile instanceof TileSaltFissionModerator)) {
            return false;
        }
        TileSaltFissionModerator moderator = (TileSaltFissionModerator)tile;
        moderator.isInModerationLine = true;
        if (isInValidPosition && this.canProcessInputs) {
            moderator.isInValidPosition = true;
        }
        return true;
    }

    public void doMeltdown() {
        RadiationHelper.addToChunkRadiation(this.field_145850_b.func_175726_f(this.field_174879_c), this.baseProcessRadiation * NCConfig.salt_fission_fuel_use);
        Block corium = RegistryHelper.getBlock("nuclearcraft:fluid_corium");
        this.field_145850_b.func_175713_t(this.field_174879_c);
        this.field_145850_b.func_175656_a(this.field_174879_c, corium.func_176223_P());
    }

    public double getEfficiency() {
        return (double)this.baseVesselEfficiency + this.moderatorExtraEfficiency;
    }

    public double getHeatMultiplier() {
        return (double)this.baseVesselEfficiency * ((double)this.baseVesselEfficiency + 1.0) * 0.5 + this.moderatorHeatFactor;
    }

    public double getProcessHeat() {
        return this.getHeatMultiplier() * this.baseProcessHeat * NCConfig.salt_fission_heat_generation;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshRecipe();
            this.refreshActivity();
            this.isProcessing = this.isProcessing();
            this.hasConsumed = this.hasConsumed();
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.updateVessel();
    }

    public void updateVessel() {
        if (!this.field_145850_b.field_72995_K) {
            this.setIsReactorOn();
            boolean wasProcessing = this.isProcessing;
            this.isProcessing = this.isProcessing();
            boolean shouldUpdate = false;
            this.tickVessel();
            if (this.isProcessing) {
                this.process();
            } else {
                this.getRadiationSource().setRadiationLevel(0.0);
            }
            if (wasProcessing != this.isProcessing) {
                shouldUpdate = true;
            }
            this.pushFluid();
            if (this.vesselCount == 0) {
                this.refreshRecipe();
                this.refreshActivity();
            }
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    public void tickVessel() {
        ++this.vesselCount;
        this.vesselCount %= NCConfig.machine_update_rate / 2;
    }

    @Override
    public void refreshRecipe() {
        if (this.recipe == null || !this.recipe.matchingInputs(new ArrayList<ItemStack>(), this.getFluidInputs(this.hasConsumed))) {
            this.recipe = (ProcessorRecipe)this.getRecipeHandler().getRecipeFromInputs(new ArrayList<ItemStack>(), this.getFluidInputs(this.hasConsumed));
        }
        this.consumeInputs();
    }

    @Override
    public void refreshActivity() {
        this.canProcessInputs = this.canProcessInputs();
    }

    public boolean setRecipeStats() {
        if (this.recipe == null) {
            this.baseProcessTime = 1.0;
            this.baseProcessHeat = 0.0;
            this.baseProcessRadiation = 0.0;
            return false;
        }
        this.baseProcessTime = this.recipe.getSaltFissionFuelTime();
        this.baseProcessHeat = this.recipe.getSaltFissionFuelHeat();
        this.baseProcessRadiation = this.recipe.getSaltFissionFuelRadiation();
        this.fluidToHold = this.getFluidIngredients().get(0).getMaxStackSize();
        return true;
    }

    public boolean isProcessing() {
        return this.readyToProcess() && this.isReactorOn;
    }

    public boolean readyToProcess() {
        return this.canProcessInputs && this.hasConsumed && this.isMultiblockAssembled();
    }

    public boolean hasConsumed() {
        if (this.field_145850_b.field_72995_K) {
            return this.hasConsumed;
        }
        for (int i = 0; i < 1; ++i) {
            if (this.tanks.get(i + 1 + 1).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean canProcessInputs() {
        if (!this.setRecipeStats()) {
            if (this.hasConsumed) {
                for (Tank tank : this.getFluidInputs(true)) {
                    tank.setFluidStored(null);
                }
                this.hasConsumed = false;
            }
            return false;
        }
        if (this.time >= this.baseProcessTime) {
            return true;
        }
        return this.canProduceProducts();
    }

    public boolean canProduceProducts() {
        for (int j = 0; j < 1; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize() <= 0) continue;
            if (fluidProduct.getStack() == null) {
                return false;
            }
            if (this.tanks.get(j + 1).isEmpty()) continue;
            if (!this.tanks.get(j + 1).getFluid().isFluidEqual(fluidProduct.getStack())) {
                return false;
            }
            if (this.tanks.get(j + 1).getFluidAmount() + fluidProduct.getMaxStackSize() <= this.tanks.get(j + 1).getCapacity()) continue;
            return false;
        }
        return true;
    }

    public void consumeInputs() {
        int i;
        if (this.hasConsumed || this.recipe == null) {
            return;
        }
        List<Integer> fluidInputOrder = this.getFluidInputOrder();
        if (fluidInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (i = 0; i < 1; ++i) {
            if (this.tanks.get(i + 1 + 1).isEmpty()) continue;
            this.tanks.get(i + 1 + 1).setFluid(null);
        }
        for (i = 0; i < 1; ++i) {
            IFluidIngredient fluidIngredient = this.getFluidIngredients().get(fluidInputOrder.get(i));
            if (fluidIngredient.getMaxStackSize() > 0) {
                this.tanks.get(i + 1 + 1).setFluidStored(new FluidStack(this.tanks.get(i).getFluid(), fluidIngredient.getMaxStackSize()));
                this.tanks.get(i).changeFluidAmount(-fluidIngredient.getMaxStackSize());
            }
            if (!this.tanks.get(i).isEmpty()) continue;
            this.tanks.get(i).setFluid(null);
        }
        this.hasConsumed = true;
    }

    public void process() {
        this.time += NCConfig.salt_fission_fuel_use;
        this.getRadiationSource().setRadiationLevel(this.baseProcessRadiation * NCConfig.salt_fission_fuel_use);
        if (this.time >= this.baseProcessTime) {
            this.finishProcess();
        }
    }

    public void finishProcess() {
        double oldProcessTime = this.baseProcessTime;
        this.produceProducts();
        this.refreshRecipe();
        this.time = !this.setRecipeStats() ? 0.0 : MathHelper.func_151237_a((double)(this.time - oldProcessTime), (double)0.0, (double)this.baseProcessTime);
        this.refreshActivity();
    }

    public void produceProducts() {
        for (int i = 2; i < 3; ++i) {
            this.tanks.get(i).setFluid(null);
        }
        if (!this.hasConsumed || this.recipe == null) {
            return;
        }
        for (int j = 0; j < 1; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getNextStackSize() <= 0) continue;
            if (this.tanks.get(j + 1).isEmpty()) {
                this.tanks.get(j + 1).setFluidStored(fluidProduct.getNextStack());
                continue;
            }
            if (!this.tanks.get(j + 1).getFluid().isFluidEqual(fluidProduct.getStack())) continue;
            this.tanks.get(j + 1).changeFluidAmount(fluidProduct.getNextStackSize());
        }
        this.hasConsumed = false;
    }

    @Override
    public ProcessorRecipeHandler getRecipeHandler() {
        return this.recipeType.getRecipeHandler();
    }

    @Override
    public ProcessorRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public List<Tank> getFluidInputs(boolean consumed) {
        return consumed ? this.tanks.subList(2, 3) : this.tanks.subList(0, 1);
    }

    @Override
    public List<IFluidIngredient> getFluidIngredients() {
        return this.recipe.fluidIngredients();
    }

    @Override
    public List<IFluidIngredient> getFluidProducts() {
        return this.recipe.fluidProducts();
    }

    @Override
    public List<Integer> getFluidInputOrder() {
        ArrayList<Integer> fluidInputOrder = new ArrayList<Integer>();
        List<IFluidIngredient> fluidIngredients = this.recipe.fluidIngredients();
        for (int i = 0; i < 1; ++i) {
            int position = -1;
            for (int j = 0; j < fluidIngredients.size(); ++j) {
                if (!fluidIngredients.get(j).matches((Object)this.getFluidInputs(false).get(i), IngredientSorption.INPUT)) continue;
                position = j;
                break;
            }
            if (position == -1) {
                return AbstractRecipeHandler.INVALID;
            }
            fluidInputOrder.add(position);
        }
        return fluidInputOrder;
    }

    @Override
    @Nonnull
    public List<Tank> getTanks() {
        return this.tanks;
    }

    @Override
    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    @Override
    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Override
    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return this.fluidSides;
    }

    @Override
    @Nonnull
    public GasTileWrapper getGasWrapper() {
        return this.gasWrapper;
    }

    @Override
    public void pushFluidToSide(@Nonnull EnumFacing side) {
        block8: {
            TileEntity tile;
            FluidConnection thisConnection;
            block5: {
                FluidConnection vesselConnection;
                TileSaltFissionVessel vessel;
                block6: {
                    block7: {
                        thisConnection = this.getFluidConnection(side);
                        if (thisConnection == DISABLED) {
                            return;
                        }
                        tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
                        if (!(tile instanceof TileSaltFissionVessel)) break block5;
                        vessel = (TileSaltFissionVessel)tile;
                        vesselConnection = vessel.getFluidConnection(side.func_176734_d());
                        if (thisConnection != FUEL_OUT) break block6;
                        if (vesselConnection != DEFAULT) break block7;
                        this.pushFuel(vessel);
                        this.pushDepleted(vessel);
                        break block8;
                    }
                    if (vesselConnection != DEPLETED_OUT) break block8;
                    this.pushFuel(vessel);
                    break block8;
                }
                if (thisConnection != DEPLETED_OUT || vesselConnection != DEFAULT && vesselConnection != FUEL_OUT) break block8;
                this.pushDepleted(vessel);
                break block8;
            }
            if (thisConnection == DEPLETED_OUT) {
                IFluidHandler adjStorage;
                if (tile instanceof ITilePassive && !((ITilePassive)tile).canPushFluidsTo()) {
                    return;
                }
                IFluidHandler iFluidHandler = adjStorage = tile == null ? null : (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
                if (adjStorage == null) {
                    return;
                }
                for (int i = 0; i < this.getTanks().size(); ++i) {
                    if (this.getTanks().get(i).getFluid() == null || !this.getTanks().get(i).canDrain()) continue;
                    this.getTanks().get(i).drainInternal(adjStorage.fill(this.getTanks().get(i).drainInternal(this.getTanks().get(i).getCapacity(), false), true), true);
                }
            }
        }
    }

    public void pushFuel(TileSaltFissionVessel other) {
        if (this.getTanks().get(0).getFluidAmount() > other.getTanks().get(0).getFluidAmount()) {
            this.getTanks().get(0).drainInternal(other.getTanks().get(0).fillInternal(this.getTanks().get(0).drainInternal(this.getTanks().get(0).getFluidAmount() - this.fluidToHold, false), true), true);
        }
    }

    public void pushDepleted(TileSaltFissionVessel other) {
        this.getTanks().get(1).drainInternal(other.getTanks().get(1).fillInternal(this.getTanks().get(1).drainInternal(this.getTanks().get(1).getCapacity(), false), true), true);
    }

    @Override
    public boolean getTanksShared() {
        return false;
    }

    @Override
    public void setTanksShared(boolean shared) {
    }

    @Override
    public boolean getEmptyUnusableTankInputs() {
        return false;
    }

    @Override
    public void setEmptyUnusableTankInputs(boolean emptyUnusableTankInputs) {
    }

    @Override
    public boolean getVoidExcessFluidOutputs() {
        return false;
    }

    @Override
    public void setVoidExcessFluidOutputs(boolean voidExcessFluidOutputs) {
    }

    @Override
    public boolean hasConfigurableFluidConnections() {
        return true;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeTanks(nbt);
        this.writeFluidConnections(nbt);
        nbt.func_74780_a("baseProcessTime", this.baseProcessTime);
        nbt.func_74780_a("baseProcessHeat", this.baseProcessHeat);
        nbt.func_74768_a("baseVesselEfficiency", this.baseVesselEfficiency);
        nbt.func_74780_a("moderatorExtraEfficiency", this.moderatorExtraEfficiency);
        nbt.func_74780_a("moderatorHeatFactor", this.moderatorHeatFactor);
        nbt.func_74780_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("hasConsumed", this.hasConsumed);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        nbt.func_74768_a("fluidToHold", this.fluidToHold);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readTanks(nbt);
        this.readFluidConnections(nbt);
        this.baseProcessTime = nbt.func_74769_h("baseProcessTime");
        this.baseProcessHeat = nbt.func_74769_h("baseProcessHeat");
        this.baseVesselEfficiency = nbt.func_74762_e("baseVesselEfficiency");
        this.moderatorExtraEfficiency = nbt.func_74769_h("moderatorExtraEfficiency");
        this.moderatorHeatFactor = nbt.func_74769_h("moderatorHeatFactor");
        this.time = nbt.func_74769_h("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.hasConsumed = nbt.func_74767_n("hasConsumed");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
        this.fluidToHold = nbt.func_74762_e("fluidToHold");
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
            side = this.nonNullSide(side);
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return this.getFluidSide(side) != null;
            }
            if (ModCheck.mekanismLoaded() && GasHelper.isGasCapability(capability)) {
                return this.getGasWrapper() != null;
            }
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
            side = this.nonNullSide(side);
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)this.getFluidSide(side);
            }
            if (ModCheck.mekanismLoaded() && GasHelper.isGasCapability(capability)) {
                return (T)this.getGasWrapper();
            }
        }
        return super.getCapability(capability, side);
    }
}

