/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import javax.annotation.Nonnull;
import net.machinemuse.numina.common.ModCompatibility;
import net.machinemuse.numina.module.EnumModuleCategory;
import net.machinemuse.numina.module.EnumModuleTarget;
import net.machinemuse.numina.module.IPlayerTickModule;
import net.machinemuse.numina.module.IRightClickModule;
import net.machinemuse.numina.utils.item.MuseItemUtils;
import net.machinemuse.powersuits.client.event.MuseIcon;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.utils.modulehelpers.OmniProbeHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class OmniProbeModule
extends PowerModuleBase
implements IRightClickModule,
IPlayerTickModule {
    private ItemStack conduitProbe;
    private ItemStack rednetMeter;
    private ItemStack cpmPSD;
    private ItemStack rcMeter;
    private ItemStack prDebugger;

    public OmniProbeModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 4));
        ItemStack tHighest = new ItemStack(Items.field_151132_bS);
        if (ModCompatibility.isMFRLoaded()) {
            tHighest = this.rednetMeter = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("MineFactoryReloaded", "rednet.meter")), 1);
        }
        if (ModCompatibility.isRailcraftLoaded()) {
            tHighest = this.rcMeter = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("Railcraft", "tool.electric.meter")), 1);
        }
        if (ModCompatibility.isEnderIOLoaded()) {
            tHighest = this.conduitProbe = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("EnderIO", "itemConduitProbe")), 1);
        }
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), tHighest);
    }

    @Override
    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_TOOL;
    }

    @Override
    public String getDataName() {
        return "omniProbe";
    }

    @Override
    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    @Override
    public EnumActionResult onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        int block = Block.func_149682_b((Block)world.func_180495_p(pos).func_177230_c());
        if (Loader.isModLoaded((String)"MineFactoryReloaded") && block == Block.func_149682_b((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("MineFactoryReloaded", "cable.redstone"))))) {
            return this.rednetMeter.func_77973_b().onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, EnumHand.MAIN_HAND);
        }
        if (Loader.isModLoaded((String)"Railcraft") && (block == Block.func_149682_b((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("Railcraft", "tile.railcraft.machine.alpha")))) || block == Block.func_149682_b((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("Railcraft", "tile.railcraft.track")))) || block == Block.func_149682_b((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("Railcraft", "tile.railcraft.machine.epsilon")))) || block == Block.func_149682_b((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("Railcraft", "tile.railcraft.machine.delta")))))) {
            return this.rcMeter.func_77973_b().onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, EnumHand.MAIN_HAND);
        }
        if (Loader.isModLoaded((String)"EnderIO") && block == Block.func_149682_b((Block)((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("EnderIO", "blockConduitBundle"))))) {
            return this.conduitProbe.func_77973_b().func_180614_a(player, world, pos, EnumHand.MAIN_HAND, side, hitX, hitY, hitZ);
        }
        return EnumActionResult.PASS;
    }

    @Override
    public void onPlayerTickActive(EntityPlayer player, ItemStack item) {
        if (!OmniProbeHelper.getEIOFacadeTransparency(item)) {
            OmniProbeHelper.setEIONoCompete(item, "omniProbe");
            OmniProbeHelper.setEIOFacadeTransparency(item, true);
        }
    }

    @Override
    public void onPlayerTickInactive(EntityPlayer player, ItemStack item) {
        if (!OmniProbeHelper.getEIONoCompete(item).isEmpty() && !OmniProbeHelper.getEIONoCompete(item).isEmpty()) {
            if (OmniProbeHelper.getEIONoCompete(item).equals("omniProbe")) {
                OmniProbeHelper.setEIONoCompete(item, "");
                if (OmniProbeHelper.getEIOFacadeTransparency(item)) {
                    OmniProbeHelper.setEIOFacadeTransparency(item, false);
                }
            }
        } else if (OmniProbeHelper.getEIOFacadeTransparency(item)) {
            OmniProbeHelper.setEIOFacadeTransparency(item, false);
        }
    }

    public float minF(float a, float b) {
        return a < b ? a : b;
    }

    @Override
    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    @Override
    public int getEnergyUsage(@Nonnull ItemStack itemStack) {
        return 0;
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return MuseIcon.omniProbe;
    }
}

