/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui.element;

import mekanism.api.Coord4D;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTurbineTab
extends GuiElement {
    private TileEntity tileEntity;
    private TurbineTab tabType;
    private int yPos;

    public GuiTurbineTab(IGuiWrapper gui, TileEntity tile, TurbineTab type, int y, ResourceLocation def) {
        super(type.getResource(), gui, def);
        this.tileEntity = tile;
        this.tabType = type;
        this.yPos = y;
    }

    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth - 26, guiHeight + this.yPos, 26, 26);
    }

    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiTurbineTab.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth - 26, guiHeight + this.yPos, 0, 0, 26, 26);
        if (xAxis >= -21 && xAxis <= -3 && yAxis >= this.yPos + 4 && yAxis <= this.yPos + 22) {
            this.guiObj.drawTexturedRect(guiWidth - 21, guiHeight + this.yPos + 4, 26, 0, 18, 18);
        } else {
            this.guiObj.drawTexturedRect(guiWidth - 21, guiHeight + this.yPos + 4, 26, 18, 18, 18);
        }
        GuiTurbineTab.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    public void renderForeground(int xAxis, int yAxis) {
        GuiTurbineTab.mc.field_71446_o.func_110577_a(this.RESOURCE);
        if (xAxis >= -21 && xAxis <= -3 && yAxis >= this.yPos + 4 && yAxis <= this.yPos + 22) {
            this.displayTooltip(this.tabType.getDesc(), xAxis, yAxis);
        }
        GuiTurbineTab.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    public void mouseClicked(int xAxis, int yAxis, int button) {
        if (button == 0 && xAxis >= -21 && xAxis <= -3 && yAxis >= this.yPos + 4 && yAxis <= this.yPos + 22) {
            this.tabType.openGui(this.tileEntity);
            SoundHandler.playSound((SoundEvent)SoundEvents.field_187909_gi);
        }
    }

    public static enum TurbineTab {
        MAIN("GuiGasesTab.png", 6, "gui.main"),
        STAT("GuiStatsTab.png", 7, "gui.stats");

        private String path;
        private int guiId;
        private String desc;

        private TurbineTab(String s, int id, String s1) {
            this.path = s;
            this.guiId = id;
            this.desc = s1;
        }

        public ResourceLocation getResource() {
            return MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI_ELEMENT, (String)this.path);
        }

        public void openGui(TileEntity tile) {
            Mekanism.packetHandler.sendToServer((IMessage)new PacketSimpleGui.SimpleGuiMessage(Coord4D.get((TileEntity)tile), 1, this.guiId));
        }

        public String getDesc() {
            return LangUtils.localize((String)this.desc);
        }
    }
}

