/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.tools;

import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import landmaster.plustic.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.SwordCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.ranged.item.Shuriken;

public class ToolKatana
extends SwordCore {
    public static final float DURABILITY_MODIFIER = 0.88f;
    public static final String COUNTER_TAG = "PlusTiC_Counter";

    private static float counter_multiplier(float attack) {
        if (Config.katana_smooth_progression) {
            return MathHelper.func_76131_a((float)(1.2f + 0.025f * attack), (float)1.2f, (float)1.8f);
        }
        if (attack <= 5.0f) {
            return 1.2f;
        }
        if (attack <= 11.0f) {
            return 1.35f;
        }
        return 1.5f;
    }

    public static float counter_cap(ItemStack tool) {
        float attack = TagUtil.getToolStats((ItemStack)tool).attack;
        return attack * ToolKatana.counter_multiplier(attack);
    }

    public ToolKatana() {
        super(new PartMaterialType[]{PartMaterialType.handle((IToolPart)TinkerTools.toughToolRod), PartMaterialType.head((IToolPart)TinkerTools.largeSwordBlade), PartMaterialType.head((IToolPart)TinkerTools.largeSwordBlade), PartMaterialType.extra((IToolPart)TinkerTools.toughBinding)});
        this.addCategory(new Category[]{Category.WEAPON});
        this.func_77655_b("katana").setRegistryName("katana");
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void render(RenderGameOverlayEvent event) {
        float counter;
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack is = mc.field_71439_g.func_184614_ca();
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT && is != null && is.func_77973_b() instanceof ToolKatana && (counter = TagUtil.getTagSafe((ItemStack)is).func_74760_g(COUNTER_TAG)) > 0.0f) {
            mc.field_71466_p.func_175065_a(I18n.func_135052_a((String)"meter.plustic.katana", (Object[])new Object[]{Float.valueOf(counter)}), 5.0f, 5.0f, Color.HSBtoRGB(Math.min(counter / (ToolKatana.counter_cap(is) * 3.0f), 0.33333334f), 1.0f, 1.0f) & 0xFFFFFF, true);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        return this._rightClick(playerIn.func_184586_b(hand), worldIn, playerIn, hand);
    }

    @Nonnull
    private ActionResult<ItemStack> _rightClick(@Nonnull ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K && hand == EnumHand.MAIN_HAND && playerIn.func_184592_cb() != null && !(playerIn.func_184592_cb().func_77973_b() instanceof Shuriken)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    public int[] getRepairParts() {
        return new int[]{1, 2};
    }

    public double attackSpeed() {
        return 2.55;
    }

    public float damagePotential() {
        return 0.77f;
    }

    public float damageCutoff() {
        return 22.0f;
    }

    public float knockback() {
        return 0.83f;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K) {
            NBTTagCompound tag = TagUtil.getTagSafe((ItemStack)stack);
            float counter = tag.func_74760_g(COUNTER_TAG);
            counter -= 0.005f;
            counter = MathHelper.func_76131_a((float)counter, (float)0.0f, (float)ToolKatana.counter_cap(stack));
            tag.func_74776_a(COUNTER_TAG, counter);
            stack.func_77982_d(tag);
        }
    }

    public boolean dealDamage(ItemStack stack, EntityLivingBase player, Entity entity, float damage) {
        NBTTagCompound tag;
        float counter;
        boolean success;
        EntityLivingBase targetLiving;
        if (entity instanceof EntityLivingBase && (targetLiving = (EntityLivingBase)entity).func_70658_aO() <= 0) {
            damage += 2.6f;
        }
        if (success = super.dealDamage(stack, player, entity, damage += (counter = (tag = TagUtil.getTagSafe((ItemStack)stack)).func_74760_g(COUNTER_TAG)) * Config.katana_combo_multiplier)) {
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase targetLiving2 = (EntityLivingBase)entity;
                if (targetLiving2.func_110143_aJ() <= 0.0f || !Config.katana_boosts_only_on_killing) {
                    counter += 1.0f;
                }
                counter = MathHelper.func_76131_a((float)counter, (float)0.0f, (float)ToolKatana.counter_cap(stack));
            }
            tag.func_74776_a(COUNTER_TAG, counter);
            stack.func_77982_d(tag);
        }
        return success;
    }

    public float getRepairModifierForPart(int index) {
        return 0.88f;
    }

    protected ToolNBT buildTagData(List<Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats head0 = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        HeadMaterialStats head1 = (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head");
        ExtraMaterialStats binding = (ExtraMaterialStats)materials.get(3).getStatsOrUnknown("extra");
        ToolNBT data = new ToolNBT();
        data.head(new HeadMaterialStats[]{head0, head1});
        data.extra(new ExtraMaterialStats[]{binding});
        data.handle(new HandleMaterialStats[]{handle});
        data.attack += 1.0f;
        data.durability = (int)((float)data.durability * 0.88f);
        return data;
    }

    static {
        MinecraftForge.EVENT_BUS.register(ToolKatana.class);
    }
}

