/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.zpm;

import gcewing.sg.features.ic2.zpm.ZpmInterfaceCartTE;
import gcewing.sg.features.zpm.ZPMMultiplierRegistry;
import gcewing.sg.features.zpm.ZpmConsoleTE;
import gcewing.sg.interfaces.ISGEnergySource;
import java.text.DecimalFormat;
import java.util.Optional;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ZpmAddon {
    static final boolean debugAddon = true;
    static final DecimalFormat dFormat = new DecimalFormat("###,###,###,##0");

    public static boolean routeRequiresZPM(World origin, World destination) {
        return ZpmAddon.routeRequiresZpm(origin.func_72912_H().func_76065_j().toLowerCase(), destination.func_72912_H().func_76065_j().toLowerCase());
    }

    public static boolean routeRequiresZpm(String origin, String destination) {
        Optional<Double> multiplier = ZPMMultiplierRegistry.getMultiplierFrom(origin, destination);
        if (!multiplier.isPresent()) {
            return false;
        }
        return multiplier.get() > 0.0;
    }

    public static int routeZpmMultiplier(String origin, String destination) {
        Optional<Double> multiplier = ZPMMultiplierRegistry.getMultiplierFrom(origin, destination);
        if (!multiplier.isPresent()) {
            return 0;
        }
        return multiplier.get().intValue();
    }

    public static double zpmPowerAvailable(World world, BlockPos pos, int radius, boolean debug) {
        double zpmPower = 0.0;
        for (BlockPos.MutableBlockPos nearPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-radius, -radius, -radius), (BlockPos)pos.func_177982_a(radius, radius, radius))) {
            TileEntity nte = world.func_175625_s((BlockPos)nearPos);
            if (nte == null) continue;
            if (nte instanceof ZpmInterfaceCartTE) {
                System.out.printf("SGBaseTE.zpmInterfaceCartNear: %s at %s\n", nte, nearPos);
                if (((ZpmInterfaceCartTE)nte).func_191420_l()) {
                    System.out.println("ZPM cart is empty");
                    return 0.0;
                }
                zpmPower += ((ISGEnergySource)nte).availableEnergy();
            }
            if (!(nte instanceof ZpmConsoleTE)) continue;
            System.out.printf("SGBaseTE.zpmConsoleNear: %s at %s\n", nte, nearPos);
            if (((ZpmConsoleTE)nte).func_191420_l()) {
                System.out.println("ZPM cart is empty");
                return 0.0;
            }
            zpmPower += ((ISGEnergySource)nte).availableEnergy();
        }
        System.out.println("SGCraft:ZpmAddon - Power Available: " + dFormat.format(zpmPower));
        return zpmPower;
    }
}

