/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.ACentauriSystem;

import asmodeuscore.core.astronomy.BodiesHelper;
import asmodeuscore.core.astronomy.dimension.world.gen.ACBiome;
import galaxyspace.api.IBodies;
import galaxyspace.core.proxy.ClientProxy;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.core.util.GSDimensions;
import galaxyspace.systems.ACentauriSystem.core.configs.ACConfigCore;
import galaxyspace.systems.ACentauriSystem.core.configs.ACConfigDimensions;
import galaxyspace.systems.ACentauriSystem.core.registers.blocks.ACBlocks;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.blocks.Proxima_B_Blocks;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.dimension.TeleportTypeProxima_B;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.dimension.WorldProviderProxima_B_WE;
import galaxyspace.systems.ACentauriSystem.planets.proxima_b.recipes.CraftingRecipesProximaB;
import java.io.File;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ACentauriSystemBodies
implements IBodies {
    public static SolarSystem aCentauriSystem;
    public static SolarSystem ProximaSystem;
    public static Star aCentauri;
    public static Planet centauriB;
    public static Star proxima;
    public static Planet proximaB;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new ACConfigCore(new File(event.getModConfigurationDirectory(), "GalaxySpace/alpha_centauri/core.conf"));
        new ACConfigDimensions(new File(event.getModConfigurationDirectory(), "GalaxySpace/alpha_centauri/dimensions.conf"));
        aCentauriSystem = BodiesHelper.registerSolarSystem((String)"galaxyspace", (String)"acentauri", (String)BodiesHelper.Galaxies.MILKYWAY.getName(), (Vector3)new Vector3(1.5, 0.0, 0.0), (String)"centauri_a", (float)1.3f);
        centauriB = (Planet)BodiesHelper.registerPlanet((SolarSystem)aCentauriSystem, (String)"centauri_b", (String)"galaxyspace", null, (int)-1, (int)-1, (float)((float)Math.PI), (float)1.5f, (float)0.3f, (float)1000.0f, (Biome[])new Biome[0]).setRingColorRGB(0.0f, 0.0f, 0.0f);
        ProximaSystem = BodiesHelper.registerSolarSystem((String)"galaxyspace", (String)"proxima", (String)BodiesHelper.Galaxies.MILKYWAY.getName(), (Vector3)new Vector3((double)1.7f, (double)-0.2f, 0.0), (String)"proxima", (float)0.8f);
        proximaB = (Planet)BodiesHelper.registerPlanet((SolarSystem)ProximaSystem, (String)"proxima_b", (String)"galaxyspace", WorldProviderProxima_B_WE.class, (int)ACConfigDimensions.dimensionIDProxima_B, (int)6, (float)((float)Math.PI * 3), (float)1.2f, (float)0.25f, (float)1.1f, (Biome[])new Biome[]{ACBiome.ACSpace}).setRingColorRGB(0.0f, 0.4f, 0.9f).atmosphereComponent(EnumAtmosphericGas.CO2);
        if (ACConfigCore.enableACentauriSystems) {
            ACBlocks.initialize();
            ACentauriSystemBodies.registrycelestial();
            ACentauriSystemBodies.registryteleport();
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        if (ACConfigCore.enableACentauriSystems) {
            GSDimensions.PROXIMA_B = WorldUtil.getDimensionTypeById((int)ACConfigDimensions.dimensionIDProxima_B);
        }
    }

    private static void registrycelestial() {
        GalaxyRegistry.registerSolarSystem((SolarSystem)aCentauriSystem);
        GalaxyRegistry.registerSolarSystem((SolarSystem)ProximaSystem);
        BodiesHelper.BodiesData unreachableData = new BodiesHelper.BodiesData(null, 0.0f, 0, 0.0f, 0.0f, 0L, false, false);
        BodiesHelper.registerBody((CelestialBody)centauriB, (BodiesHelper.BodiesData)unreachableData, (boolean)true);
        BodiesHelper.BodiesData data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity((float)8.0f), 2, 0.5f, 1.0f, 35050L, false, true);
        data.addItemStack(new ItemStack(GSItems.SPACE_SUIT_HELMET, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SPACE_SUIT_BODY, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SPACE_SUIT_LEGGINS, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SPACE_SUIT_BOOTS, 1, Short.MAX_VALUE));
        BodiesHelper.registerBody((CelestialBody)proximaB, (BodiesHelper.BodiesData)data, (boolean)ACConfigDimensions.enableProxima_B);
        data = new BodiesHelper.BodiesData(BodiesHelper.yellow + " " + BodiesHelper.dwarf, 20.336f, 0, 999.0f, 0.0f, 0L, false, false);
        BodiesHelper.registerBodyWithClass((CelestialBody)aCentauriSystem.getMainStar(), (BodiesHelper.BodiesData)data);
        data = new BodiesHelper.BodiesData(BodiesHelper.orange + " " + BodiesHelper.dwarf, 18.124f, 0, 999.0f, 0.0f, 0L, false, false);
        BodiesHelper.registerBodyWithClass((CelestialBody)ProximaSystem.getMainStar(), (BodiesHelper.BodiesData)data);
    }

    private static void registryteleport() {
        GalacticraftRegistry.registerTeleportType(WorldProviderProxima_B_WE.class, (ITeleportType)new TeleportTypeProxima_B());
    }

    @Override
    public void registerRender() {
        if (ACConfigCore.enableACentauriSystems) {
            for (Proxima_B_Blocks.EnumBlockProximaB blockBasic : Proxima_B_Blocks.EnumBlockProximaB.values()) {
                ClientUtil.registerBlockJson((String)"galaxyspace:", (Block)ACBlocks.PROXIMA_B_BLOCKS, (int)blockBasic.getMeta(), (String)("proxima/" + blockBasic.func_176610_l()));
            }
            ClientUtil.registerBlockJson((String)"galaxyspace:proxima/", (Block)ACBlocks.PROXINA_B_LOG_1);
            ClientUtil.registerBlockJson((String)"galaxyspace:proxima/", (Block)ACBlocks.PROXINA_B_LOG_2);
        }
    }

    @Override
    public void registerVariant() {
        if (ACConfigCore.enableACentauriSystems) {
            String[] blocks = new String[Proxima_B_Blocks.EnumBlockProximaB.values().length];
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = Proxima_B_Blocks.EnumBlockProximaB.byMetadata(i).func_176610_l();
            }
            ClientProxy.addVariant("proxima_b_blocks", "proxima/", blocks);
            ClientProxy.addVariant("proxima_b_log_1", "proxima/", "proxima_b_log_1");
            ClientProxy.addVariant("proxima_b_log_2", "proxima/", "proxima_b_log_2");
        }
    }

    @Override
    public void registerRecipes() {
        if (ACConfigCore.enableACentauriSystems) {
            CraftingRecipesProximaB.loadRecipes();
        }
    }
}

