/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.GalaxySpace;
import galaxyspace.core.prefab.entities.EntityIceSpike;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteor;
import micdoodle8.mods.galacticraft.core.entities.IBubbleProviderColored;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLaserTurret
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IBubbleProviderColored {
    public float bubbleSize;
    public static HashSet<BlockVec3Dim> loadedTiles = new HashSet();
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean shouldRenderBubble = true;

    public TileEntityLaserTurret() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 45.0f);
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.add(new BlockVec3Dim((TileEntity)this));
        }
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.add(new BlockVec3Dim((TileEntity)this));
        }
    }

    public void onChunkUnload() {
        loadedTiles.remove(new BlockVec3Dim((TileEntity)this));
        super.onChunkUnload();
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.remove(new BlockVec3Dim((TileEntity)this));
        }
        super.func_145843_s();
    }

    public double getPacketRange() {
        return 64.0;
    }

    public void addExtraNetworkedData(List<Object> networkedList) {
        if (!this.field_145850_b.field_72995_K && !this.func_145837_r()) {
            if (this.field_145850_b.func_73046_m().func_71262_S()) {
                networkedList.add(loadedTiles.size());
                for (BlockVec3Dim distributor : loadedTiles) {
                    if (distributor == null) {
                        networkedList.add(-1);
                        networkedList.add(-1);
                        networkedList.add(-1);
                        networkedList.add(-1);
                        continue;
                    }
                    networkedList.add(distributor.x);
                    networkedList.add(distributor.y);
                    networkedList.add(distributor.z);
                    networkedList.add(distributor.dim);
                }
            } else {
                networkedList.add(-1);
            }
            networkedList.add(Float.valueOf(this.bubbleSize));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)((float)this.func_174877_v().func_177958_n() - this.bubbleSize), (double)((float)this.func_174877_v().func_177956_o() - this.bubbleSize), (double)((float)this.func_174877_v().func_177952_p() - this.bubbleSize), (double)((float)this.func_174877_v().func_177958_n() + this.bubbleSize), (double)((float)this.func_174877_v().func_177956_o() + this.bubbleSize), (double)((float)this.func_174877_v().func_177952_p() + this.bubbleSize));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 262144.0;
    }

    public void readExtraNetworkedData(ByteBuf dataStream) {
        if (this.field_145850_b.field_72995_K) {
            int size = dataStream.readInt();
            if (size >= 0) {
                loadedTiles.clear();
                for (int i = 0; i < size; ++i) {
                    int i1 = dataStream.readInt();
                    int i2 = dataStream.readInt();
                    int i3 = dataStream.readInt();
                    int i4 = dataStream.readInt();
                    if (i1 == -1 && i2 == -1 && i3 == -1 && i4 == -1) continue;
                    loadedTiles.add(new BlockVec3Dim(i1, i2, i3, i4));
                }
            }
            this.bubbleSize = dataStream.readFloat();
        }
    }

    public int getDistanceFromServer(int par1, int par3, int par5) {
        int d3 = this.func_174877_v().func_177958_n() - par1;
        int d4 = this.func_174877_v().func_177956_o() - par3;
        int d5 = this.func_174877_v().func_177952_p() - par5;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.bubbleSize = this.getEnergyStoredGC() > 0.0f && this.hasEnoughEnergyToRun && !this.disabled ? 30.0f : 0.0f;
            this.bubbleSize = Math.min(Math.max(this.bubbleSize, 0.0f), 30.0f);
            BlockPos pos1 = new BlockPos((double)((float)this.field_174879_c.func_177958_n() - this.bubbleSize), (double)this.field_174879_c.func_177956_o(), (double)((float)this.field_174879_c.func_177952_p() - this.bubbleSize));
            BlockPos pos2 = new BlockPos((double)((float)this.field_174879_c.func_177958_n() + this.bubbleSize), (double)((float)this.field_174879_c.func_177956_o() + this.bubbleSize), (double)((float)this.field_174879_c.func_177952_p() + this.bubbleSize));
            for (Entity entities : this.field_145850_b.func_72872_a(EntityMeteor.class, new AxisAlignedBB(pos1, pos2))) {
                EntityMeteor meteor = (EntityMeteor)entities;
                GalaxySpace.debug("123");
                if (!this.inBubble(meteor.field_70142_S, meteor.field_70137_T, meteor.field_70136_U)) continue;
                this.shoot(meteor);
                meteor.func_70106_y();
            }
        }
    }

    public void shoot(EntityMeteor meteor) {
        double spawnX = (double)this.field_174879_c.func_177958_n() + 0.5;
        double spawnY = (double)this.field_174879_c.func_177956_o() + 1.5;
        double spawnZ = (double)this.field_174879_c.func_177952_p() + 0.5;
        EntityIceSpike arrow = new EntityIceSpike(this.field_145850_b, spawnX, spawnY, spawnZ);
        double X = meteor.field_70165_t - spawnX;
        double Y = meteor.field_70163_u + 0.5 - spawnY;
        double Z = meteor.field_70161_v - spawnZ;
        double length = 0.1;
        arrow.field_70159_w = X / length;
        arrow.field_70181_x = Y / length;
        arrow.field_70179_y = Z / length;
        this.field_145850_b.func_72838_d((Entity)arrow);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("bubbleVisible")) {
            this.setBubbleVisible(nbt.func_74767_n("bubbleVisible"));
        }
        if (nbt.func_74764_b("bubbleSize")) {
            this.bubbleSize = nbt.func_74760_g("bubbleSize");
        }
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.stacks);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("bubbleVisible", this.shouldRenderBubble);
        nbt.func_74776_a("bubbleSize", this.bubbleSize);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks);
        return nbt;
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.stacks.get(var1);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack oldstack = ItemStackHelper.func_188383_a(this.stacks, (int)index);
        if (!oldstack.func_190926_b()) {
            this.func_70296_d();
        }
        return oldstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"tile.laser_turret.name");
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemCharged((ItemStack)itemstack);
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItemEmpty((ItemStack)itemstack);
            }
        }
        return false;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (slotID == 0) {
            return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return this.hasEnoughEnergyToRun;
    }

    public EnumFacing getFront() {
        return EnumFacing.DOWN;
    }

    public EnumFacing getElectricInputDirection() {
        return this.getFront();
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public boolean inBubble(double pX, double pY, double pZ) {
        double r = this.bubbleSize;
        r *= r;
        double d3 = (double)this.func_174877_v().func_177958_n() + 0.5 - pX;
        if ((d3 *= d3) > r) {
            return false;
        }
        double d4 = (double)this.func_174877_v().func_177952_p() + 0.5 - pZ;
        if (d3 + (d4 *= d4) > r) {
            return false;
        }
        double d5 = (double)this.func_174877_v().func_177956_o() + 0.5 - pY;
        return d3 + d4 + d5 * d5 < r;
    }

    public void setBubbleVisible(boolean shouldRender) {
        this.shouldRenderBubble = shouldRender;
    }

    public float getBubbleSize() {
        return this.bubbleSize;
    }

    public boolean getBubbleVisible() {
        return this.shouldRenderBubble;
    }

    public Vector3 getColor() {
        return new Vector3((double)0.45f, 0.0, (double)0.1f);
    }

    protected NonNullList<ItemStack> getContainingItems() {
        return this.stacks;
    }
}

