/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.block.TileReconfigurable;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.init.TETextures;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileDeviceBase
extends TileReconfigurable {
    public static final SideConfig[] SIDE_CONFIGS = new SideConfig[BlockDevice.Type.values().length];
    public static final SideConfig[] ALT_SIDE_CONFIGS = new SideConfig[BlockDevice.Type.values().length];
    public static final SlotConfig[] SLOT_CONFIGS = new SlotConfig[BlockDevice.Type.values().length];
    public static final int[] LIGHT_VALUES = new int[BlockDevice.Type.values().length];
    protected static boolean enableSecurity = true;
    public static boolean disableAutoInput = false;
    public static boolean disableAutoOutput = false;

    public static void config() {
        String category = "Device";
        String comment = "If TRUE, Devices are securable.";
        enableSecurity = ThermalExpansion.CONFIG.get(category, "Securable", true, comment);
        comment = "If TRUE, most Devices will no longer have Auto-Input functionality. Not recommended, but knock yourself out.";
        disableAutoInput = ThermalExpansion.CONFIG.get(category, "DisableAutoInput", disableAutoInput, comment);
        comment = "If TRUE, most Devices will no longer have Auto-Output functionality. Not recommended, but knock yourself out.";
        disableAutoOutput = ThermalExpansion.CONFIG.get(category, "DisableAutoOutput", disableAutoOutput, comment);
    }

    public TileDeviceBase() {
        this.sideConfig = SIDE_CONFIGS[this.getType()];
        this.slotConfig = SLOT_CONFIGS[this.getType()];
        this.setDefaultSides();
        this.hasRedstoneControl = true;
    }

    protected Object getMod() {
        return ThermalExpansion.instance;
    }

    protected String getModVersion() {
        return "5.5.2";
    }

    protected String getTileName() {
        return "tile.thermalexpansion.device." + BlockDevice.Type.values()[this.getType()].func_176610_l() + ".name";
    }

    public int getLightValue() {
        return this.isActive ? LIGHT_VALUES[this.getType()] : 0;
    }

    public boolean isAugmentable() {
        return false;
    }

    public boolean enableSecurity() {
        return enableSecurity;
    }

    public boolean sendRedstoneUpdates() {
        return true;
    }

    public void onRedstoneUpdate() {
        boolean curActive = this.isActive;
        if (!this.redstoneControlOrDisable()) {
            this.isActive = false;
        }
        this.updateIfChanged(curActive);
    }

    public void setDefaultSides() {
        this.sideCache = this.getDefaultSides();
        this.sideCache[this.facing] = 0;
    }

    protected boolean setLevel(int level) {
        return false;
    }

    protected void setLevelFlags() {
        this.level = 0;
        this.hasRedstoneControl = true;
        if (disableAutoInput) {
            this.hasAutoInput = false;
        }
        if (disableAutoOutput) {
            this.hasAutoOutput = false;
        }
    }

    protected void updateIfChanged(boolean curActive) {
        if (curActive != this.isActive) {
            if (LIGHT_VALUES[this.getType()] != 0) {
                this.updateLighting();
            }
            this.sendTilePacket(Side.CLIENT);
        }
    }

    public boolean setFacing(int side, boolean alternate) {
        if (side < 2 || side > 5) {
            return false;
        }
        this.facing = (byte)side;
        this.sideCache[this.facing] = 0;
        this.markChunkDirty();
        this.sendTilePacket(Side.CLIENT);
        return true;
    }

    public int getNumPasses() {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.DEVICE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.DEVICE_TOP;
            }
            return side != this.facing ? TETextures.DEVICE_SIDE : (this.isActive ? TETextures.DEVICE_ACTIVE[this.getType()] : TETextures.DEVICE_FACE[this.getType()]);
        }
        if (side < 6) {
            return TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]];
        }
        return TETextures.DEVICE_SIDE;
    }

    public boolean canUpgrade(ItemStack upgrade) {
        return false;
    }

    public boolean installUpgrade(ItemStack upgrade) {
        return false;
    }

    public boolean hasFluidUnderlay() {
        return false;
    }

    public FluidStack getRenderFluid() {
        return null;
    }

    public int getColorMask(BlockRenderLayer layer, EnumFacing side) {
        return -1;
    }
}

