/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.net.message.multiblock;

import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorRedNetPort;
import erogenousbeef.bigreactors.net.helpers.RedNetChange;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.zerocore.lib.network.ModTileEntityMessage;
import it.zerono.mods.zerocore.lib.network.ModTileEntityMessageHandlerServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ReactorRedNetPortChangeMessage
extends ModTileEntityMessage {
    private RedNetChange[] changes;

    public ReactorRedNetPortChangeMessage() {
        this.changes = null;
    }

    public ReactorRedNetPortChangeMessage(TileEntityReactorRedNetPort port, RedNetChange[] changes) {
        super((TileEntity)port);
        this.changes = changes;
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        int numChanges = buf.readInt();
        if (numChanges < 1) {
            return;
        }
        this.changes = new RedNetChange[numChanges];
        for (int i = 0; i < numChanges; ++i) {
            this.changes[i] = RedNetChange.fromBytes(buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        if (this.changes == null || this.changes.length < 1) {
            buf.writeInt(0);
            return;
        }
        buf.writeInt(this.changes.length);
        for (int i = 0; i < this.changes.length; ++i) {
            this.changes[i].toBytes(buf);
        }
    }

    public static class Handler
    extends ModTileEntityMessageHandlerServer<ReactorRedNetPortChangeMessage> {
        protected void processTileEntityMessage(ReactorRedNetPortChangeMessage message, MessageContext ctx, TileEntity tileEntity) {
            if (tileEntity instanceof TileEntityReactorRedNetPort) {
                TileEntityReactorRedNetPort port = (TileEntityReactorRedNetPort)tileEntity;
                port.onCircuitUpdate(message.changes);
            }
        }
    }
}

