/*
 * Decompiled with CFR 0.152.
 */
package nc.gui.generator;

import com.google.common.collect.Lists;
import java.util.List;
import nc.config.NCConfig;
import nc.container.generator.ContainerFusionCore;
import nc.gui.GuiFluidRenderer;
import nc.gui.NCGui;
import nc.gui.NCGuiButton;
import nc.gui.NCGuiToggleButton;
import nc.network.PacketHandler;
import nc.network.gui.EmptyTankButtonPacket;
import nc.network.gui.GetFluidInTankPacket;
import nc.network.gui.ToggleAlternateComparatorButtonPacket;
import nc.network.gui.ToggleTanksEmptyUnusableButtonPacket;
import nc.network.gui.ToggleTanksSharedButtonPacket;
import nc.network.gui.ToggleVoidExcessOutputsButtonPacket;
import nc.tile.energy.ITileEnergy;
import nc.tile.generator.TileFusionCore;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.UnitHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiFusionCore
extends NCGui {
    public static int tick;
    public static FluidStack fluid0;
    public static FluidStack fluid1;
    public static FluidStack fluid2;
    public static FluidStack fluid3;
    public static FluidStack fluid4;
    public static FluidStack fluid5;
    public static FluidStack fluid6;
    public static FluidStack fluid7;
    private final InventoryPlayer playerInventory;
    protected TileFusionCore tile;
    protected final ResourceLocation gui_textures;

    public GuiFusionCore(EntityPlayer player, TileFusionCore tile) {
        super(new ContainerFusionCore(player, tile));
        this.playerInventory = player.field_71071_by;
        this.tile = tile;
        this.gui_textures = new ResourceLocation("nuclearcraft:textures/gui/container/fusion_core.png");
        this.field_146999_f = 196;
        this.field_147000_g = 187;
    }

    @Override
    public void renderTooltips(int mouseX, int mouseY) {
        this.drawTooltip(Lang.localise("gui.container.change_tanks_mode"), mouseX, mouseY, 171, 104, 18, 18);
        this.drawTooltip(Lang.localise("gui.container.void_leftover_fluid"), mouseX, mouseY, 171, 123, 18, 18);
        this.drawTooltip(Lang.localise("gui.container.void_outputs"), mouseX, mouseY, 171, 142, 18, 18);
        this.drawTooltip(Lang.localise("gui.container.comparator_mode"), mouseX, mouseY, 171, 162, 18, 18);
        this.drawFluidTooltip(fluid0, this.tile.getTanks().get(0), mouseX, mouseY, 38, 6, 6, 46);
        this.drawFluidTooltip(fluid1, this.tile.getTanks().get(1), mouseX, mouseY, 38, 55, 6, 46);
        this.drawFluidTooltip(fluid2, this.tile.getTanks().get(2), mouseX, mouseY, 172, 6, 6, 46);
        this.drawFluidTooltip(fluid3, this.tile.getTanks().get(3), mouseX, mouseY, 182, 6, 6, 46);
        this.drawFluidTooltip(fluid4, this.tile.getTanks().get(4), mouseX, mouseY, 172, 55, 6, 46);
        this.drawFluidTooltip(fluid5, this.tile.getTanks().get(5), mouseX, mouseY, 182, 55, 6, 46);
        this.drawEnergyTooltip(this.tile, mouseX, mouseY, 8, 6, 6, 95);
        this.drawHeatTooltip(mouseX, mouseY, 18, 6, 6, 95);
        this.drawEfficiencyTooltip(mouseX, mouseY, 28, 6, 6, 95);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String input1;
        int fontColor = this.tile.isProcessing ? -1 : (this.tile.complete == 1 ? 0xEEAA00 : 0xEE0000);
        String name = Lang.localise("gui.container.fusion_core.reactor");
        this.field_146289_q.func_78276_b(name, 108 - this.widthHalf(name), 10, fontColor);
        String size = this.tile.complete == 1 ? Lang.localise("gui.container.fusion_core.size") + " " + this.tile.size : this.tile.problem;
        this.field_146289_q.func_78276_b(size, 108 - this.widthHalf(size), 21, fontColor);
        String energy = Lang.localise("gui.container.fusion_core.energy") + " " + UnitHelper.prefix(this.tile.getEnergyStorage().getEnergyStored(), 6, "RF");
        this.field_146289_q.func_78276_b(energy, 108 - this.widthHalf(energy), 32, fontColor);
        String power = Lang.localise("gui.container.fusion_core.power") + " " + UnitHelper.prefix((int)this.tile.processPower, 6, "RF/t");
        this.field_146289_q.func_78276_b(power, 108 - this.widthHalf(power), 43, fontColor);
        String heat = Lang.localise("gui.container.fusion_core.heat") + " " + UnitHelper.prefix((long)((int)this.tile.heat), 6, "K", 1);
        this.field_146289_q.func_78276_b(heat, 108 - this.widthHalf(heat), 54, fontColor);
        String efficiency = Lang.localise("gui.container.fusion_core.efficiency") + " " + (int)this.tile.efficiency + "%";
        this.field_146289_q.func_78276_b(efficiency, 108 - this.widthHalf(efficiency), 65, fontColor);
        String string = fluid0 != null ? fluid0.getLocalizedName() : (input1 = fluid6 != null ? fluid6.getLocalizedName() : TileFusionCore.NO_FUEL);
        String input2 = fluid1 != null ? fluid1.getLocalizedName() : (fluid7 != null ? fluid7.getLocalizedName() : TileFusionCore.NO_FUEL);
        this.field_146289_q.func_78276_b(input1, 108 - this.widthHalf(input1), 76, fontColor);
        this.field_146289_q.func_78276_b(input2, 108 - this.widthHalf(input2), 87, fontColor);
    }

    @Override
    public List<String> energyInfo(ITileEnergy tile) {
        String energy = UnitHelper.prefix((long)tile.getEnergyStorage().getEnergyStored(), (long)tile.getEnergyStorage().getMaxEnergyStored(), 6, "RF");
        String power = UnitHelper.prefix((int)this.tile.processPower, 6, "RF/t");
        return Lists.newArrayList((Object[])new String[]{TextFormatting.LIGHT_PURPLE + Lang.localise("gui.container.energy_stored") + TextFormatting.WHITE + " " + energy, TextFormatting.LIGHT_PURPLE + Lang.localise("gui.container.power_gen") + TextFormatting.WHITE + " " + power});
    }

    public List<String> heatInfo() {
        String heat = UnitHelper.prefix((long)((int)this.tile.heat), this.tile.isHotEnough() ? (long)((int)this.tile.getMaxHeat()) : 8000L, 6, "K", 1) + (this.tile.isHotEnough() ? "" : " [" + Math.round(this.tile.heat / 80.0) + "%]");
        String heatChange = UnitHelper.prefix((long)((int)this.tile.heatChange), 6, "K/t", 0);
        String cooling = UnitHelper.prefix((long)((int)this.tile.cooling), 6, "K/t", 0);
        if ((int)this.tile.cooling == 0 || !NCConfig.fusion_active_cooling) {
            return Lists.newArrayList((Object[])new String[]{TextFormatting.YELLOW + Lang.localise("gui.container.fusion_core.temperature") + TextFormatting.WHITE + " " + heat, TextFormatting.YELLOW + Lang.localise("gui.container.fusion_core.temperature_change") + TextFormatting.WHITE + " " + heatChange});
        }
        int coolingPercentage = (int)(0.1 * this.tile.cooling / (5.0 * NCConfig.fusion_heat_generation));
        return Lists.newArrayList((Object[])new String[]{TextFormatting.YELLOW + Lang.localise("gui.container.fusion_core.temperature") + TextFormatting.WHITE + " " + heat, TextFormatting.YELLOW + Lang.localise("gui.container.fusion_core.temperature_change") + TextFormatting.WHITE + " " + heatChange, TextFormatting.BLUE + Lang.localise("gui.container.fusion_core.cooling_rate") + TextFormatting.WHITE + " " + cooling + " [" + coolingPercentage + "%]"});
    }

    public void drawHeatTooltip(int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(this.heatInfo(), mouseX, mouseY, x, y, width, height);
    }

    public List<String> efficiencyInfo() {
        String efficiency = NCMath.round(this.tile.efficiency, 1) + "%";
        return Lists.newArrayList((Object[])new String[]{TextFormatting.AQUA + Lang.localise("gui.container.fusion_core.efficiency") + TextFormatting.WHITE + " " + efficiency});
    }

    public void drawEfficiencyTooltip(int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(this.efficiencyInfo(), mouseX, mouseY, x, y, width, height);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.gui_textures);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        double energy = Math.round((double)this.tile.getEnergyStorage().getEnergyStored() / (double)this.tile.getEnergyStorage().getMaxEnergyStored() * 95.0);
        this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 6 + 95 - (int)energy, 196, 185 - (int)energy, 6, (int)energy);
        double h = Math.round(this.tile.heat / (this.tile.isHotEnough() ? this.tile.getMaxHeat() : 8000.0) * 95.0);
        this.func_73729_b(this.field_147003_i + 18, this.field_147009_r + 6 + 95 - (int)h, 202, 185 - (int)h, 6, (int)h);
        double efficiency = Math.round(this.tile.efficiency / 100.0 * 95.0);
        this.func_73729_b(this.field_147003_i + 28, this.field_147009_r + 6 + 95 - (int)efficiency, 208, 185 - (int)efficiency, 6, (int)efficiency);
        ++tick;
        if ((tick %= 5) == 0) {
            this.sendTankInfo();
        }
        GuiFluidRenderer.renderGuiTank(fluid0, this.tile.getTanks().get(0).getCapacity(), this.field_147003_i + 38, this.field_147009_r + 6, this.field_73735_i, 6.0, 46.0);
        GuiFluidRenderer.renderGuiTank(fluid1, this.tile.getTanks().get(1).getCapacity(), this.field_147003_i + 38, this.field_147009_r + 55, this.field_73735_i, 6.0, 46.0);
        GuiFluidRenderer.renderGuiTank(fluid2, this.tile.getTanks().get(2).getCapacity(), this.field_147003_i + 172, this.field_147009_r + 6, this.field_73735_i, 6.0, 46.0);
        GuiFluidRenderer.renderGuiTank(fluid3, this.tile.getTanks().get(3).getCapacity(), this.field_147003_i + 182, this.field_147009_r + 6, this.field_73735_i, 6.0, 46.0);
        GuiFluidRenderer.renderGuiTank(fluid4, this.tile.getTanks().get(4).getCapacity(), this.field_147003_i + 172, this.field_147009_r + 55, this.field_73735_i, 6.0, 46.0);
        GuiFluidRenderer.renderGuiTank(fluid5, this.tile.getTanks().get(5).getCapacity(), this.field_147003_i + 182, this.field_147009_r + 55, this.field_73735_i, 6.0, 46.0);
    }

    @Override
    public void func_73866_w_() {
        this.sendTankInfo();
        super.func_73866_w_();
        this.field_146292_n.add(new NCGuiButton.EmptyTankButton(0, this.field_147003_i + 38, this.field_147009_r + 6, 6, 46));
        this.field_146292_n.add(new NCGuiButton.EmptyTankButton(1, this.field_147003_i + 38, this.field_147009_r + 55, 6, 46));
        this.field_146292_n.add(new NCGuiButton.EmptyTankButton(2, this.field_147003_i + 172, this.field_147009_r + 6, 6, 46));
        this.field_146292_n.add(new NCGuiButton.EmptyTankButton(3, this.field_147003_i + 182, this.field_147009_r + 6, 6, 46));
        this.field_146292_n.add(new NCGuiButton.EmptyTankButton(4, this.field_147003_i + 172, this.field_147009_r + 55, 6, 46));
        this.field_146292_n.add(new NCGuiButton.EmptyTankButton(5, this.field_147003_i + 182, this.field_147009_r + 55, 6, 46));
        this.field_146292_n.add(new NCGuiToggleButton.ToggleTanksSharedButton(6, this.field_147003_i + 171, this.field_147009_r + 104, this.tile));
        this.field_146292_n.add(new NCGuiToggleButton.ToggleTanksEmptyUnusableButton(7, this.field_147003_i + 171, this.field_147009_r + 123, this.tile));
        this.field_146292_n.add(new NCGuiToggleButton.ToggleVoidExcessOutputsButton(8, this.field_147003_i + 171, this.field_147009_r + 142, this.tile));
        this.field_146292_n.add(new NCGuiToggleButton.ToggleAlternateComparatorButton(9, this.field_147003_i + 171, this.field_147009_r + 162, this.tile));
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (this.tile.func_145831_w().field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                if (guiButton.field_146127_k != i || !GuiFusionCore.func_146272_n()) continue;
                PacketHandler.instance.sendToServer((IMessage)new EmptyTankButtonPacket(this.tile, i));
            }
            if (guiButton.field_146127_k == 6) {
                this.tile.setTanksShared(!this.tile.getTanksShared());
                PacketHandler.instance.sendToServer((IMessage)new ToggleTanksSharedButtonPacket(this.tile));
            }
            if (guiButton.field_146127_k == 7) {
                this.tile.setEmptyUnusableTankInputs(!this.tile.getEmptyUnusableTankInputs());
                PacketHandler.instance.sendToServer((IMessage)new ToggleTanksEmptyUnusableButtonPacket(this.tile));
            }
            if (guiButton.field_146127_k == 8) {
                this.tile.setVoidExcessFluidOutputs(!this.tile.getVoidExcessFluidOutputs());
                PacketHandler.instance.sendToServer((IMessage)new ToggleVoidExcessOutputsButtonPacket(this.tile));
            }
            if (guiButton.field_146127_k == 9) {
                this.tile.setAlternateComparator(!this.tile.getAlternateComparator());
                PacketHandler.instance.sendToServer((IMessage)new ToggleAlternateComparatorButtonPacket(this.tile));
            }
        }
    }

    protected void sendTankInfo() {
        PacketHandler.instance.sendToServer((IMessage)new GetFluidInTankPacket(this.tile.func_174877_v(), 0, "nc.gui.generator.GuiFusionCore", "fluid0"));
        PacketHandler.instance.sendToServer((IMessage)new GetFluidInTankPacket(this.tile.func_174877_v(), 1, "nc.gui.generator.GuiFusionCore", "fluid1"));
        PacketHandler.instance.sendToServer((IMessage)new GetFluidInTankPacket(this.tile.func_174877_v(), 2, "nc.gui.generator.GuiFusionCore", "fluid2"));
        PacketHandler.instance.sendToServer((IMessage)new GetFluidInTankPacket(this.tile.func_174877_v(), 3, "nc.gui.generator.GuiFusionCore", "fluid3"));
        PacketHandler.instance.sendToServer((IMessage)new GetFluidInTankPacket(this.tile.func_174877_v(), 4, "nc.gui.generator.GuiFusionCore", "fluid4"));
        PacketHandler.instance.sendToServer((IMessage)new GetFluidInTankPacket(this.tile.func_174877_v(), 5, "nc.gui.generator.GuiFusionCore", "fluid5"));
        PacketHandler.instance.sendToServer((IMessage)new GetFluidInTankPacket(this.tile.func_174877_v(), 6, "nc.gui.generator.GuiFusionCore", "fluid6"));
        PacketHandler.instance.sendToServer((IMessage)new GetFluidInTankPacket(this.tile.func_174877_v(), 7, "nc.gui.generator.GuiFusionCore", "fluid7"));
    }

    static {
        fluid7 = null;
    }
}

