/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.jei.multiblock;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import nc.config.NCConfig;
import nc.integration.jei.IJEIHandler;
import nc.integration.jei.JEICategoryAbstract;
import nc.integration.jei.JEIMethods;
import nc.integration.jei.JEIRecipeWrapper;
import nc.recipe.IngredientSorption;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.UnitHelper;
import net.minecraft.util.text.TextFormatting;

public class SaltFissionCategory
extends JEICategoryAbstract<JEIRecipeWrapper.SaltFission> {
    private static final String FUEL_TIME = Lang.localise("jei.nuclearcraft.salt_fuel_time");
    private static final String FUEL_HEAT = Lang.localise("jei.nuclearcraft.salt_fuel_heat");

    public SaltFissionCategory(IGuiHelper guiHelper, IJEIHandler handler) {
        super(guiHelper, handler, "salt_fission_vessel", 47, 30, 90, 26);
        this.recipeTitle = Lang.localise("nuclearcraft.multiblock_gui.salt_fission.jei_name");
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, JEIRecipeWrapper.SaltFission recipeWrapper, IIngredients ingredients) {
        super.setRecipe(recipeLayout, recipeWrapper, ingredients);
        JEIMethods.RecipeFluidMapper fluidMapper = new JEIMethods.RecipeFluidMapper();
        fluidMapper.map(IngredientSorption.INPUT, 0, 0, 56 - this.backPosX, 35 - this.backPosY, 16, 16);
        fluidMapper.map(IngredientSorption.OUTPUT, 0, 1, 112 - this.backPosX, 31 - this.backPosY, 24, 24);
        fluidMapper.mapFluidsTo(recipeLayout.getFluidStacks(), ingredients);
        recipeLayout.getFluidStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            tooltip.add(TextFormatting.GREEN + FUEL_TIME + " " + TextFormatting.WHITE + UnitHelper.applyTimeUnitShort(NCMath.round(recipeWrapper.recipe.getSaltFissionFuelTime() / NCConfig.salt_fission_fuel_use, 2), 2));
            tooltip.add(TextFormatting.YELLOW + FUEL_HEAT + " " + TextFormatting.WHITE + UnitHelper.prefix(recipeWrapper.recipe.getSaltFissionFuelHeat() * NCConfig.salt_fission_heat_generation, 5, "H/t"));
        });
    }

    @Override
    public String getTitle() {
        return this.recipeTitle;
    }
}

