/*
 * Decompiled with CFR 0.152.
 */
package nc.tile;

import javax.annotation.Nullable;
import nc.block.tile.IActivatable;
import nc.capability.radiation.IRadiationSource;
import nc.capability.radiation.RadiationSource;
import nc.tile.ITile;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public abstract class NCTile
extends TileEntity
implements ITickable,
ITile {
    public boolean isAdded;
    public boolean isMarkedDirty;
    public boolean alternateComparator;
    private IRadiationSource radiation = new RadiationSource();

    public void func_73660_a() {
        if (!this.isAdded) {
            this.onAdded();
            this.isAdded = true;
        }
        if (this.isMarkedDirty) {
            this.func_70296_d();
            this.isMarkedDirty = false;
        }
    }

    public void onAdded() {
        if (this.field_145850_b.field_72995_K) {
            this.func_145831_w().func_175704_b(this.field_174879_c, this.field_174879_c);
            this.func_145831_w().func_175726_f(this.func_174877_v()).func_76630_e();
        }
        this.func_70296_d();
    }

    @Override
    public World getTileWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getTilePos() {
        return this.func_174877_v();
    }

    @Override
    public void markTileDirty() {
        this.func_70296_d();
    }

    @Override
    public Block getTileBlockType() {
        return this.func_145838_q();
    }

    @Override
    public IRadiationSource getRadiationSource() {
        return this.radiation;
    }

    public ITextComponent func_145748_c_() {
        if (this.func_145838_q() != null) {
            return new TextComponentTranslation(this.func_145838_q().func_149732_F(), new Object[0]);
        }
        return null;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        String oldName = oldState.func_177230_c().func_149739_a().toString();
        String newName = newState.func_177230_c().func_149739_a().toString();
        if (oldName.contains("_idle") || oldName.contains("_active")) {
            return !oldName.replace("_idle", "").replace("_active", "").equals(newName.replace("_idle", "").replace("_active", ""));
        }
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public IBlockState getDefaultBlockState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c().func_176223_P();
    }

    @Override
    public void setState(boolean isActive) {
        if (this.func_145838_q() instanceof IActivatable) {
            ((IActivatable)this.func_145838_q()).setState(isActive, this.field_145850_b, this.field_174879_c);
        }
    }

    public NBTTagCompound writeRadiation(NBTTagCompound nbt) {
        nbt.func_74780_a("radiationLevel", this.getRadiationSource().getRadiationLevel());
        return nbt;
    }

    public void readRadiation(NBTTagCompound nbt) {
        if (nbt.func_74764_b("radiationLevel")) {
            this.getRadiationSource().setRadiationLevel(nbt.func_74769_h("radiationLevel"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeAll(nbt);
        return nbt;
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        nbt.func_74757_a("alternateComparator", this.alternateComparator);
        if (this.shouldSaveRadiation()) {
            this.writeRadiation(nbt);
        }
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readAll(nbt);
    }

    public void readAll(NBTTagCompound nbt) {
        this.setAlternateComparator(nbt.func_74767_n("alternateComparator"));
        if (this.shouldSaveRadiation()) {
            this.readRadiation(nbt);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        int metadata = this.func_145832_p();
        return new SPacketUpdateTileEntity(this.field_174879_c, metadata, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
    }

    public boolean getAlternateComparator() {
        return this.alternateComparator;
    }

    public void setAlternateComparator(boolean alternate) {
        this.alternateComparator = alternate;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return this.radiation != null;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == IRadiationSource.CAPABILITY_RADIATION_SOURCE) {
            return (T)this.radiation;
        }
        return (T)super.getCapability(capability, side);
    }

    protected boolean hasCapabilityDefault(Capability<?> capability, @Nullable EnumFacing side) {
        return super.hasCapability(capability, side);
    }

    protected <T> T getCapabilityDefault(Capability<T> capability, @Nullable EnumFacing side) {
        return (T)super.getCapability(capability, side);
    }
}

