/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.control;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;

public class PlayerInputMap {
    protected static final Map<String, PlayerInputMap> playerInputs = new HashMap<String, PlayerInputMap>();
    public PlayerInputMap lastSentMap;
    public float forwardKey;
    public float strafeKey;
    public boolean jumpKey;
    public boolean sneakKey;
    public boolean downKey;
    public double motionX;
    public double motionY;
    public double motionZ;

    public PlayerInputMap(PlayerInputMap master) {
        this.setTo(master);
    }

    public PlayerInputMap(String playerName) {
        playerInputs.put(playerName, this);
        this.lastSentMap = new PlayerInputMap(this);
    }

    public static PlayerInputMap getInputMapFor(String playerName) {
        PlayerInputMap map = playerInputs.get(playerName);
        if (map == null) {
            map = new PlayerInputMap(playerName);
        }
        return map;
    }

    public boolean writeToByteBuf(ByteBuf buf) {
        buf.writeFloat(this.forwardKey);
        buf.writeFloat(this.strafeKey);
        buf.writeBoolean(this.jumpKey);
        buf.writeBoolean(this.sneakKey);
        buf.writeBoolean(this.downKey);
        buf.writeDouble(this.motionX);
        buf.writeDouble(this.motionY);
        buf.writeDouble(this.motionZ);
        return true;
    }

    public PlayerInputMap readFromByteBuf(ByteBuf buf) {
        this.forwardKey = buf.readFloat();
        this.strafeKey = buf.readFloat();
        this.jumpKey = buf.readBoolean();
        this.sneakKey = buf.readBoolean();
        this.downKey = buf.readBoolean();
        this.motionX = buf.readDouble();
        this.motionY = buf.readDouble();
        this.motionZ = buf.readDouble();
        return this;
    }

    public boolean equals(Object obj) {
        try {
            PlayerInputMap other = (PlayerInputMap)obj;
            return other.forwardKey == this.forwardKey && other.strafeKey == this.strafeKey && other.jumpKey == this.jumpKey && other.sneakKey == this.sneakKey && other.downKey == this.downKey && other.motionX == this.motionX && other.motionY == this.motionY && other.motionZ == this.motionZ;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public void setTo(PlayerInputMap master) {
        this.forwardKey = master.forwardKey;
        this.strafeKey = master.strafeKey;
        this.jumpKey = master.jumpKey;
        this.sneakKey = master.sneakKey;
        this.downKey = master.downKey;
        this.motionX = master.motionX;
        this.motionY = master.motionY;
        this.motionZ = master.motionZ;
    }

    public boolean hasChanged() {
        return this.equals(this.lastSentMap);
    }

    public void refresh() {
        this.lastSentMap.setTo(this);
    }
}

