/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.world.gen.dungeon;

import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.Corridor;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonConfiguration;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonStart;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomBoss;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomChest;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomEmpty;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomEntrance;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomSpawner;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomTreasure;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenDungeon
extends MapGenStructure {
    private static boolean initialized;
    private DungeonConfiguration configuration;

    public MapGenDungeon(DungeonConfiguration configuration) {
        this.configuration = configuration;
    }

    public static void initiateStructures() throws Throwable {
        if (!initialized) {
            MapGenStructureIO.func_143034_b(Start.class, (String)"MoonDungeon");
            MapGenStructureIO.func_143031_a(DungeonStart.class, (String)"MoonDungeonStart");
            MapGenStructureIO.func_143031_a(Corridor.class, (String)"MoonDungeonCorridor");
            MapGenStructureIO.func_143031_a(RoomEmpty.class, (String)"MoonDungeonEmptyRoom");
            MapGenStructureIO.func_143031_a(RoomBoss.class, (String)"MoonDungeonBossRoom");
            MapGenStructureIO.func_143031_a(RoomTreasure.class, (String)"MoonDungeonTreasureRoom");
            MapGenStructureIO.func_143031_a(RoomSpawner.class, (String)"MoonDungeonSpawnerRoom");
            MapGenStructureIO.func_143031_a(RoomChest.class, (String)"MoonDungeonChestRoom");
            MapGenStructureIO.func_143031_a(RoomEntrance.class, (String)"MoonDungeonEntranceRoom");
        }
        initialized = true;
    }

    public String func_143025_a() {
        return "GC_Dungeon";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        long dungeonPos = MapGenDungeon.getDungeonPosForCoords(this.field_75039_c, chunkX, chunkZ, ((IGalacticraftWorldProvider)this.field_75039_c.field_73011_w).getDungeonSpacing());
        int i = (int)(dungeonPos >> 32);
        int j = (int)dungeonPos;
        return i == chunkX && j == chunkZ;
    }

    public static long getDungeonPosForCoords(World world, int chunkX, int chunkZ, int spacing) {
        int numChunks = spacing / 16;
        if (chunkX < 0) {
            chunkX -= numChunks - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= numChunks - 1;
        }
        int k = chunkX / numChunks;
        int l = chunkZ / numChunks;
        long seed = (long)k * 341873128712L + (long)l * 132897987541L + world.func_72912_H().func_76063_b() + (long)(10387340 + world.field_73011_w.getDimension());
        Random random = new Random();
        random.setSeed(seed);
        k = k * numChunks + random.nextInt(numChunks);
        l = l * numChunks + random.nextInt(numChunks);
        return ((long)k << 32) + (long)l;
    }

    public static float directionToNearestDungeon(World world, double xpos, double zpos) {
        int spacing = ((IGalacticraftWorldProvider)world.field_73011_w).getDungeonSpacing();
        if (spacing == 0) {
            return 0.0f;
        }
        int x = MathHelper.func_76128_c((double)xpos);
        int z = MathHelper.func_76128_c((double)zpos);
        int quadrantX = x % spacing;
        int quadrantZ = z % spacing;
        int searchOffsetX = quadrantX / (spacing / 2);
        int searchOffsetZ = quadrantZ / (spacing / 2);
        double nearestX = 0.0;
        double nearestZ = 0.0;
        double nearestDistance = Double.MAX_VALUE;
        for (int cx = searchOffsetX - 1; cx < searchOffsetX + 1; ++cx) {
            for (int cz = searchOffsetZ - 1; cz < searchOffsetZ + 1; ++cz) {
                int j;
                double oZ;
                long dungeonPos = MapGenDungeon.getDungeonPosForCoords(world, (x + cx * spacing) / 16, (z + cz * spacing) / 16, spacing);
                int i = 2 + ((int)(dungeonPos >> 32) << 4);
                double oX = (double)i - xpos;
                double distanceSq = oX * oX + (oZ = (double)(j = 2 + ((int)dungeonPos << 4)) - zpos) * oZ;
                if (!(distanceSq < nearestDistance)) continue;
                nearestDistance = distanceSq;
                nearestX = oX;
                nearestZ = oZ;
            }
        }
        return GCCoreUtil.getAngleForRelativePosition(nearestX, nearestZ);
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ, this.configuration);
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean p_180706_3_) {
        return null;
    }

    static {
        try {
            MapGenDungeon.initiateStructures();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class Start
    extends StructureStart {
        private DungeonConfiguration configuration;

        public Start() {
        }

        public Start(World worldIn, Random rand, int chunkX, int chunkZ, DungeonConfiguration configuration) {
            super(chunkX, chunkZ);
            this.configuration = configuration;
            DungeonStart startPiece = new DungeonStart(worldIn, configuration, rand, (chunkX << 4) + 2, (chunkZ << 4) + 2);
            startPiece.func_74861_a(startPiece, this.field_75075_a, rand);
            List<StructureComponent> list = startPiece.attachedComponents;
            while (!list.isEmpty()) {
                int i = rand.nextInt(list.size());
                StructureComponent structurecomponent = list.remove(i);
                structurecomponent.func_74861_a((StructureComponent)startPiece, this.field_75075_a, rand);
            }
            this.func_75072_c();
        }
    }
}

